/*
 * 创建日期: 2006-5-26
 *
 * 
 *  
 * 功能描述：
 *
 */

package util;

import jun.db.core.ObjectTool;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTool
{


	public Date    createDate( Object year , Object month , Object day)
	{
		return createDate( year, month , day , "0","0","0" );
	}
	
	public Date    createDate( Object year , Object month , Object day  , Object  hour, Object minute , Object second)
	{
		if ( year==null) return null;
		if ( month==null) return null;
		if ( day==null ) return null;
		if ( hour==null) return null;
		if ( minute==null) return null;
		if ( second==null) return null;
		
		
		
		int y=  String2Int(year.toString());
		int m= String2Int(month.toString());
		int d= String2Int(day.toString());
		
		int h=  String2Int(hour.toString());
		int M=   String2Int(minute.toString());
		int s=  String2Int(second.toString());
		
		if ( year instanceof Number) y= ((Number)year).intValue();
		if ( month instanceof Number) m= ((Number)month).intValue();
		if ( day instanceof Number) d= ((Number)day).intValue();
		if ( hour instanceof Number) h= ((Number)hour).intValue();
		if ( minute instanceof Number) M= ((Number)minute).intValue();
		if ( second instanceof Number) s= ((Number)second).intValue();
		 
		
		Calendar cal= Calendar.getInstance();
		cal.set(y, m-1 ,d , h,M,s);
		return cal.getTime();
	}
	
	
	public String  date2yyyymmdd(Object d)
	{
		if( d==null) return "";
		Date dd;
		if( d instanceof Date)
		{
			dd=(Date)d;
		}else
		{
			try
			{
			dd= (Date)ObjectTool.ChangeType(d , ObjectTool.java_util_Date);
			}catch(Exception e)
			{
				return null;
			}
		}
		
		SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd");
		
		return SDF.format((Date) dd);
		
	}
	
	public   int hoursBetween(Date big , Date small)
	{
		if( big==null || small==null) return 0;
		long betweenHours =  (long) Math.floor( (big.getTime() -small.getTime())*1.0 / (1000 * 60 * 60));
		 
		return (int) betweenHours;
	}

	public   int minutesBetween(Date big , Date small)
	{
		if( big==null || small==null) return 0;
		long betweenMinute = (long) Math.floor(  ( big.getTime() - small.getTime() )*1.0 / (1000 * 60  ) );
	 	return (int) betweenMinute;
	}

	public int secondsBetween(Date big, Date small)
	{
		if( big==null || small==null) return 0;
		long betweenMinute = (long) Math.floor(  ( big.getTime() - small.getTime() )*1.0 / (1000   ) );
	 	return (int) betweenMinute;
	}

	
	public   int daysBetween(Date big , Date small)
	{
		if( big==null || small==null) return 0;
	
		if( big==null) return 0;
		if(small==null) return 0;
		
		long betweenDays =   (long) Math.floor( (big.getTime() -small.getTime())*1.0/ (1000 * 60 * 60*24));
		 
		return (int) betweenDays;
	}
	
	
	public   Date  yyyyMMdd2Date(String s  )
	{

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
		ParsePosition p = new ParsePosition(0);
		try
		{
			Date d = sdf.parse(s, p);
	 
			return d;
		}
		catch (Exception e)
		{
			return null;
		}

	}

	public   Date  string2Date(String s   , String format )
	{

		SimpleDateFormat sdf = new SimpleDateFormat(format);
		ParsePosition p = new ParsePosition(0);
		try
		{
			Date d = sdf.parse(s, p);

			return d;
		}
		catch (Exception e)
		{
			return null;
		}

	}

	
	//保证 星期一是1
	public   int   getDayOfWeek( Date d )
	{
		if( d==null) return 0;
		
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		int week= cal.get( Calendar.DAY_OF_WEEK);
		if (week == Calendar.SATURDAY) return 6;
		if (week == Calendar.SUNDAY) return 7;
		return week - Calendar.MONDAY + 1;
	}
	
	public boolean isMonday( Date d)
	{
		return getDayOfWeek(d)==1;
	}
	
	public boolean isTuesday( Date d)
	{
		return getDayOfWeek(d)==2;
	}
	
	public boolean isWednesday( Date d)
	{
		return getDayOfWeek(d)==3;
	}
	
	public boolean isThursday( Date d)
	{
		return getDayOfWeek(d)==4;
	}
	
	public boolean isFriday( Date d)
	{
		return getDayOfWeek(d)==5;
	}
	
	public boolean isSaturday( Date d)
	{
		return getDayOfWeek(d)==6;
	}
	
	public boolean isSunday( Date d)
	{
		return getDayOfWeek(d)==7;
	}
	
	public int getDayOfMonth( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.DAY_OF_MONTH);
		
	}
	
  
	
	public int getDayOfYear ( Date d)
	{
		if( d==null) return 0;
		
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.DAY_OF_YEAR);
		
	}
	
	public int getHourOfDay( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.HOUR_OF_DAY);
		
	}
	
	public int getSecond( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.SECOND);
		
	}
	
	public int getMinute( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.MINUTE);
		
	}
	
	public int getWeekOfMonth( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.WEEK_OF_MONTH);
		
	}
	
	public int getWeekOfYear( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.WEEK_OF_YEAR);
		
	}
	
	public boolean isAfterDate( Date d1 , Date d2)
	{
		if( d1==null) return false;
		if( d2==null) return false;
		
		
		return d1.after(d2);
	}
	
	public  boolean isBeforeDate( Date d1 , Date d2)
	{
		if( d1==null) return false;
		if( d2==null) return false;
		
		return d1.before(d2);
	}
	
	public Date  nextDate(Date d  , int n )
	{
		if( d ==null) return null;
		 
		return nextDate( d,n, "day");
	}
	public Date  nextDate(Date d  , int n , String what)
	{
		if( d ==null) return null;
		 
		Date ret = (Date) d.clone();
		Calendar cal = Calendar.getInstance();
		cal.setTime(ret);
		if( what.equals("day"))  cal.add(Calendar.DAY_OF_MONTH, n);
		if( what.equals("minute"))  cal.add(Calendar.MINUTE, n);
		if( what.equals("second"))  cal.add(Calendar.SECOND, n);
		if( what.equals("hour"))  cal.add(Calendar.HOUR_OF_DAY , n);
		if( what.equals("month"))  cal.add(Calendar.MONTH, n);
		if( what.equals("year"))  cal.add(Calendar.YEAR, n);
  		return cal.getTime();

	}
	
	
	public int getYear( Date d)
	{
		
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.YEAR);
		
	}
	
	
	public int getMonth( Date d)
	{
		if( d==null) return 0;
		Calendar cal= Calendar.getInstance();
		cal.setTime(d);
		return cal.get( Calendar.MONTH) +1;
		
	}
	
	
	
		
	
	
	public static int String2Int(String s)
	{
		try
		{
			return new Integer(s).intValue();
		}catch(Exception e)
		{
			return 0;
		}
	}

	public Date  toDate( Object d )
	{
		if( d==null) return null;
		Date dd;
		if( d instanceof Date)
		{
			dd=(Date)d;
		}else
		{
			try
			{
				dd= (Date)ObjectTool.ChangeType(d , ObjectTool.java_util_Date);
			}catch(Exception e)
			{
				return null;
			}
		}
		return dd;
	}
	
	public   String formatDate(Object   d ,String format)
	{

		Date dd =toDate(d);
		if( dd==null) return "";

		
		SimpleDateFormat SDF = new SimpleDateFormat(format);
		
		return SDF.format((Date) dd);
		
	}
	
	
	public static void main(String[] args)
	{
		Calendar cal= Calendar.getInstance();
		cal.set(2006,0 ,1);
		SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd");
		 
		 
		
		System.out.println(   SDF.format((Date)   cal.getTime())); 
		System.exit(0);
	}

	
}
