package util;

import jun.db.core.IDataStoreCacheProvider;
import org.json.JSONObject;
import websocketRPC.WSRPC;

public class DataStoreCacheProvider implements IDataStoreCacheProvider
{

    public static EmulateHttpServletRequest EHR = new EmulateHttpServletRequest(); //模拟用户

    public DataStoreCacheProvider()
    {

    }


    @Override
    public String getDataFromCache(String redisServerCode, String key)
    {
        String defaultValue=null;
        JSONObject ret= WSRPC.dispatch("cache", "api.MoreRedisManage" , "get" ,
                                       new JSONObject().put("code",redisServerCode).put("key",key).put("defaultValue", defaultValue),
                                       EHR , null, false);

        if( ret.getBoolean("success",false))
        {
            return ret.getString("value",defaultValue);
        }else
        {

            return defaultValue;
        }
    }

    @Override
    public String  setDataToCache(String redisServerCode, String key, String value, int validPeriod)
    {
        JSONObject ret= WSRPC.dispatch("cache","api.MoreRedisManage" , "put" ,
                                       new JSONObject().put("code",redisServerCode).put("key",key).put("value", value)
                                               .put("validPeriod", validPeriod),
                                       EHR , null ,false);

         return ret.toString();
    }

    @Override
    public String deleteDataOnCache(String redisServerCode, String key)
    {
        JSONObject ret= WSRPC.dispatch("cache","api.MoreRedisManage" , "del" ,
                                       new JSONObject().put("code",redisServerCode).put("key",key),
                                       EHR , null,false);

        return ret.toString();
    }
}
