package util;

import app.Ilog;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.UniformDataType;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.Sequence;
import org.json.JSONObject;
import org.slf4j.Logger;
import websocketRPC.WSRPC;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;

public class DBTool
{


    /**
     * tablename 与 file 中的create table 中的表名可能不同名
     */
    public static void InitTable(Connection con, String path, String tablename, String file, Ilog ilog, Logger log, boolean isView)
    {
        BufferedReader br = null;
        DataAdapter da = DataStoreFactory.createDataAdapter(con);
        try
        {
            //		addLog(log,logFile, "***************：" + tablename);

            addLog(ilog, log, "检测表：" + tablename);

            // 如果表存在，那么就扫描字段
            boolean tableExists = FF.tableExists(con, tablename);
            boolean needInitSequence = false;
            if (tableExists)
            {

                if (isView)
                {
                    addLog(ilog, log, "        这是视图，不需要检测字段");
                    return;
                }
                //		addLog( ilog, log ,"        表" + tablename + "存在，检测字段");
                DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + tablename);
                //如果有ID字段，并且它是数字，那么需要做序列号初始化
                if (ds.col2Index("id") >= 0)
                {
                    if (ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Integer || ds.getColumnProperty("id").getUniformDataType() == UniformDataType.$Numeric)
                        needInitSequence = true;
                }

                String fileName = path + File.separator + file;
                String charsetName = DataStoreFactory.charsetDetect(fileName);
                br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(fileName)), charsetName));
                String data = null;
                StringBuffer sb = new StringBuffer(1024);
                while ((data = br.readLine()) != null)
                {
                    FF.sleep(10);
                    data = data.trim();
                    if (data.startsWith("--")) continue;
                    if (data.startsWith("//")) continue;
                    int p = data.indexOf("--");
                    if (p >= 0) data = data.substring(0, p);
                    data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                    data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格
                    if (data.endsWith(",")) data = data.substring(0, data.length() - 1).trim(); // 把最后的逗号去掉
                    // ，
                    // 不能用replaceAll// 因为 numeric ( 20 , 6 ) 中也有逗号

                    if (data.toLowerCase().startsWith("create ")) continue;
                    if (data.toLowerCase().startsWith("primary ")) continue;
                    if (data.toLowerCase().startsWith("(")) data = data.substring(1).trim();
                    if (data.toLowerCase().endsWith(")")) data = data.substring(0, data.length() - 1).trim();
                    if (data.isEmpty()) continue;

                    // 基本上应该是字段了
                    int cp = data.indexOf(" ");
                    if (cp < 0) continue;
                    String colname = data.substring(0, cp).trim();
                    if (ds.col2Index(colname) < 0)
                    {
                        data = data.substring(cp).trim();
                        int p1 = data.indexOf(" ");
                        int p2 = data.indexOf("(");
                        if (p1 <= 0) p1 = 999999;
                        if (p2 <= 0) p2 = 999999;
                        int minP = Math.min(p1, p2);
                        if (minP < 0) continue; // 通常是出错了才会这样
                        String colType = data.substring(0, minP).trim();
                        colType = da.getMappedDataType(colType);

                        data = data.substring(minP);
                        //可能含有 not null , 需要把 not 去掉
                        String data2 = FF.replaceAll(data, "(\\s)*not(\\s)+null", "null");
                        if (!data.equals(data2))
                        {
                            addLog(ilog, log, "        ***特别注意：字段" + colname + "是 " + data + " 但现在追加字段，需要改成" + data2);

                        }

                        colType = colType + data2;

                        String sql = "alter table " + tablename + "  add " + colname + " " + colType;
                        addLog(ilog, log, "        系统检测到表" + tablename + "缺少字段" + colname + "，自动补上该字段：" + sql);

                        FF.SafeExecute(con, sql);
                    }
                    else
                    {//在恢复数据时，　一个字段显示一个提示，很费时间
                        //addLog(log, "        字段:"+colname+"已存在");

                    }

                }

                //所有表都加上 thisrowlastmodifydate字段
                FF.SafeExecute(con, "alter table " + tablename + "  add thisrowlastmodifydate  " + da.getMappedDataType("datetime") + " null", false);

            }
            else
            {
                addLog(ilog, log, "<br><span >准备创建：" + tablename + "</font>");
                br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(path + File.separator + file))));
                String data = null;
                StringBuffer sb = new StringBuffer(1024);

                while ((data = br.readLine()) != null)
                {
                    FF.sleep(10);
                    data = data.trim();
                    if (data.startsWith("--")) continue;
                    if (data.startsWith("//")) continue;
                    int p = data.indexOf("--");
                    if (p >= 0) data = data.substring(0, p).trim();
                    data = data.replaceAll("\t", " ").trim(); // tab 换成空格
                    data = data.replaceAll("　", " ").trim(); // 中文空格换成英文空格

                    //2012.01.09 可能表名与SQL语句中的表名不同， 使用给的表名
                    if (data.toLowerCase().startsWith("create") && data.toLowerCase().indexOf(" table ") > 0)
                    {
                        int tp = data.indexOf(" table ");
                        if (tp > 0) data = data.substring(0, tp) + "  table " + tablename + " ";
                    }

                    // 不是字段，其其它语句
                    if (data.toLowerCase().startsWith("create ") || data.toLowerCase().startsWith("primary "))
                    {
                        sb.append(data).append(" ");
                        continue;
                    }

                    // 在第一个字段前可能会有一个 (
                    if (data.toLowerCase().startsWith("("))
                    {
                        data = data.substring(1).trim();
                        sb.append(" ( ");
                    }

                    if (data.isEmpty()) continue;

                    if (!isView)
                    {
                        // 基本上应该是字段了
                        int cp = data.indexOf(" ");
                        if (cp < 0) // 不是字段，那么直接把语句拼起来
                        {
                            sb.append(data);
                            continue;
                        }

                        String colname = data.substring(0, cp).trim();
                        data = data.substring(cp).trim();
                        int p1 = data.indexOf(" ");
                        int p2 = data.indexOf("(");
                        if (p1 <= 0) p1 = 999999;
                        if (p2 <= 0) p2 = 999999;
                        int minP = Math.min(p1, p2);
                        if (minP < 0) continue; // 通常是出错了才会这样
                        String colType = data.substring(0, minP).trim();
                        colType = da.getMappedDataType(colType);
                        data = data.substring(minP);

                        if (da.isOracle() || da.isPostgres())
                        {
                            // 去掉IDENTITY
                            data = FF.replaceAll(data, "IDENTITY", "");
                            data = FF.replaceAll(data, "identity", "");
                        }

                        if (da.isMySQL())
                        {
                            // 替换IDENTITY为auto_increment
                            data = FF.replaceAll(data, "IDENTITY", "auto_increment");
                            data = FF.replaceAll(data, "identity", "auto_increment");

                            //
                            if (colname.equalsIgnoreCase("id") && data.indexOf("auto_increment") >= 0 && colType.equals("numeric"))
                            {

                                colType = "int";
                            }

                        }

                        //2016.09.10增加，如果有ID字段，并且它不是自增量字段，并且不是字符型，那么才需要初始一个序列号
                        if (colname.equalsIgnoreCase("id"))
                        {
                            String t = data.toLowerCase();
                            String t2 = colType.toLowerCase();
                            if (t.indexOf("auto_increment") < 0 && t.indexOf("identity") < 0 && t2.indexOf("char") < 0)
                            {
                                needInitSequence = true;
                            }
                        }

                        sb.append(colname).append(" ").append(colType).append(data).append("  ");
                    }
                    else
                    {
                        sb.append(data).append(" ");
                    }

                }

                addLog(ilog, log, "<br><span >创建：" + tablename + "</font>");
                addLog(ilog, log, sb.toString());

                addLog(ilog, log, sb.toString());
                FF.SafeExecute(con, sb.toString());
            }

            // ID序列初始化
            //2014.06.17改成都要初始化ID
            if (needInitSequence)
            {
                FF.log(" initSequence('', '" + tablename + ".id' , '  select max(id) from " + tablename + "');");
                Sequence.InitSequence(con, tablename + ".id", " select max(id) from " + tablename);
                Sequence.InitNegativeSequence(con, tablename + ".id", " select min(id) from " + tablename);
            }
            else
            {
                // FF.log(tablename + "不需要用 initSequence 初始化序列号");
            }
        } catch (Exception e)
        {

            String errorInfo = e.getMessage();
            if (errorInfo == null) errorInfo = "null";
            addLog(ilog, log, "<br><font color=red>" + e.getClass().getName() + errorInfo + "</font>");
        } finally
        {
            if (br != null) try
            {
                br.close();
            } catch (Exception e)
            {
            }
        }
    }

    public static void addLog(Ilog ilog, Logger log, String s)
    {
        FF.log(s);
        if (ilog != null) ilog.Tip("<br>" + s);
        if (log != null) log.info(s);
    }


    public static JSONObject backupTable(String dbpool1, String table1, String where, String dbpool2, String table2, HttpServletRequest request , HttpServletResponse response)
    {
        try
        {
            JSONObject ret = RPCRouter.dispatch("script", "db.DBService", "backupTable",
                                                new JSONObject().put("dbpool1", dbpool1)
                                                        .put("table1", table1)
                                                        .put("dbpool2", dbpool2)
                                                        .put("table2", table2)
                                                        .put("where", where), request, response, false, 3600);

            return ret;
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            return new JSONObject().put("success", false).put("message", e.getMessage());
        }


    }
}
