package util;

import app.User;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import config.CacheConfig;
import dfs.IFileServer;
import dfs.UploadFile;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import webApp.App;

import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.*;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.SortedMap;

@WebServlet(name = "dbStatus", urlPatterns = "/dbStatus")
public class DBStatus extends HttpServlet
{




    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        if(!sso.SSOLoginCheck.loginCheck(req, res,true)) return ;

        req.setCharacterEncoding("UTF-8");

        JSONObject ret= new JSONObject();
        ret.put("pool", DBF.getPoolStackTrace());
        ret.put("status" , getHikariCPState(null));

        res.getOutputStream().write(ret.toString().getBytes("UTF-8"));

    }

//  https://blog.csdn.net/qq330983778/article/details/124807931?utm_medium=distribute.pc_relevant.none-task-blog-2~default~baidujs_baidulandingword~default-0-124807931-blog-105404006.235^v33^pc_relevant_yljh&spm=1001.2101.3001.4242.1&utm_relevant_index=3
public JSONObject getInfo(String poolName , DataSource dataSource) throws SQLException
{
    JSONObject log= new JSONObject();
    String indexName = poolName + ".pool.";
    MetricRegistry metricRegistry = (MetricRegistry) ((HikariDataSource) dataSource).getMetricRegistry();
    if(metricRegistry==null) return log;
    SortedMap<String, Gauge> gauges = metricRegistry.getGauges();
    Gauge activeConnections = gauges.get(indexName + "ActiveConnections");
    Object activeConnectionsV = activeConnections.getValue();
    log.put("activeConnections" , activeConnectionsV);

    Gauge IdleConnections = gauges.get(indexName + "IdleConnections");
    Object IdleConnectionsV = IdleConnections.getValue();
    log.put("idleConnections" , IdleConnectionsV);

    Gauge MaxConnections = gauges.get(indexName + "MaxConnections");
    Object MaxConnectionsV = MaxConnections.getValue();
    log.put("maxConnections" , MaxConnectionsV);

    Gauge MinConnections = gauges.get(indexName + "MinConnections");
    Object MinConnectionsV = MinConnections.getValue();
    log.put("minConnections" , MinConnectionsV);

    Gauge PendingConnections = gauges.get(indexName + "PendingConnections");
    Object PendingConnectionsV = PendingConnections.getValue();
    log.put("pendingConnections" , PendingConnectionsV);

    Gauge TotalConnections = gauges.get(indexName + "TotalConnections");
    Object TotalConnectionsV = TotalConnections.getValue();
    log.put("totalConnections", TotalConnectionsV);

    return log;
}


    public JSONObject getHikariCPState(JSONObject param)
    {
        JSONObject ret = new JSONObject("{success:true}");


        JSONArray ja = new JSONArray();
        ret.put("items", ja);

        ArrayList<String> poolNames = DBF.getPoolNames();
        for (String name : poolNames)
        {
            DataSource dss = DBF.getDataSource(name);
            if (!(dss instanceof HikariDataSource)) continue;


            try
            {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + name + ")");
                HikariPoolMXBean poolProxy = JMX.newMXBeanProxy(mBeanServer, poolName, HikariPoolMXBean.class);

                JSONObject one = new JSONObject();
                one.put("service", App.appName);
                one.put("ip", App.IPADDRESS);
                one.put("name", name);
                one.put("active", poolProxy.getActiveConnections());
                one.put("idle", poolProxy.getIdleConnections());
                one.put("wait", poolProxy.getThreadsAwaitingConnection());
                one.put("total", poolProxy.getTotalConnections());

                one.put("moreInfo" , getInfo(name ,dss));

                ja.put(one);
            } catch (Exception e)
            {
                ret.put("message", e.getMessage());
            }


        }
        return ret;


    }

}
