package util;

import jun.db.impl.DataStoreFactory;
import jun.db.util.TimeMark;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;

import java.io.BufferedOutputStream;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Function;

public class CreateExcel
{



    private static boolean isNumeric(String str)
    {
        if (str == null || str.isEmpty())
        {
            return false;
        }
        // 匹配整数或小数（包括负数）
        boolean b=str.matches("-?\\d+\\.\\d+");

        if(!b) return false;

        if(str.startsWith("0"))
        {
            if(str.startsWith("0.")) return true;
            return false;//比如  02342.33444 通常不会存在这样的写法，如果是这样，那么当做字符串

        }

        if(str.startsWith("-0"))
        {
            if(str.startsWith("-0.")) return true;
            return false;

        }

        return true;
    }


    private static boolean isInteger(String str)
    {
        if (str == null || str.isEmpty())
        {
            return false;
        }
        if( str.length()>9) return false; // 防止溢出，太长的，直接当字符串
        // 匹配整数或小数（包括负数）
        return str.matches("-?\\d+") && !str.startsWith("0");
    }

    public static void export(XSSFWorkbook workBook , JSONArray ja, String password  )
    {
         export( workBook, ja, password, null);
    }
    public static void export(XSSFWorkbook workBook , JSONArray ja, String password , Function<Integer, String> callback)
    {

        if (password == null) password = "";



        TimeMark tm = new TimeMark();
        HashMap<Integer, CellStyle> decimalFormatMap = new HashMap<Integer, CellStyle>();

        try
        {


            // 声明一个工作薄

            // 生成一个表格
            XSSFSheet sheet = workBook.createSheet();

            if (!password.isEmpty())
            {
                sheet.protectSheet(password);
            }

            int  maxColumnCount=0;
            //插入需导出的数据
            for (int i = 0; i < ja.length(); i++)
            {
                XSSFRow row = sheet.createRow(i);
                if (ja.get(i) instanceof String)
                {
                    String tr = ja.getString(i);
                    String[] td = tr.split("\t");
                    maxColumnCount =Math.max(maxColumnCount , td.length);
                    for (int j = 0; j < td.length; j++)
                    {
                        String t = td[j];
                        if (t.length() < 16)
                        {

                            if (isInteger(t))
                            {


                                Cell cell = row.createCell(j);
                                cell.setCellValue(new Integer(t));
                                cell.setCellStyle(buildDecimalFormat(decimalFormatMap, workBook, 0));
                                continue;

                            }

                            if (isNumeric(t))
                            {

                                int decimalCount = t.length() - t.indexOf(".") - 1;
                                Cell cell = row.createCell(j);
                                cell.setCellValue(new Double(t));
                                cell.setCellStyle(buildDecimalFormat(decimalFormatMap, workBook, decimalCount));
                                continue;

                            }

                            row.createCell(j).setCellValue(t);

                        }
                        else
                        {
                            row.createCell(j).setCellValue(t);
                        }
                    }
                    continue;
                }

                if (ja.get(i) instanceof JSONArray)
                {
                    JSONArray oneRow = ja.getJSONArray(i);

                    maxColumnCount= Math.max(maxColumnCount, oneRow.length());
                    for (int j = 0; j < oneRow.length(); j++)
                    {
                        Object t = oneRow.get(j);


                        if (t instanceof Boolean)
                        {
                            row.createCell(j).setCellValue((Boolean) t);
                            continue;
                        }
                        if (t instanceof Double ||t instanceof BigDecimal || t instanceof  Float)
                        {
                            BigDecimal bd = new BigDecimal(t.toString());
                            String s = bd.toString();
                            int decimalCount = s.length() - s.indexOf(".") - 1;
                            Cell cell = row.createCell(j);
                            cell.setCellValue((Double) t);
                            cell.setCellStyle(buildDecimalFormat(decimalFormatMap, workBook, decimalCount));

                            continue;
                        }

                        if (t instanceof Integer || t instanceof Long || t instanceof Short)
                        {

                            Cell cell = row.createCell(j);
                            cell.setCellValue((Integer) t);
                            cell.setCellStyle(buildDecimalFormat(decimalFormatMap, workBook, 0));


                            continue;
                        }

                        if (t instanceof Date)
                        {
                            row.createCell(j).setCellValue((Date) t);
                            continue;
                        }

                        row.createCell(j).setCellValue(t.toString());
                    }
                    continue;
                }

                if( callback!=null)   callback.apply(i);
            }

            // 自动调整列宽
            for (int i = 0; i < maxColumnCount; i++) {
                sheet.autoSizeColumn(i);
            }


        } catch (Exception e)
        {
            FF.log( FF.exceptionMessage(e));

        }


    }


    public static CellStyle buildDecimalFormat(HashMap<Integer, CellStyle> decimalFormatMap, XSSFWorkbook workBook, int decimalCount)
    {
        if (decimalFormatMap.containsKey(decimalCount)) return decimalFormatMap.get(decimalCount);

        CellStyle numberStyle = workBook.createCellStyle();
        DataFormat format = workBook.createDataFormat();
        if (decimalCount == 0)
        {
            numberStyle.setDataFormat(format.getFormat("0"));
        }
        else
        {
            numberStyle.setDataFormat(format.getFormat("0." + "0000000000000000000000000".substring(0, decimalCount)));
        }
        decimalFormatMap.put(decimalCount, numberStyle);
        return numberStyle;
    }


}
