package util;

import org.apache.calcite.sql.*;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlBasicVisitor;

public class CalciteOuterOrderByChecker {

    public static boolean hasOuterOrderBy(String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create(sql);
        SqlNode sqlNode = parser.parseQuery(); // 解析 SQL
        return hasOrderBy(sqlNode);
    }

    private static boolean hasOrderBy(SqlNode sqlNode) {
        if (sqlNode instanceof SqlOrderBy) {
            // 最外层是 ORDER BY（如：SELECT ... ORDER BY）
            return true;
        } else if (sqlNode instanceof SqlSelect) {
            // 检查 SELECT 语句是否有 ORDER BY
            SqlSelect select = (SqlSelect) sqlNode;
            return select.getOrderList()!=null; // 如果 SELECT 语句有 ORDER BY，则返回 true
        } else if (sqlNode instanceof SqlCall) {
            // 处理 UNION/INTERSECT/EXCEPT（检查最后一个 SELECT）
            SqlCall call = (SqlCall) sqlNode;
            SqlNode lastOperand = call.getOperandList().get(call.getOperandList().size() - 1);
            return hasOrderBy(lastOperand);
        }
        return false;
    }

    public static void main(String[] args) throws SqlParseException {
        String sql1 = "SELECT * FROM (SELECT * FROM t ORDER BY c1) a"; // 内层有 ORDER BY，外层无
        String sql2 = "SELECT * FROM t ORDER BY id";                   // 外层有 ORDER BY
        String sql3 = "SELECT * FROM t UNION SELECT * FROM s ORDER BY 1"; // 外层（UNION 后）有 ORDER BY

       // System.out.println(hasOuterOrderBy(sql1)); // false
       // System.out.println(hasOuterOrderBy(sql2)); // true
       // System.out.println(hasOuterOrderBy(sql3)); // true
    }
}
