package util;

import app.User;
import jun.db.impl.DataStoreFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.MDC;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;

public class BuildParamFromRequest
{

    public static JSONObject buildParam(HttpServletRequest request, HttpServletResponse response ) throws ServletException, IOException
    {
        return buildParam(request, response , true,false);
    }
    public static JSONObject buildParam(HttpServletRequest request, HttpServletResponse response , boolean holdHeader , boolean sqlInject ) throws ServletException, IOException
    {

        //先将url参数放入
        JSONObject queryParam = new JSONObject(FF.QueryString2JSON(request , sqlInject));

        if( response!=null)
        {
            response.setContentType("text/html;charset = UTF-8");//很重要 ,不然乱码
            response.setCharacterEncoding("UTF-8");
        }

        if( holdHeader)
        {
            Enumeration hn = request.getHeaderNames();
            JSONObject header = new JSONObject();
            while (hn.hasMoreElements())
            {
                String key = hn.nextElement().toString();
                String value = request.getHeader(key);
                //2025.01.01 增加防止sql注入
                if( sqlInject) value =  JSONObject.encodeForSQL( value);
                header.put(key, value);
                //允许在头部定义要调用的脚本代码或ID
                if (key.equalsIgnoreCase("task")) queryParam.put("task", value);
            }
            //把header中的数据也放入
            queryParam.put("httphead", header);

            JSONObject req = new JSONObject();
            req.put("remoteAddr", request.getRemoteAddr());
            req.put("remoteHost", request.getRemoteHost());
            req.put("remoteUser", request.getRemoteUser());
            req.put("remotePort", request.getRemotePort());
            req.put("requestURL", request.getRequestURL().toString());
            req.put("requestURI", request.getRequestURI().toString() );
            req.put("queryString", request.getQueryString( ) );
            req.put("method", request.getMethod());



            queryParam.put("request", req);

        }

        //表单数据

        //2025.01.01 因为可能  request 被多次使用，但是在第一次之后， 上面的header信息可以重复读取，但是 stream流的数据可能已经关闭，不能再读了
        // 因此需要屏蔽一下错误，不影响后续的代码执行
        try
        {

            String contentType = request.getHeader("content-type");
            if (contentType == null) contentType = "";
            contentType = contentType.toLowerCase();
            if ((contentType.indexOf("text") >= 0 || contentType.indexOf("json") >= 0 || contentType.indexOf("xml") >= 0)
                    && request.getMethod().equalsIgnoreCase("POST"))
            {


                InputStream in = request.getInputStream();

                ByteArrayOutputStream bao = new ByteArrayOutputStream();

                byte[] b = new byte[4096];
                int len;
                while (true)
                {
                    len = in.read(b);
                    if (len == -1) break;

                    bao.write(b, 0, len);
                }
                bao.flush();
                bao.close();
                in.close();

                String html = bao.toString("UTF-8");
                FF.log(html);
                queryParam.put("rawdata", html);

                //
                JSONObject tjs = new JSONObject(html);

                //增加防止sql注入
                if( sqlInject)
                {
                    try
                    {
                        tjs= JSONObject.encodeForSQL(tjs);
                    }catch(Exception e)
                    {
                        tjs = new JSONObject(html);
                    }
                }

                Iterator<String> it = tjs.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String key = it.next();
                    queryParam.put(key, tjs.get(key, null));
                }

                String taskIdOrCode = FF.getStringFromRequest(request, "task", "");
                if (!taskIdOrCode.equalsIgnoreCase("")) queryParam.put("task", taskIdOrCode);

            }
            else
            {
                if (contentType.indexOf("multipart/form-data") >= 0)
                {
                    try
                    {
                        DiskFileItemFactory factory = new DiskFileItemFactory();
                        ServletFileUpload upload = new ServletFileUpload(factory);
                        List items = upload.parseRequest(request);
                        Map param = new HashMap();
                        JSONArray files = null;
                        String path=  App.FileRoot + "/FileServer/autoDeleteAfterOneHour/";
                        for (Object object : items)
                        {
                            if (!(object instanceof FileItem)) continue;
                            FileItem fileItem = (FileItem) object;
                            if (fileItem.isFormField())
                            {
                                String key = fileItem.getFieldName();
                                String value = fileItem.getString("utf-8");//如果你页面编码是utf-8的

                                //增加防止sql注入
                                if( sqlInject) value =  JSONObject.encodeForSQL( value);
                                queryParam.put(key, value);

                            }else {
                                if( files==null) files= new JSONArray();
                                String fileName = fileItem.getName();
                                String extName = FF.getFileExtName(fileName);

                                //2025.05.06 有时候，文件名中会带上一级目录名称 ， 比如  abc/def.pdf  ，需要去掉文件名中的目录
                                if( fileName.indexOf("/")>=0)
                                {
                                    fileName=  fileName.substring( fileName.lastIndexOf("/")+1);
                                }

                                String savedFile = path + DataStoreFactory.newLongID2String() + "." + extName;
                                FF.log("保存为临时文件 " + savedFile);
                                fileItem.write(new File(savedFile));//临时文件

                                JSONObject fileInfo = new JSONObject();
                                fileInfo.put("name", fileName);
                                fileInfo.put("path",savedFile);
                                files.put(fileInfo);
                            }

                        }

                        if( files!=null)  queryParam.put("$$$files" ,files);
                    } catch (Exception e)
                    {

                    }
                }


                Map<String, String[]> params = request.getParameterMap();
                for (String key : params.keySet())
                {
                    String[] values = params.get(key);
                    for (int i = 0; i < values.length; i++)
                    {
                        String value = values[i];
                        //增加防止sql注入
                        if( sqlInject) value =  JSONObject.encodeForSQL( value);
                        FF.log(key + " = " + value);
                        queryParam.put(key, value); //如果key重名，则只取最后一个值，前面的值被覆盖
                    }
                }
            }
        }catch(Exception e)
        {

        }


        return queryParam;
    }

    public static HashMap buildUserInfo(HttpServletRequest request)
    {
        HashMap map = new HashMap();
        if( request==null)
        {
            map.put("name", "task");
            map.put("code", "$task$");
            map.put("id", "-1");
            map.put("showname", "系统调度");
            map.put("mobile", "00000000000");
            map.put("departmentid", 0);
            map.put("tokenid","");
            map.put("clientIP","" );
            map.put("corporationid", "");
        }else
        {
            User user = User.getUserFromRequest(request);

            map.put("clientIP" ,  FF.getClientIpAddr(request));
            map.put("name", user.getName());
            map.put("code", user.getCode());
            map.put("id", user.getId());
            map.put("showname", user.getShowName());
            map.put("mobile", user.getMobile());
            map.put("departmentid", user.getDepartmentId());
            //2020.11.18 增加
            map.put("tokenid" ,   FF.getTokenIdFromRequest(request));
            //2024.06.06 增加
            map.put("isDeveloper", user.isDeveloper());
            map.put("corporationid", FF.getCurrentCorporationIdForCurrenUser(request));



        }
        return map;
    }

}

