package util;

import org.json.JSONArray;
import org.json.JSONObject;
import webApp.App;
import websocketRPC.WSRPC;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

import static cache.CacheBuckeyConst.PREFIX_ID2Config;


public class AppCache
{
    public static String CS_PREFIX_WORKSPACE = "workspace:";

    public static String  CS_PREFIX_PLATFORM2WORKSPACE ="platform2mobileWorkspace:";

    public static String CS_PREFIX_codeHelpCopyMap="codeHelpCopyMap:"; //每个表中的第个字段被其它什么表的什么字段引用
    public static String CS_PREFIX_codeHelpRefMap="codeHelpRefMap:";  // id被其它表什么字段引用的映射


    public final static JSONObject  normalRet= new JSONObject().put("success",true).put("message","" );

    public static JSONObject setCache(String key, String value )
    {
        return setCache(key, value,false,0);

    }

    /**
     * 注意， 设置键时，必须是广播
     * @param key
     * @param value
     * @return
     */
    public static JSONObject setCache(String key, String value ,boolean flush , int validPeriod)
    {

        //这个主要用在系统刚启动时， 缓存还没准备好，那么用内存临时充当一下，


        //validPeriod 有效期
        try
        {
            JSONObject ret= WSRPC.dispatch("cache", "api.CacheManage", "setCache",
                                           new JSONObject().put("key", key).put("value", value).put("flush", flush).put("validPeriod",validPeriod), null, null, true, 10);

           return ret;
        }catch(Exception e)
        {
            FF.log(  e.getMessage());
            return new JSONObject().put("success",false).put("message",e.getMessage());
        }


    }

    /**
     * 判断 用户在 IP上有没有对资源resoureid的操作权
     * @param userid
     * @param resourceid
     * @param ip
     * @return
     */
    public static boolean whitelistCheck(int userid , String resourceid , String ip)
    {
        try
        {
            JSONObject ret= WSRPC.dispatch("cache", "api.CacheManage", "whitelistCheck",
                                           new JSONObject().put("userid", userid).put("resourceid", resourceid).put("ip",ip), null, null,
                                           false,//读取 时，必须不能是广播
                                           10);

            return ret.getBoolean("success", true) && ret.getBoolean("commision",true);
        }catch(Exception e)
        {
            return false;
        }

    }
    /**
     * 注意，读取键时，必须不能是广播
     * @param key
     * @param defaultValue
     * @return
     */
    public static String getCache(String key, String defaultValue)
    {
         String ret=getCache( key);
         if( ret==null) ret= defaultValue;
         return ret;

    }

    public static JSONObject  getCache(JSONArray keys)
    {


        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "getCaches",
                                          new JSONObject().put("keys", keys), null, null,
                                          false,//读取键时，必须不能是广播
                                          10);

            //这里把不存在，与存在但是是空字符串区分开

            return ret.getJSONObject("value", new JSONObject());

        }catch(Exception e)
        {
            FF.log( "getCache异常："+ FF.exceptionMessage(e));
            return new JSONObject();
        }
    }

    /**
     * 不提供默认值的方式获取缓存，如果缓存不存在，那么返回 null
     * @param key
     * @return
     */
    public static String getCache(String key)
    {



        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "getCache",
                                          new JSONObject().put("key", key), null, null,
                                          false,//读取键时，必须不能是广播
                                          10);

            //这里把不存在，与存在但是是空字符串区分开
            if( ret.getBoolean("exists" ,true))
            {
                return ret.getString("value", "");
            }else
            {
                return null;
            }

        }catch(Exception e)
        {
            return e.getMessage();
        }

    }

    public static String  getResourceIDOfURL(String url)
    {
        return getResourceIDOfURL(url,"");
    }

    /**
     * 获取url对应的工作台地址
     * @param url
     * @param ignoreParamNames  工作台地址中可以忽略的地址
     * @return
     */
    public static String  getResourceIDOfURL(String url, String  ignoreParamNames)
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "getResourceIDOfURL",
                                          new JSONObject().put("url", url).put("ignoreParamNames", ignoreParamNames), null, null,                false,//读取键时，必须不能是广播
                                          10);

            JSONArray ids= ret.getJSONArray("ids",null);
            if( ids== null) return "";
            return ids.getString(0);

        }catch(Exception e)
        {
            FF.log( "AppCache.getResourceIDOfURL异常："+FF.exceptionMessage(e));
            return "";
        }
    }


    /**
     * 检查userid对url 有没有操作权，同时也做IP白名单检测
     * @param userid
     * @param url
     * @param ip
     * @return
     */
    public static JSONObject urlOnCommision(int userid ,String corporationid,  String url ,String ip )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "urlOnCommision",
                                             new JSONObject().put("url", url).put("userid",userid).put("ip",ip)
                                                     .put("corporationid",corporationid), null, null,
                                             false,//读取键时，必须不能是广播
                                             10);

            return ret ;
        }catch(Exception e)
        {
            return new JSONObject().put("success",false).put("message",e.getMessage());
        }
    }

    public static JSONObject urlOnCommisions(int userid ,String corporationid, JSONArray urls ,String ip )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "urlOnCommisions",
                                          new JSONObject().put("urls", urls).put("userid",userid).put("ip",ip)
                                                  .put("corporationid",corporationid), null, null,
                                          false,//读取键时，必须不能是广播
                                          10);

            return ret ;
        }catch(Exception e)
        {
            return new JSONObject().put("success",false).put("message",e.getMessage());
        }
    }



    public static JSONObject  urlMoreAuthorization(int userid ,String corporationid, String url  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "urlMoreAuthorization",
                                             new JSONObject().put("url", url).put("userid",userid).put("corporationid",corporationid), FF.EHR, null,
                                             false,//读取键时，必须不能是广播
                                             10);

            return ret ;
        }catch(Exception e)
        {
            return new JSONObject().put("success",false).put("message",e.getMessage());
        }
    }

    /**
     * 哪些角色对url拥有授权
     * @param url
     * @return
     */
    public static JSONObject whichRolesOwnerTheURL(  String url  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "whichRolesOwnerTheURL",
                                          new JSONObject().put("url", url), FF.EHR, null,
                                          false,//读取键时
                                          10);

            return ret ;
        }catch(Exception e)
        {
            return new JSONObject().put("success",false).put("message",e.getMessage());
        }
    }

    /**
     * 广播刷新系统工作台缓存
     */
    public static void refresh_cache_app_workspace( )
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_app_workspace",
                                             new JSONObject(), null, null,
                                             true,// 刷新缓存，需要广播
                                             300);


        }catch(Exception e)
        {
          FF.log("refresh_cache_app_workspace : "+ e.getMessage());
        }

    }

    public static void refresh_cache_codehelp_copymap( )
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_codehelp_copymap",
                           new JSONObject(), null, null,
                           true,// 刷新缓存，需要广播
                           300);


        }catch(Exception e)
        {
            FF.log("refresh_cache_codehelp_copymap : "+ e.getMessage());
        }

    }


    /**
     * 仅仅是刷新一下 某一个工作台id对应的详细设置
     */
    public static void refresh_cache_one_app_workspace( String workspaceid)
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_one_app_workspace",
                           new JSONObject().put("id", workspaceid), null, null,
                           true,// 刷新缓存，需要广播
                           300);


        }catch(Exception e)
        {
            FF.log("refresh_cache_app_workspace : "+ e.getMessage());
        }

    }


    /**

     * 清除工作台菜单相关的缓存
     * <p>
     * 如下情况下，需要清除缓存
     * <p>
     * 1 工作台发生修改
     * 2 角色的授权发生变化
     * <p>
     * 如下信息变化时，不需要清除缓存
     * <p>
     * 1 人员的角色变化
     * 2 人员的部门变化
     * <p>
     * 因为引自缓存的是角色对应的工作台信息。所以，仅在工作台，或角色授权变化时，才需要刷新缓存
     * <p>
     * 刷新策略是：直接取消与工作台相关的所有缓存。当下次需要用的时，再构建缓存

     */

    public static void refresh_cache_app_workspace_memu( )
    {

        FF.log("工作台菜单相关缓存，全部清除");

        AppCache.removeCacheMatch(  CS_PREFIX_WORKSPACE);




    }


    /**
     * 广播刷新用户的角色缓存
     * @param where
     */
    public static void refresh_cache_user_role( String where)
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_user_role",
                              new JSONObject().put("where",where), null, null,
                              true,// 刷新缓存，需要广播
                              300);


        }catch(Exception e)
        {
            FF.log("refresh_cache_user_role : "+ e.getMessage());
        }
    }

    /**
     * 广播刷新企业的应用缓存
     * @param where
     */
    public static void refresh_cache_corporation_app ( String where)
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_cache_corporation_app",
                           new JSONObject().put("where",where), null, null,
                           true,// 刷新缓存，需要广播
                           300);


        }catch(Exception e)
        {
            FF.log("refresh_cache_user_role : "+ e.getMessage());
        }
    }

    public static void refresh_oneOrMore_role_right(JSONArray  data)
    {
        try
        {
            WSRPC.dispatch("cache", "api.CacheRefresh", "refresh_oneOrMore_role_right",
                               new JSONObject().put("data", data) , null, null,
                              true,// 刷新缓存，需要广播
                              300);


        }catch(Exception e)
        {
            FF.log("refresh_oneOrMore_role_right : "+ e.getMessage());
        }
    }


    /**
     *  注意，删除键时，必须是广播
     * @param key
     * @return
     */
    public static String removeCache(String key  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "removeCache",
                                             new JSONObject().put("key", key), null, null, true, 10);
            if (ret.getBoolean("success",true)) return "";
            return ret.getString("message","");
        }catch(Exception e)
        {
            return e.getMessage();
        }
    }


    public static String removeCacheMatch(String key  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "removeCacheMatch",
                                          new JSONObject().put("key", key), null, null, true, 10);
            if (ret.getBoolean("success",true)) return "";
            return ret.getString("message","");
        }catch(Exception e)
        {
            return e.getMessage();
        }
    }

    public static JSONObject  getCacheMatch(String key  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("cache", "api.CacheManage", "getCacheMatch",
                                          new JSONObject().put("key", key), null, null, true, 10);
            if (ret.getBoolean("success",true)) return  new JSONObject();
            return ret.getJSONObject("values",new JSONObject());
        }catch(Exception e)
        {
            FF.log( FF.exceptionMessage( e));
            return new JSONObject();
        }
    }

}
