package tag;

import app.User;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import util.AppCache;
import util.FF;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class URL_RBAC_Tag extends BodyTagSupport
{


    public Object  url;
    public void setUrl(Object url)
    {
        try
        {
            this.url = ExpressionEvaluatorManager.evaluate(
                    "url", url.toString(), Object.class, this, pageContext);
        }catch(Exception e)
        {

        }
    }

    public Object  getUrl()
    {
        return this.url;
    }

    //标签开始时调用的处理方法
    public int doStartTag() throws JspException {
        //表示需要处理标签体
        return EVAL_BODY_BUFFERED;
    }


    @Override
    public int doEndTag() throws JspException
    {
        try
        {
            String source= this.getBodyContent().getString();
            User user= User.getUserFromRequest( (HttpServletRequest) this.pageContext.getRequest());
            String ip= FF.getClientIpAddr((HttpServletRequest) this.pageContext.getRequest());
            String corporationid=  FF.getCurrentCorporationIdForCurrenUser( (HttpServletRequest) this.pageContext.getRequest());

            if(AppCache.urlOnCommision(user.getId() , corporationid, url.toString() ,ip).getBoolean("commision",false))
            {
                this.pageContext.getOut().print( source);
            }


        }catch(Exception e)
        {
            //@off
            try{ this.pageContext.getOut().println(e.getMessage());}catch(Exception ee){}
            //@on

        }
        return SKIP_BODY;
    }
}
