package tag;

import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONObject;
import util.FF;
import webApp.FileWatch;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class SourceVersionTag extends BodyTagSupport
{


    public static ConcurrentHashMap<String, String> fileMD5Map = new ConcurrentHashMap<>();
    public static volatile  String fileMD5Code2Script = "";
    public static volatile   long   fileMD5Code2ScriptLastModifiedDate=-1;

    public static ArrayList<String>   ignoreList= new ArrayList<>();
    static
    {
        ignoreList.add( "js/spreadsheet/brick");
        ignoreList.add( "js/spreadsheet/cmd");
        ignoreList.add( "js/spreadsheet/core");
        ignoreList.add( "js/spreadsheet/db");
        ignoreList.add( "js/spreadsheet/edit");
        ignoreList.add( "js/spreadsheet/eval");
        ignoreList.add( "js/spreadsheet/fonts");
        ignoreList.add( "js/spreadsheet/gdi");
        ignoreList.add( "js/spreadsheet/img");
        ignoreList.add( "js/spreadsheet/mouse");
        ignoreList.add( "js/spreadsheet/node.js");
        ignoreList.add( "js/spreadsheet/plugin");
        ignoreList.add( "js/spreadsheet/tab");
        ignoreList.add( "js/spreadsheet/util");


    }

    public static FileWatch FW=null;

    public static void cacheFileMD5(String root)
    {
        long d1= System.currentTimeMillis();
        FF.log("扫描资源文件开始");
        JSONObject sb=new JSONObject();

        //如果增加了目录，需要同步修改startFileWatch

        cacheFileMD5At(root + "/AdminLTE", "AdminLTE" ,sb);
        cacheFileMD5At(root + "/css", "css" ,sb);
        cacheFileMD5At(root + "/js", "js",sb);
        cacheFileMD5At(root + "/globalscript", "globalscript",sb);
        cacheFileMD5At(root + "/template", "template",sb);
      //  cacheFileMD5At(root + "/ui", "ui",sb);

        FF.log("扫描资源文件结束，耗时："+ (System.currentTimeMillis() -d1)/1000 +"秒");

        fileMD5Code2Script= sb.toString(4);

        fileMD5Code2ScriptLastModifiedDate= System.currentTimeMillis();

    }

    public static  void startFileWatch(String root , Runnable callback)
    {
        FW=new FileWatch(new String[]{
                root+"/css",
                root+"/js",
                root+"/globalscript",
                root+"/ui" ,
                root + "/template"} , callback);
        FW.start();

    }

    public static void stopFileWath()
    {
        FW.exit=true;
    }


    public static void cacheFileMD5At(String path, String relativePath ,JSONObject sb )
    {

        File root = new File(path);
        String[] files = root.list();
        if (files == null) return;

        if(  ignoreList.contains(relativePath)) return; // 忽略的目录

        for (int i = 0; i < files.length; i++)
        {
            String name = files[i].toLowerCase();

            File f = new File(path, files[i]);

            String key = relativePath.isEmpty() ? files[i] : (relativePath + "/" + files[i]);


            if (f.isDirectory())
            {
                cacheFileMD5At(path + "/" + files[i], key ,sb); //递归下去
            }
            if (f.isFile())
            {
                if (!(name.endsWith(".js") || name.endsWith(".css"))) continue;

                String v = fileMD5(f.getPath());
                fileMD5Map.put(key, v);
                sb.put(key ,v);
                FF.log(key + " : " + v);
            }

        }

    }

    public static String fileMD5(String fileName)
    {
        try(InputStream  is= Files.newInputStream(Paths.get(fileName)))
        {
            return DigestUtils.md5Hex(is);
        } catch (Exception var2)
        {
            return "";
        }
    }

    //标签开始时调用的处理方法
    public int doStartTag() throws JspException
    {
        //表示需要处理标签体
        return EVAL_BODY_BUFFERED;
    }


    @Override
    public int doEndTag() throws JspException
    {
        try
        {
            String source = this.getBodyContent().getString();
            String md5 = fileMD5Map.get(source);
            if(md5==null) md5="1";  //没有也设置一下，

            this.pageContext.getOut().print(md5);


        } catch (Exception e)
        {
            //@off
            try{ this.pageContext.getOut().println(e.getMessage());}catch(Exception ee){}
            //@on

        }
        return SKIP_BODY;
    }

}
