package sso;

import app.User;
import util.AppCache;
import util.FF;
import util.Session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;

public class WhitelistCheck
{

    public static boolean whitelistCheck(HttpServletRequest request, HttpServletResponse response , String resourceid)
    {
        User user= User.getUserFromRequest(request);
        int userid= user.getId();
        String ip=FF.getIpAddr(request);

        if(!AppCache.whitelistCheck(userid, resourceid , ip) )
        {
            try
            {
                response.sendRedirect( FF.buildTipInfoURL("在"+ip+"地址，您无此权限"));
                return false;
            }catch(Exception e)
            {
                return false;
            }
        }
        return true;
    }
}

