package sso;

import app.User;
import appCache.UserAndDepartmentCache;
import config.CacheConfig;
import jun.db.impl.DataStoreFactory;
import jun.db.util.Base32Coder;
import org.json.JSONObject;
import rbac.URLFilter;
import util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;

public class SSOLoginCheck
{

    public static String UNLOGIN = "未登录";
    public static String loginCheckLoopCount = "loginCheckLoopCount";



    public static boolean loginCheck(HttpServletRequest request, HttpServletResponse response, boolean sysUserNeed )
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;


                boolean isSysUser = user.isSysUser();
                String error = "";


                if (!logined)
                {
                    //-10000 是 表示有异常 ，name放的是异常信息
                    if (user.getId() == -10000) return user.getName();
                    return UNLOGIN;
                }

                if (!sysUserNeed) return "";
                //需要是系统管理员
                if (isSysUser) return "";
                return "必须是拥有系统管理权限的人员";
            }
        });

    }


    public static boolean sysUserOrGroupMasterLoginCheck(HttpServletRequest request, HttpServletResponse response)
    {
        return sysUserOrGroupMasterLoginCheck(request, response, "");
    }

    public static boolean sysUserOrGroupMasterLoginCheck(HttpServletRequest request, HttpServletResponse response, String orURL)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;
                boolean isSysUser = user.isSysUser();

                String error = "";

                if (!logined) return UNLOGIN;

                if (isSysUser) return "";
                if ( user.isCorporationMaster()) return "";


                if (!orURL.isEmpty())
                {
                    String urlCheck = URLFilter.urlOnCommision(user.getId(),  FF.getCurrentCorporationIdForCurrenUser(request), orURL, FF.getClientIpAddr(request));
                    if (urlCheck.isEmpty()) return ""; //
                    if (urlCheck.equals("needNotcheck")) return ""; //


                }
                return "必须是拥有系统管理权限或者是企业管理员或工作台中有“人员管理”菜单项";

            }
        });

    }



    public static boolean loginAgain (HttpServletRequest request, HttpServletResponse response)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                String tokenid= FF.getTokenIdFromRequest(request);

                Session.removeCache(tokenid );
                FF.setSessionValue(request, User.currentLoginedUser, null);
                Session.removeCache(tokenid+":platform");

                return UNLOGIN;
            }
        });

    }


    public static boolean sysUserOrGroupMasterOrDeveloperLoginCheck(HttpServletRequest request, HttpServletResponse response)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;
                boolean isSysUser = user.isSysUser();


                String error = "";

                if (!logined) return UNLOGIN;

                if (isSysUser) return "";

                if (Session.isArchitect(user.getId())) return "";

                //看看是不是企业管理员 ，这个用得少，也就不没有做缓存
                //看看是不是企业管理员
                if( user.isCorporationMaster()) return "";

                return "必须是拥有系统管理权限或者是部门管理员或者有开发角色的用户";

            }
        });

    }

    public static boolean sysUserOrArchitectLoginCheck(HttpServletRequest request, HttpServletResponse response)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;
                boolean isSysUser = user.isSysUser();

                String error = "";

                if (!logined) return UNLOGIN;

                if (isSysUser) return "";

                if (Session.isArchitect(user.getId())) return "";

                return "必须是拥有系统管理权限或者有开发角色的用户";

            }
        });

    }

    public static boolean sysUserOrDeveloperLoginCheck(HttpServletRequest request, HttpServletResponse response)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;
                boolean isSysUser = user.isSysUser();

                String error = "";

                if (!logined) return UNLOGIN;

                if (isSysUser) return "";

                if  ( user.isDeveloper()) return "";

                return "必须是拥有系统管理权限或者有开发权限的用户";

            }
        });

    }

    public static boolean developerLoginCheck(HttpServletRequest request, HttpServletResponse response)
    {

        return loginCheck(request, response, new ILoginCheck()
        {
            @Override
            public String check(User user)
            {
                boolean logined = user.getId() >= 0;

                String error = "";

                if (!logined) return UNLOGIN;


                if  ( user.isDeveloper()) return "";

                return "必须是拥有开发权限的用户";

            }
        });

    }

    /**
     * 本函数用在ssoLoginCheck.jsp中，检测是否已经登录 ，如果未登录，那么跳转到登录页
     *
     * @param request
     * @param response
     */
    public static boolean loginCheck(HttpServletRequest request, HttpServletResponse response,   ILoginCheck check)
    {

        TimeStamp tm= new TimeStamp(true);
        try
        {

            //改密码页面需要先登录，但是不要校验是否过期，不然就死循环了
            boolean forceDontExpireCheck =  request.getRequestURI().indexOf("sys_user_changepwd")>=0 ;

            User user = User.getUserFromRequest(request);

            tm.stamp("获取用户信息");
            //tm.stamp( FF.stackTrace());
            boolean logined = user.getId() >= 0;
            boolean isSysUser = user.isSysUser();
            String error = check.check(user);

            if (error.isEmpty())  //已登录 ，再看看有没有登录绑定控制
            {

                String homeURL =  request.getRequestURL().toString().substring(0, request.getRequestURL().length() - request.getRequestURI().length()) ; //FF.getHomeURL();

                //为什么要在这里再检查一下呢
                //因为使用第三方登录校验时，它的用户是已登录状态，此时你不能说他没有登录，不然会陷入循环获取用户信息中
                // 只能在校验用户是否登录时 ，再做绑定检查

                //绑定
                if (CacheConfig.get("/登录管理/登录绑定", "false").equals("true"))
                {

                    int userid= user.getId();
                    String clientcode = user.lastloginclientcode; //当前登录时的客户识别码
                    //2020.07.25  改成从缓存中取，而不是从user的属性中取，因为修改了用户的登录 绑定后，已经放在user中的clientcode 不会同步更新
                    String t =FF.decryptString(  AppCache.getCache(UserAndDepartmentCache.prefix_userid2clientcode+ userid, "")); //绑定设置
                    t = t.replaceAll("\\s", "");  //空格回车替换掉
                    String[] ts = t.split(",");
                    boolean isValidClientCode = false;
                    for (int i = 0; i < ts.length; i++)
                    {
                        String s = ts[i].trim();
                        if (s.equals(clientcode) || s.equals("*"))
                        {
                            isValidClientCode = true;
                            break;
                        }
                    }

                    if (!isValidClientCode)
                    {
                        String tipInfo = "";
                        if (clientcode.isEmpty()) tipInfo = "请在启动辅助登录程序后，再刷新本页面";
                        tipInfo = user.getName()+"，您好，当前设备未做登录授权，禁止登录";


                        response.sendRedirect(homeURL + "/"+FF.buildTipInfoURL(tipInfo ));
                        return false;
                    }
                }


                if (  ! forceDontExpireCheck && CacheConfig.get("/安全/密码策略/enabled", "false").equals("true"))
                {
                    int  expireDays =CacheConfig.get("/安全/密码策略/expire",60);

                    Date d= user.getPWDModifiedDate();
                    DateTool dt= new DateTool();
                    if( dt.daysBetween( new Date() , d )> expireDays)
                    {
                        String tipInfo = "";

                        tipInfo = user.getShowName()+"，您好，密码已过期<br><br><br><a class=\"btn btn-primary\" href=\"sso/sys_user_changepwd?relogin=true\">修改密码并重新登录</a>";


                        response.sendRedirect(homeURL + "/"+ FF.buildTipInfoURL(tipInfo ));
                        return false;
                    }

                    String pwdState=  user.getPasswordState();
                    if( !pwdState.equalsIgnoreCase(""))
                    {
                        String tipInfo = "";

                        tipInfo = user.getShowName()+"，您好，您的密码过于简单，"+pwdState+"<br><br><br><a class=\"btn btn-primary\" href=\"sso/sys_user_changepwd?relogin=true\">修改密码并重新登录</a>";


                        response.sendRedirect(homeURL + "/"+ FF.buildTipInfoURL(tipInfo ));
                        return false;
                    }


                }

                FF.setSessionValue(request, "loginCheckLoopCount", "0");
                return true;
            }

            String homeURL =  request.getRequestURL().toString().substring(0, request.getRequestURL().length() - request.getRequestURI().length()) ; //FF.getHomeURL();
            String  t= FF.getVMProperty("APP_HOME","");
            if (!t.isEmpty())
            {
                homeURL= t;
                FF.log("强制 homeURL=" + homeURL);
            }
            if( homeURL.endsWith("/")) homeURL= homeURL.substring(0 , homeURL.length()-1);


            String style = FF.getStringFromRequest(request, "style", "");
            String qs = request.getQueryString();
            if (qs == null) qs = "";
            if (!qs.isEmpty()) qs = "&" + qs;

            if (error.equals(UNLOGIN))
            {
                error = URLEncoder.encode(error, "UTF-8");

                //从Eureka服务中查找登录服务的地址

                String selfServer = Base32Coder.encode(homeURL);
                String ssoLoginURL = homeURL+"/sso" ; //  ServiceUtil.getHomeURLForService("sso");
                // FF.log(" sso 地址" + ssoLoginURL);

                //为什么不直接用 request.getRequestURL 而是用homeURL+  requestURI 呢
                //因为 可能homeURL是 http://本机IP ,而   requestURL 是 http://localhost/a.jsp;
                // 在浏览器中 http://本机IP与 http://localhost 虽然访问的是同一个结果，但是它们却不能共享cookie 就是说，如果是http://ip/a.jsp写的cookie
                //在  http://localhost/b.jsp中是不能读取的。所以必须把地址统一成一样的
                String queryString = request.getQueryString();
                queryString = queryString == null ? "" : ("?" + queryString);

             //   String backToURL = homeURL.substring(0, homeURL.length() - request.getContextPath().length())
                   //     + request.getRequestURI().toString() + queryString;
                String backToURL = request.getRequestURL()+ queryString;

                int loopCount = FF.String2Int(FF.getSessionValue(request, loginCheckLoopCount, "0").toString());

                if (loopCount < 3000)  //这个做什么用，忘记了，原来是3
                {
                    //跳到登录页，并告知登录页在登录后需要跳回来的页面以及登录者给登录服务器的临时令牌
                    // 为什么要加上qs ,可能是需要把参数传到登录控制中，而不仅仅是作用于回跳页面

                    loopCount++;
                    FF.setSessionValue(request, loginCheckLoopCount, loopCount);
                    backToURL = Base32Coder.encode(backToURL, "UTF-8");

                    ssoLoginURL = ssoLoginURL + "/login?backToServer=" + selfServer + "&backToURL=" + backToURL + "&error=" + error + qs;


                }
                else
                {
                    FF.setSessionValue(request, "loginCheckLoopCount", "0");
                    ssoLoginURL = "/"+ FF.buildTipInfoURL("请登录");
                }

                FF.log("没有登录，跳转到：" + ssoLoginURL);

                response.sendRedirect(ssoLoginURL);
            }
            else//如果是已登录，则显示错误提示
            {

                response.sendRedirect(homeURL + "/"+ FF.buildTipInfoURL(error));
            }

            return false;

        } catch (Exception e)
        {
            FF.log("SSOLoginChecked.mustLogined  error:" + e.getMessage());
            return false;
        }finally
        {
            tm.stamp("登录校验完成");
        }

    }

    /**
     * 本函数仅用在login.jsp中，如果已经在A系统中登录，那么把登录的tokeid返回给B系统，不需要再次登录，实现多系统的单点登录
     *
     * @return
     */
    public static boolean hadLogined(HttpServletRequest request, HttpServletResponse response) throws IOException
    {
        //如果没有URL参数 ，那么就直接登录 ，否则检验是不是已经登录过了
        String backToServer = FF.getStringFromRequest(request, "backToServer", "");
        String backToURL = FF.getStringFromRequest(request, "backToURL", "");
        if (!backToURL.isEmpty())
        {
            //带了这两个参数的，通常是B系统还没有登录，但是可能A系统已经登录了，所以要先看看是不是的tokenid,如果有，则直接
            //返回给B系统


            //注意，为什么不是直接用    FF.getTokenIdFromRequest() 呢，因为 它不仅是从cookie中取token，而且从头，属性及url参数中获取
            // 可难会忽略掉设置 cookie的操作，不利于于其它服务获取用户信息。
            String tokenid = FF.getCookie(request, "tokenid", "/", "");



            //FF.log(" tokenid=" + tokenid);
            if (!tokenid.isEmpty()) //已经登录过了，存在了该cookie
            {
                FF.log("似乎已登录，继续检查 ");
                User user = User.getUserFromTokenId(tokenid);
                //不仅要cookie存在，并且，用户必须是没有过期的
                if (user.getId() < 0)
                {

                    return false;
                }


                String key = DataStoreFactory.newGUID();
                Session.setCache(FF.encryptString(key), "ok");//生成一个临时口令给客户端，让它能够以get方式设置cookie
                backToServer = new String(Base32Coder.decode(backToServer), "UTF-8");
                JSONObject js = new JSONObject();
                js.put("token", tokenid);
                js.put("key", key);
                String loginToken = FF.encryptString(js.toString());

                FF.log("回跳到原地址");
                String url = backToServer + "/SSOLoginCallback?backToURL=" + backToURL + "&loginToken=" + loginToken;

                FF.log("原地址 "+ url);
                response.sendRedirect(url);
                return true;

            }

        }
        return false;

    }

    public static boolean dbpoolCheck(HttpServletRequest request, HttpServletResponse response)
    {
        try
        {
            if (DBF.dbPoolCount() == 0)
            {
                String configURL = /* ServiceUtil.getHomeURLForService("config") */"/config"+ "/maindbConfig.jsp";
                response.sendRedirect(configURL);

                return false;
            }
            return true;
        } catch (Exception e)
        {

            return false;
        }
    }
}
