package sso;

import config.CacheConfig;
import jun.db.util.Base32Coder;
import org.json.JSONObject;
import util.Session;
import util.FF;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;

@WebServlet(name = "SSOLoginCallback", urlPatterns = "/SSOLoginCallback")
public class SSOLoginCallback extends HttpServlet
{
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        String loginToken = FF.getStringFromRequest(request, "loginToken", "");
        if (loginToken.isEmpty()) return;

        loginToken = FF.decryptString(loginToken);
        JSONObject js = new JSONObject(loginToken);
        String tokenid = js.getString("token", "");
        String key = js.getString("key", "");
        boolean needKey = js.getBoolean("needkey", false);

        key = FF.encryptString(key);
        String keyState = Session.getCache(key, "");


        if (needKey)
        {
            //2020.11.20 下面校验在此之前是被去掉了的，我想不起为什么要去掉校验，理论上是需要校验的，
            //但是在去掉它的情况下，sixi包括其它系统都运行正常 ，所以也不敢贸然又加上，
            // 所以只好在隐式登录中加一个参数 needkey 当needkey=true时，就做校验
            // 默认还是不校验
            if (keyState.isEmpty())
            {
                response.sendRedirect(FF.buildTipInfoURL("loginToken可能已过期，请重新登录"));
                return;
            }
        }

        if (keyState.startsWith("born"))
        {

            long timeout = CacheConfig.get("/登录管理/第三方隐式登录/timeoutsecond", 2 * 60 * 60) * 1000;
            long born = FF.String2Long(keyState.substring(4));
            boolean expiration = System.currentTimeMillis() > born + timeout;
            if (expiration)
            {
                Session.removeCache(key);
                response.sendRedirect(FF.buildTipInfoURL("loginToken 已过期，请重新申请token"));
                return;
            }

        }
        else
        {
            Session.removeCache(key);
        }

      /*
      同站 Cookie (SameSite Cookies) (现代、简单)
        这是一个浏览器端的解决方案，只需要设置一个 Cookie 属性即可，非常简单有效。

        如何工作：
        在设置 Cookie 时，增加 SameSite 属性。

        SameSite=Strict：最严格。完全禁止第三方 Cookie（即来自其他站点的请求不会发送此 Cookie）。适用于非常敏感的操作（如支付）。

        SameSite=Lax：（默认值）宽松模式。大多数情况下不发送第三方 Cookie，但一些安全的顶级导航（如从邮件中点链接跳转）会发送。是很好的平衡选择。

        SameSite=None：关闭此限制，Cookie 会在所有上下文中发送。必须与 Secure 属性（HTTPS）一同使用。

        示例（服务器设置响应头）：

  　*/
        //到这里，已经成功返回一个登录令牌了,设置用户令牌，完成登录
        FF.setCookie(response, "tokenid", "/", tokenid, -1);  //-1表示是只存在于浏览器中，一旦浏览器关闭，则自动消失
        //成功设置cookie后，跳转到目标页面
        String backToURL = FF.getStringFromRequest(request, "backToURL", "");
        backToURL = new String(Base32Coder.decode(backToURL), "UTF-8");

       /*
        String homeURL= App.getInstance().getHomePageUrl(true);

        int p = homeURL.indexOf("/",8);

        backToURL= backToURL.substring( p+1 );
        if(!App.appName.equals("app")) backToURL=backToURL.substring( App.appName.length()+1);
        */
        FF.log("back to url :" + backToURL);
        response.sendRedirect(backToURL);
    }
}
