package rpc;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**注解作用在方法上*/
@Target({ElementType.METHOD})
/**注解的生命周期一直程序运行时都存在VM运行期间保留注解，可以通过反射机制读取注解信息*/
@Retention(RetentionPolicy.RUNTIME)


/**
 * 本注解用在RPC的方法上，表示本方法需要记录日志
 */
public @interface NeedRPCLog {

    public String  comment()  default "";
}

