package rbac;

import app.User;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import jun.db.util.TimeMark;
import org.json.JSONArray;
import org.json.JSONObject;
import util.*;
import webApp.App;
import websocketRPC.log.RPCLog;
import websocketRPC.log.RPCLogPool;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;


@WebFilter(filterName = "URLFilter", urlPatterns = "/*")

public class URLFilter implements Filter
{


    public static boolean needXSSCheck = FF.getVMProperty("APP_XSS_FILTE", "false").equalsIgnoreCase("true");

    private static String contextPath = null;
    private static String TipURL = null;
    public static String[] mimeNeedCheck = new String[]{"jsp", "htm"};

    public static Exception norightExceptSysUser = new Exception("仅管理员允许访问");
    public static Exception XSSException = new Exception("非法脚本注入");


    public static ArrayList<String> igonreURIList = new ArrayList<String>();

    static
    {
        igonreURIList.add("tipinfo.jsp");
        igonreURIList.add("helthcheck");
        igonreURIList.add("status");
        igonreURIList.add("login.jsp");
        igonreURIList.add("login");
        igonreURIList.add("tipinfo.jsp");

        igonreURIList.add("SSOLoginCallback");
        igonreURIList.add("RPCRouter");
        igonreURIList.add("share");
        igonreURIList.add("resource");
        igonreURIList.add("runTask");  //
        igonreURIList.add("websocket");  //
        igonreURIList.add("billedit");  // 2024.05.05 在url上不要直接校验权限， 具体的控制参看 billedit.jsp中的
        igonreURIList.add("m-billedit");  // 2024.05.05 在url上不要直接校验权限， 具体的控制参看 billedit.jsp中的

        igonreURIList.add("config_tree_main.jsp");  //这个通过程序控制了权限，不要再url控制了，因为一些文档 ， 字典设置， 部门，企业设置，可能会加入工作台

    }

    public void init(FilterConfig arg) throws ServletException
    {

    }

    public static boolean neednotFilter(String uri)
    {

        int p = uri.lastIndexOf("/");
        if (p >= 0) uri = uri.substring(p + 1);

        if (igonreURIList.contains(uri)) return true;
        return false;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException
    {

        TimeStamp tm = new TimeStamp(false); //一定要 false，避免其中输出日志，进行过多的调用
        boolean continueChain = true;
        HttpServletRequest httpReq = (HttpServletRequest) (req);
        HttpServletResponse httpRes = (HttpServletResponse) res;

        String uri = httpReq.getRequestURI();

        if (!App.needURLFilter)
        {
            //有一些是不能忽略过去，必须要校验仅限
            if (uri.indexOf("/druid/") < 0)
            {
                chain.doFilter(req, res);
                return;
            }
        }


        String relativePath = "";

        try
        {


            String method = httpReq.getMethod().toLowerCase();


            if (needXSSCheck)
            {
                String queryString = httpReq.getQueryString();
                if (queryString != null)
                {
                    if (method.equals("get") && queryString.toLowerCase().indexOf("%3cscript%3e") >= 0)
                        throw XSSException;
                }
            }

            //连接池的控制
            if (uri.indexOf("/druid/") >= 0)
            {
                User user = User.getUserFromRequest(httpReq);  //这个操作，会引起登录重定向，所以需要放在后面操作，不然可能在login.jsp那里死循环
                //2022.10.19 有时候无法登录但想看看连接池情况，可以用密码
                if (user.isSysUser() || FF.getStringFromRequest(httpReq, "token", "").equals("bry3jhhrhl"))
                {
                }
                else
                {
                    relativePath = "../";
                    throw norightExceptSysUser; //系统管理员，不受权限的限制
                }
            }

            if (uri.indexOf("/url") >= 0)
            {
                String id = httpReq.getQueryString();
                if (id == null) id = "err";

                DataStore ds = DataStoreFactory.newDataStore("", "select *  from app_urlshare where id=" + id);
                ds.setUpdateProperty("app_urlshare", "id", "*", "id");
                ds.retrieve();
                if (ds.getRowCount() == 0) throw new Exception("非法的共享地址");
                Date d1 = new Date();
                Date d2 = ds.getDate(0, "expirydate");
                int lc = ds.getInt(0, "limitcount");
                if (d2.getTime() < d1.getTime())
                {

                    ds.deleteRow(0);
                    ds.update(true);
                    throw new Exception("共享地址已过期");
                }
                if (lc != -1)
                {
                    int vc = ds.getInt(0, "visitedcount") + 1;
                    if (vc > lc)
                    {

                        ds.deleteRow(0);
                        ds.update(true);
                        throw new Exception("共享地址已达访问次数上限，禁止再访问");

                    }
                    else
                    {
                        ds.setValue(0, "visitedcount", vc);
                        ds.update(true);
                    }
                }
                String jumpTo = ds.getString(0, "url");
                //用 forward 可以隐藏真实地址
                FF.log("重定向：" + jumpTo);

                httpReq.getRequestDispatcher(jumpTo).forward(httpReq, httpRes);
                return;

            }

            //不管是POST，还是GET。都要近扩展名，进行检验，防止以模拟表单POST提交的方式来打开页面
            boolean needCheck = false;

            if (uri.indexOf(".") > 0)
            {
                for (int i = 0; i < mimeNeedCheck.length; i++)
                {

                    if (uri.indexOf("." + mimeNeedCheck[i]) > 0)
                    {
                        needCheck = true;
                        break;
                    }
                }
            }
            else
            {
                needCheck = true;
            }

            if (!needCheck) return;

            if (neednotFilter(uri)) return;  //登录页，不需要过滤，所以直接返回


            User user = User.getUserFromRequest(httpReq);  //这个操作，会引起登录重定向，所以需要放在后面操作，不然可能在login.jsp那里死循环


            if (user.getId() < 0) return; //没有登录 ，就不用校验了，直接到页面中让页面决定是继续，还是跳到登录页


            String url = getShortURL(httpReq);
            //以post提交的页面，通常不会是通过在地址栏上输入地址的方式来访问的，所以
            //通常不需要进行安全控制。

            if (method.equals("post"))
            {
                //对于post的jsp , 以前是在 jsp中加上这两行， 现在直接加到这里

                req.setCharacterEncoding("UTF-8");
                res.setContentType("text/html; charset=UTF-8");

            }


            String check = urlOnCommision(user.getId(), FF.getCurrentCorporationIdForCurrenUser(httpReq), url, FF.getClientIpAddr(httpReq));

            if (check.equals("needNotcheck"))   //url不需要校验权限，那么也不需要日志
            {
                continueChain = true;
                return;
            }


            if (!check.isEmpty())
            {


                // 如果把字典表放到工作台上，那么所有系统设置都会变成因为参数比这个工作台的参数少而变成没有权限了
                // 所以对于系统管理员，不受工作台权限限制
                if (uri.indexOf("config_tree_main.jsp")>=0 && user.isSysUser())   //系统管理员，不受权限的限制
                {


                }
                else
                {
                    String errorURL = FF.buildTipInfoURL(check);
                    continueChain = false;
                    httpRes.sendRedirect(errorURL);
                    return;
                }
            }


            continueChain = true;


            tm.stamp("over");
            boolean needLog = CacheConfig.get("/日志/工作台URL访问日志/enabled", false);
            if (needLog)
            {
                RPCLogPool.push(new RPCLog(
                        FF.getIpAddr(httpReq),
                        "URL",
                        url,
                        new Date(),
                        user.getShowName(),
                        user.lastloginclientcode, user.getId(), "记录的是校验耗时，非打开耗时", tm.getCost())
                );
            }

        } catch (Exception e)
        {
            String errorURL = relativePath + FF.buildTipInfoURL(e.getMessage());
            continueChain = false;
            httpRes.sendRedirect(errorURL);
            return;

        } finally
        {
            //res.sendRedirect方法不能与chain.doFilter(request, response)同时调用
            if (uri.indexOf("/api/") >= 0)
            {
                String newURL = uri.replaceAll("/api/", "/runTask?task=");

                //  httpRes.sendRedirect(newURL);
                continueChain = false;
                httpReq.getRequestDispatcher(newURL).forward(httpReq, httpRes);

                return;
            }

            if (uri.indexOf("/rest/") >= 0)
            {
                String newURL = uri.replaceAll("/rest/", "/runTask?task=");
                continueChain = false;

                httpReq.getRequestDispatcher(newURL).forward(httpReq, httpRes);
                return;
            }




            if (chain != null && continueChain && !httpRes.isCommitted()) chain.doFilter(req, res);
        }

    }

    public static String getTipURL()
    {
        try
        {
            if (TipURL == null) TipURL = /*ServiceUtil.getHomeURLForService("app")  + */ "/tipinfo.jsp";
            return TipURL;
        } catch (Exception e)
        {
            return "/tipinfo.jsp";
        }
    }


    /**
     * 去掉上下文路径后的url地址
     *
     * @param httpReq
     * @return
     */
    public static String getShortURL(HttpServletRequest httpReq)
    {
        if (contextPath == null) contextPath = httpReq.getContextPath() + "/";

        String s = httpReq.getRequestURI();

        s = httpReq.getServletPath();

        if (s.startsWith("/")) s = s.substring(1);

        String qs = httpReq.getQueryString();
        if (qs == null) qs = "";
        if (!qs.isEmpty()) qs = "?" + qs;
        String url = s + qs;
        return url;
    }

    public static String getFullURL(HttpServletRequest httpReq)
    {

        String url = httpReq.getRequestURL().toString();

        String qs = httpReq.getQueryString();
        if (qs == null) qs = "";
        if (!qs.isEmpty()) qs = "?" + qs;

        return url + qs;
    }


    public static String urlOnCommision(int userid, String corporationid, String url, String ip)
    {

        long d1 = System.currentTimeMillis();
        JSONObject js = AppCache.urlOnCommision(userid, corporationid, url, ip);
        long d2 = System.currentTimeMillis();
        FF.log(url + " 对 userid=" + userid + "的权限校验耗时：" + (d2 - d1) + " ms ");

        boolean b1 = js.getBoolean("commision", false);
        boolean b2 = js.getBoolean("whitelistCheckPass", true);

        boolean b3 = js.getBoolean("needNotCheck", false);

        if (b3) return "needNotcheck";
        if (b1 && b2) return "";


        String ret = "";
        if (!b1) ret = "您无此权限";
        if (!b2) ret = "您无此权限。";

        FF.log(ret);
        return ret;


    }

    public void destroy()
    {

    }
}
