package rbac;

import app.User;
import org.json.JSONObject;
import util.AppCache;
import util.FF;
import webApp.App;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;


@WebFilter(filterName = "FileServerFilter", urlPatterns = "/fs/*")

public class FileServerFilter implements Filter
{


    private static String contextPath = null;
    private static String TipURL = null;


    public void init(FilterConfig arg) throws ServletException
    {

    }


    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException
    {


        boolean continueChain = true;
        HttpServletRequest httpReq = (HttpServletRequest) (req);
        HttpServletResponse httpRes = (HttpServletResponse) res;


        String uri = "";
        try
        {


            continueChain = true;
            uri = httpReq.getRequestURI();


            String fs = "/fs/";
            int p = uri.indexOf(fs);
            String t = uri.substring(p + fs.length());

            p = t.indexOf("/");
            String serverIndex = t.substring(0, p);
            String objectName = t.substring(p + 1);

            //forward 是相对当前地址的地址
            //比如    /formEngine/fs/1/a/b/c/d.jpg
            //如果要重定向到  /formEngine/fileServer?serverIndex=1&objectName=a/b/c/d.jpg
            //就需要用   forward( "../../../../../fileServer?serverIndex=1&objectName=a/b/c/d.jpg");
            // 即 objectName 中/出现的次数再+2   [ /fs/1 里面有2个/ ]
            String newURL =  repeatString( "../" , 2+  objectName.length() - FF.replaceAll(objectName,"/","").length() ,"")+
                    "fileServer?serverIndex=" + serverIndex + "&objectName=" + objectName;

            httpReq.getRequestDispatcher(newURL).forward(httpReq, httpRes);

            continueChain = false;


        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));

        } finally
        {

            if (chain != null && continueChain && !httpRes.isCommitted()) chain.doFilter(req, res);
        }

    }


    public static String repeatString(String str, int n, String seg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; i++) {
            sb.append(str).append(seg);
        }
        return sb.substring(0, sb.length() - seg.length());
    }


    public void destroy()
    {

    }
}
