package platform;

import appCache.UserAndDepartmentCache;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import util.AppCache;
import util.DBF;
import util.FF;
import util.RPCRouter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;

public class WX implements IPlatform
{

    public static ConcurrentHashMap<String, WX> wxInsts = new ConcurrentHashMap();//平台对应的企业微信接入对象

    String platform = "";

    private volatile String g_access_token = "";  //不要直接访问
    private volatile long g_access_token_expire = 0;


    public volatile String appID = "";
    public volatile String appSecret = "";


    public static void reset()
    {
        wxInsts.clear();
    }

    private WX(String platform)
    {

        this.platform = platform;
        JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);
        if (cfg == null) return;

        appID = cfg.getString("wx_appid", "");
        appSecret = cfg.getString("wx_secret", "");
        if (appSecret.startsWith("encryped:"))
        {
            appSecret = appSecret.substring(9);
            appSecret = FF.decryptString(appSecret);

        }
        g_access_token = "";
        g_access_token_expire = 0;
    }

    public static WX getInstance(String platform)
    {
        if (wxInsts.containsKey(platform)) return wxInsts.get(platform);
        WX ins = new WX(platform);
        wxInsts.put(platform, ins);
        return ins;
    }

    @Override
    public JSONObject getUserInfoWithCode(String code) throws Exception
    {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appID + "&secret=" + appSecret + "&code=" + code
                + "&grant_type=authorization_code";
        String parm = FF.getStringFromURL(url, "UTF-8");

        JSONObject js = new JSONObject(parm);
        return js;
    }

    @Override
    public JSONObject getUserInfoWithOpenID(String openID) throws Exception
    {
        JSONObject js = null;

        //得到用户信息，通过openid
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + getAccessToken() + "&openid=" + openID + "&lang=zh_CN";
        String parm = FF.getStringFromURL(url, "UTF-8");

        js = new JSONObject(parm);

        return js;
    }

    //https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html#3
    // 网页授权接口调用凭证,注意：此access_token与基础支持的access_token不同
    public JSONObject getUserInfoWithOpenID(String openID, String access_token) throws Exception
    {
        JSONObject js = null;

        //得到用户信息，通过openid   网页授权接口调用凭证,注意：此access_token与基础支持的access_token不同

        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openID + "&lang=zh_CN";
        String parm = FF.getStringFromURL(url, "UTF-8");

        js = new JSONObject(parm);

        return js;
    }

    @Override
    public JSONObject getUserInfoWithUserTicket(String user_ticket) throws Exception
    {
        return null;
    }

    @Override
    public String getAccessToken() throws Exception
    {
        long now = System.currentTimeMillis();
        if (now < g_access_token_expire && !g_access_token.isEmpty()) return g_access_token;


        String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";


        String url = String.format(ACCESS_TOKEN_URL, appID, appSecret);
        // 根据url通过https请求获取accesstoken
        JSONObject ret = new JSONObject(FF.getStringFromURL(url, "UTF-8"));

        if (ret.getInt("errcode", 0) == 0)
        {

            g_access_token = ret.getString("access_token", "");
            g_access_token_expire = now + (ret.getInt("expires_in", 7200) - 100) * 1000; // 失效时间
            return g_access_token;

        }
        else
        {
            FF.log(" getAccessToken 失败：" + ret.getString("errmsg", ""));
            return "";
        }

    }


    @Override
    public JSONObject login(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        JSONObject ret = new JSONObject("{success:true}");
        try
        {
            String code = FF.getStringFromRequest(request, "code", "");
            String state = FF.getStringFromRequest(request, "state", "");
            String mobile = FF.getStringFromRequest(request, "mobile", "");
            //如果某个页面中有code参数，那么在登录时，此code也会传到登录页中，此时的code并不是微信回传的code
            //所以再加上 state ，两个参数一起判断
            //但是最好是url地址上不要有code参数名
            //第一次从微信进入loginWX.jsp页，没有code，没有mobile
            if (code.isEmpty() && mobile.isEmpty())
            {
                return 微信重定向(request, appID);
            }

            //从 code=='' 跳转到微信的登录验证再回跳回来带上code再到这里，时间不能超过10秒 ， 超过后，code会无效，调试时要注意这一点
            // 公众号中获取用户详情时，没有手机信息，因此需要做一个输入手机号并绑定用户的过程
            //从上面的微信页重定向再次进入loginWX.jsp时， 有code，没有mobile
            if (!code.isEmpty() && mobile.isEmpty())
            {
                return 微信code取用户信息后再次回前端设置手机号(request, response, login);
            }

            //第三次输入手机号，并且输入验证码后，进入 loginWX.jsp
            if (code.isEmpty() && !mobile.isEmpty())
            {
                String data = FF.getStringFromRequest(request, "info", "");
                JSONObject wxUserInfo = new JSONObject(FF.decryptString(data));

                //这些信息都在 data中，
                String openID = wxUserInfo.getString("openid", "");
                String nickname = wxUserInfo.getString("nickname", "");
                String headimgurl = wxUserInfo.getString("headimgurl", "");
                String backToServer = wxUserInfo.getString("backToServer", "");
                String backToURL = wxUserInfo.getString("backToURL", "");

                String smsCode = FF.getStringFromRequest(request, "smscode", "");

                return 使用手机号绑定本在用户或新注册用户(request, response, login ,openID, nickname, headimgurl, backToServer, backToURL ,mobile, smsCode);
            }

        } catch (Exception e)
        {
            FF.log("  wx login error: " + e.getMessage());
            ret.put("success", false);
            ret.put("message", e.getMessage());

        }

        return ret;
    }


    public JSONObject 微信重定向(HttpServletRequest request, String appID) throws Exception
    {
        JSONObject ret = new JSONObject("{success:true}");


        String OAUTH_CODE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=state#wechat_redirect";
        String callbackUrl = request.getRequestURL().toString() + "?" + request.getQueryString();
        callbackUrl = URLEncoder.encode(callbackUrl, "utf-8");

        if (appID.isEmpty()) throw new Exception("请先设置相关参数,可能是入口地址中plateform参数没有设置");
        String weixinUrl = String.format(OAUTH_CODE_URL, appID, callbackUrl);
        // response.sendRedirect(weixinUrl);
        ret.put("backToURL", weixinUrl);
        return ret;

    }

    public JSONObject 微信code取用户信息后再次回前端设置手机号(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login) throws Exception
    {

        JSONObject ret = new JSONObject("{success:true}");
        String code = FF.getStringFromRequest(request, "code", "");

        JSONObject js = getUserInfoWithCode(code);

        String openID = js.getString("openid", "");
        String access_token = js.getString("access_token", "");

        JSONObject wxUserInfo = getUserInfoWithOpenID(openID, access_token);


        String nickname = wxUserInfo.getString("nickname", "");
        String headimgurl = wxUserInfo.getString("headimgurl", "");

        String backToServer = FF.getStringFromRequest(request, "backToServer", "");
        String backToURL = FF.getStringFromRequest(request, "backToURL", "");

        DataStore dsMap = DataStoreFactory.newDataStore("", "select * from app_user_map where   openid='" + openID + "'");

        //先不按平台，只按openID查询， 因为同一个微信公众号里挂多个菜单时，它带入的openID是一样的，
        dsMap.retrieve();
        if( dsMap.getRowCount()>0)
        {
            String  mobile= dsMap.getString(0,"mobile");
            //如果一个公众号挂了多个本系统的地址，那么openID是一样的， 取到手机号，直接绑定，不要再输入手机号了
            if( !mobile.isEmpty())  使用手机号绑定本在用户或新注册用户(request, response, login ,openID, nickname, headimgurl, backToServer, backToURL ,mobile, null);
            //上面已经做了绑定，下面取一下即可
        }

        DataStore ds = DataStoreFactory.newDataStore("", " select * from app_user ");

        dsMap.setUpdateProperty("app_user_map", "id", "*", "id");

        dsMap.retrieve( " platform='" + platform +  "' "  );
        if (dsMap.getRowCount() > 0)// 关联过用户
        {
            int userid = dsMap.getInt(0, "userid");  //找到映射的用户
            ds.retrieve(" id=" + userid);
            if (ds.getRowCount() == 0) // 用户不存在，那么删除映射关系
            {
                dsMap.deleteRow(0);
                dsMap.update(true);
            }
        }

        if (ds.getRowCount() > 0)
        {
            int id = ds.getInt(0, "id");
            String name = ds.getString(0, "name");
            String pwd = ds.getString(0, "password");
            int freezed = ds.getInt(0, "freezed");
            if (freezed == 1) throw new Exception("用户未开放，请联系管理员");
            ds.setUpdatable(false); //防止下面修改数据后误保存
            ds.setValue(0, "password", null); //注意把密码清除掉， 其实放着也没事，是MD5后的数据，无法逆向出密码
            JSONObject userInfo = ds.getJSON(0, false);
            userInfo.put("userInfoType", "local");
            ret = login.login(userInfo, request, response, backToServer, backToURL);
            ret.put("needReg", false); //不需要关联用户
        }
        else
        {
            ret.put("success", true);
            ret.put("needReg", true); //需要关联用户
            ret.put("mesasge", "输入手机号绑定或创建用户");
            ret.put("messageClass", "is-white");
            ret.put("nickname", nickname);
            ret.put("headimgurl", headimgurl);
            JSONObject info = new JSONObject();
            info.put("backToServer", backToServer);
            info.put("backToURL", backToURL);
            info.put("nickname", nickname);
            info.put("headimgurl", headimgurl);
            info.put("openid", openID);
            //数据加密后返回备用
            ret.put("info", FF.encryptString(info.toString()));
        }

        return ret;
    }

    public JSONObject 使用手机号绑定本在用户或新注册用户(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login ,
           String openID, String nickname, String headimgurl, String backToServer, String backToURL ,String mobile, String smsCode ) throws Exception
    {
        JSONObject ret = new JSONObject("{success:true}");



        try
        {
            if( smsCode!=null)
            {
                if (smsCode.isEmpty()) throw new Exception("请输入验证码");
                String code = AppCache.getCache("SMS:wx:code:" + mobile, "");
                if (!smsCode.equals(code)) throw new Exception("验证码错误");
                AppCache.removeCache("SMS:wx:code:" + mobile);
            }

            //绑定用户
            DataStore dsMap = DataStoreFactory.newDataStore("", "select * from app_user_map where  platform='" + platform +
                    "' and openid='" + openID + "'");

            DataStore ds = DataStoreFactory.newDataStore("", " select * from app_user ");

            dsMap.setUpdateProperty("app_user_map", "id", "*", "id");
            dsMap.retrieve();

            if (dsMap.getRowCount() > 0)// 关联过用户
            {
                int userid = dsMap.getInt(0, "userid");  //找到映射的用户
                ds.retrieve(" id=" + userid);
                if (ds.getRowCount() == 0) // 用户不存在，那么删除映射关系
                {
                    dsMap.deleteRow(0);
                    dsMap.update(true);
                }
            }

            if (dsMap.getRowCount() == 0)//没有关联过用户,或者上面无效关联，那么重新建立关联
            {

                String showname = nickname;
                String email = "";

                ds.retrieve("mobile='" + mobile + "'");

                int userid = -9999;
                if (ds.getRowCount() > 0) //手机号已存在，表示用户信息已经存在，只需要建立关联关系就可以
                {
                    //这种情况就是 手机号在本系统中已存在，但没有建立关联关系，
                    userid = ds.getInt(0, "id");

                    //同步头像
                    UserAndDepartmentCache.syncWXPortrait(  headimgurl , userid);
                }
                else
                {
                    //本系统中没有手机号相同的用户， 可能需要自动注册，
                    JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);

                    if (!cfg.getBoolean("wx_autoregist", false))
                        throw new Exception("系统已禁止自动注册用户，请联系管理员为您注册。");

                    //
                    String roles = FF.encryptString(cfg.getString("wx_roles", ""), mobile);
                    String corporationid = cfg.getString("wx_corporationid", "");


                    FF.log("自动注册新用户" + mobile);
                    JSONObject regUserInfo = new JSONObject();

                    regUserInfo.put("name", mobile); //自动
                    regUserInfo.put("code", openID);
                    regUserInfo.put("showname", showname);
                    regUserInfo.put("email", email);
                    regUserInfo.put("password", DataStoreFactory.newGUID());
                    regUserInfo.put("mobile", mobile);
                    regUserInfo.put("freezed", 0);
                    regUserInfo.put("roles", roles);  //加密后的角色信息，注册时同时授与
                    regUserInfo.put("wxopenid", openID);  //注册时一并保存
                    regUserInfo.put("corporationid", corporationid); //
                    regUserInfo.put("backMode", true); //不做权限校验，强行注册

                    //注册新用户，会自动把基本角色授与新用户，并刷新cache
                    JSONObject reg = RPCRouter.dispatch("sso", "sso.Register", "register", regUserInfo, request, response, false);

                    if (!reg.getBoolean("success", true))
                    {
                        throw new Exception("注册用户失败：" + reg.getString("message", ""));
                    }

                    userid = reg.getInt("userid", -1);

                    ds.retrieve(" id= " + userid); //再检索出来

                    //同步头像
                    UserAndDepartmentCache.syncWXPortrait(  headimgurl , userid);
                    //用户信息缓存会在上面创建用户时，就缓存


                }
                // 到这里，用户信息肯定是存在了
                //  创建用户映射关系

                dsMap.insertRow(0);
                dsMap.setValue(0, "id", DataStoreFactory.newGUID());
                dsMap.setValue(0, "userid", userid);
                dsMap.setValue(0, "type", "wx");
                dsMap.setValue(0, "platform", platform); //重要
                dsMap.setValue(0, "openid", openID);
                dsMap.setValue(0, "nickname", showname);
                dsMap.setValue(0, "mobile", mobile);
                dsMap.setValue(0, "email", email);
                dsMap.setValue(0, "headimgurl", headimgurl);

                dsMap.update(true);

            }


            if (ds.getRowCount() > 0)
            {

                int id = ds.getInt(0, "id");

                String name = ds.getString(0, "name");
                String pwd = ds.getString(0, "password");

                int freezed = ds.getInt(0, "freezed");
                if (freezed == 1) throw new Exception("用户未开放，请联系管理员");

                ds.setValue(0, "wxopenid", openID);
                if (!mobile.isEmpty()) ds.setValue(0, "mobile", mobile);

                if (ds.isSaveNeeded())
                {
                    ds.update(true);
                    //刷新用户详情的缓存信息
                    UserAndDepartmentCache.rebuildOneUserDetailInfoCache(id);
                }
                //放到Session中

                ds.setUpdatable(false); //防止下面修改数据后误保存
                ds.setValue(0, "password", null); //注意把密码清除掉， 其实放着也没事，是MD5后的数据，无法逆向出密码
                ds.setValue(0, "salt", null);
                JSONObject userInfo = ds.getJSON(0, false);
                userInfo.put("userInfoType", "local");

                ret = login.login(userInfo, request, response, backToServer, backToURL);


            }
            else
            {
                throw new Exception("系统已禁止自动注册用户，请联系管理员为您注册。");
            }


            //
        } catch (Exception er)
        {
            ret.put("success", true);
            ret.put("needReg", true); //需要关联用户 ,表示需要重新输入手机及验证码
            ret.put("message", er.getMessage());
            ret.put("messageClass", "is-warning");
            ret.put("mobile", mobile);
            ret.put("nickname", nickname);
            ret.put("headimgurl", headimgurl);
            //数据加密后返回备用
            JSONObject info = new JSONObject();
            info.put("backToServer", backToServer);
            info.put("backToURL", backToURL);
            info.put("nickname", nickname);
            info.put("headimgurl", headimgurl);
            info.put("openid", openID);
            //数据加密后返回备用
            ret.put("info", FF.encryptString(info.toString()));

        }

        return ret;

    }

    @Override
    public JSONObject login(JSONObject param, HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        return null;
    }

    @Override
    public String sendMessage(int userid, String info, String platformCode)
    {
        String openID = UserAndDepartmentCache.getUserOpenIdInPlatform(platformCode, "wx", userid);
        if (openID.isEmpty())
            return "用户 “" + userid + "”尚未登录过" + platformCode + "尚未建立openID与用户的对应关系";

        try
        {
            String access_token = getAccessToken();
            String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + access_token;

            JSONObject data = new JSONObject();
            data.put("touser", openID);

            data.put("Content", info);
            data.put("msgtype", "text");
            JSONObject text = new JSONObject();

            text.put("content", info);
            data.put("text", text);

            JSONObject ret = new JSONObject(FF.postStringToURL(url, data.toString(), "UTF-8", false));

            return ret.getString("errmsg", "");

        } catch (Exception e)
        {
            return FF.exceptionMessage(e);
        }


    }


}
