package platform;


import app.User;
import config.CacheConfig;

import gdi.ImageWaterMark;
import jun.db.impl.DataStoreFactory;
import jun.db.util.Base32Coder;
import org.json.JSONArray;
import org.json.JSONObject;
import pdf.PdfUtil;
import util.*;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.font.ImageGraphicAttribute;
import java.io.*;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

@WebServlet(name = "QYWXProxy", urlPatterns = "/QYWXProxy")
public class QYWXProxy extends HttpServlet
{

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        request.setCharacterEncoding("UTF-8"); //很重要

        /* 允许跨域的主机地址 */
        response.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Cache-Control", "no-cache");
        /* 重新预检验跨域的缓存时间 (s) */
        response.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, X-Requested-By, If-Modified-Since, X-File-Name, X-File-Type, Cache-Control, Origin");

        /* 是否携带cookie */
        response.setHeader("Access-Control-Allow-Credentials", "true");

        response.setHeader("XDomainRequestAllowed", "1");

        response.setContentType("text/html; charset=UTF-8");

        if (request.getMethod().equals("OPTIONS"))
        {
            response.setStatus(HttpServletResponse.SC_OK);
            return;
        }

        try
        {

            JSONObject param = BuildParamFromRequest.buildParam(request, response, true, false);
            FF.log("QYWXProxy代理 "+ param.toString());
            String action = param.getString("action", "");
            if (action.equalsIgnoreCase("getUserInfoWithCode")) successOutput(response, getUserInfoWithCode(param));
            if (action.equalsIgnoreCase("getUserInfoWithOpenID")) successOutput(response, getUserInfoWithOpenID(param));
            if (action.equalsIgnoreCase("getUserInfoWithUserTicket")) successOutput(response, getUserInfoWithUserTicket(param));
            if (action.equalsIgnoreCase("getAccessToken")) successOutput(response, getAccessToken(param));


        }catch(Exception e)
        {
            errorOutput(response, e.getMessage());
        }

    }

    public void out(HttpServletResponse response, JSONObject ret)
    {
        response.setContentType("text/html; charset=UTF-8");

    }

    public JSONObject getUserInfoWithCode(JSONObject param) throws Exception
    {
        String accessToken = param.getString("accessToken","");
         String code = param.getString("code","");

        String OAUTH_GETUSERINFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=%s&code=%s";
        //旧的地址                      "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=%s&code=%s";
        String url = String.format(OAUTH_GETUSERINFO_URL, accessToken, code);
        String ret = FF.getStringFromURL(url, "UTF-8");
        FF.log(ret);
        JSONObject j = new JSONObject(ret);
        if (j.getInt("errcode", 0) != 0) throw new Exception(j.getString("errmsg", ""));
        return j;
    }

    public JSONObject getUserInfoWithOpenID( JSONObject param)  throws Exception
    {

        String accessToken = param.getString("accessToken","");
        String openID = param.getString("openID","");
        String GET_USER_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=%s&userid=%s";
        String url = String.format(GET_USER_URL, accessToken, openID);
        String ret = FF.getStringFromURL(url, "UTF-8");
        FF.log(ret);
        JSONObject j = new JSONObject(ret);
        if (j.getInt("errcode", 0) != 0) throw new Exception(j.getString("errmsg", ""));

        return j;
    }

    public JSONObject getUserInfoWithUserTicket(JSONObject param) throws Exception
    {
        String accessToken = param.getString("accessToken","");
        String user_ticket = param.getString("user_ticket", "");
        String GET_USER_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=%s";
        String url = String.format(GET_USER_URL, accessToken );
        String ret = FF.postStringToURL(url, new JSONObject().put("user_ticket", user_ticket).toString(), "UTF-8", false);
        FF.log(ret);
        return new JSONObject(ret);
    }

    /**
     * 获取 access_token
     * @return
     */
    public JSONObject  getAccessToken(JSONObject param)  throws Exception
    {

        long now = System.currentTimeMillis();
        String corpid = param.getString("corpid","");
        String corpsecret = param.getString("corpsecret","");

        String ACCESS_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";


        String url = String.format(ACCESS_TOKEN_URL, corpid, corpsecret);
        // 根据url通过https请求获取accesstoken
        JSONObject ret = new JSONObject(FF.getStringFromURL(url, "UTF-8"));

        if (ret.getInt("errcode", 0) == 0)
        {
            return new JSONObject().put("access_token", ret.getString("access_token", ""))
                    .put( "expires_in" , now + (ret.getInt("expires_in", 7200) - 100) * 1000); // 失效时间


        }
        else
        {
            throw new Exception(" getAccessToken 失败：" + ret.getString("errmsg", ""));
        }
    }


    public void errorOutput(HttpServletResponse response, String ret) throws IOException
    {
        JSONObject jsonRet = new JSONObject();
        jsonRet.put("success", false);
        jsonRet.put("message", ret);
        output(response, jsonRet.toString());
    }

    public void successOutput(HttpServletResponse response, Object ret) throws IOException
    {
        JSONObject jsonRet = new JSONObject();
        jsonRet.put("success", true);
        jsonRet.put("data", ret);
        output(response, jsonRet.toString());
    }


    public void output(HttpServletResponse response, Object ret) throws IOException
    {

        FF.log("QYWXProxy 返回 " + ret.toString());
        response.setContentType("text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().write(ret.toString().getBytes("UTF-8"));
    }



}
