package platform;

import appCache.UserAndDepartmentCache;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;

import util.DBF;
import util.FF;
import util.RPCRouter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;

public class QYWX implements IPlatform
{

    public static ConcurrentHashMap<String, QYWX> qywxInsts = new ConcurrentHashMap();//平台对应的企业微信接入对象

    String platform = "";

    private volatile String g_access_token = "";  //不要直接访问
    private volatile long g_access_token_expire = 0;


    public volatile String agentid = "";
    public volatile String corpid = "";
    public volatile String corpsecret = "";

    public volatile boolean  useProxy=false;
    public volatile String proxyAddress="";

    public volatile  String  js_api="";
    public static void reset()
    {
        qywxInsts.clear();
    }

    private QYWX(String platform)
    {

        this.platform = platform;
        JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);
        if (cfg == null) return;
        agentid = cfg.getString("qywx_agentid", "");
        corpid = cfg.getString("qywx_corpid", "");
        corpsecret = cfg.getString("qywx_secret", "");
        useProxy = cfg.getBoolean("qywx_useproxy",false);
        proxyAddress= cfg.getString("qywx_proxyaddress","");
        js_api= cfg.getString("qywx_js_sdk_url","");

        if(! proxyAddress.endsWith("/")) proxyAddress+="/";
        proxyAddress+="QYWXProxy";

        if (corpsecret.startsWith("encryped:"))
        {
            corpsecret = corpsecret.substring(9);
            corpsecret = FF.decryptString(corpsecret);

        }
        g_access_token = "";
        g_access_token_expire = 0;
    }

    public static QYWX getInstance(String platform)
    {
        if (qywxInsts.containsKey(platform)) return qywxInsts.get(platform);
        QYWX ins = new QYWX(platform);
        qywxInsts.put(platform, ins);
        return ins;
    }

    public static QYWX getInstance()
    {
        if (qywxInsts.values().isEmpty()) return null;
        return qywxInsts.values().iterator().next();
    }

    public JSONObject proxy(String method, JSONObject param) throws Exception
    {
        String t=FF.postStringToURL(proxyAddress+"?action="+method, param.toString(), "UTF-8", false);
        return new JSONObject(t);
    }

    @Override
    public JSONObject getUserInfoWithCode(String code) throws Exception
    {
        if (useProxy)
        {
            String accessToken=  getAccessToken();
            JSONObject ret = proxy("getUserInfoWithCode" , new JSONObject().put("accessToken",accessToken).put("code",code) );
            if( ! ret.getBoolean("success",false)) throw new Exception(ret.getString("message",""));
            return ret.getJSONObject("data");
        }

        String OAUTH_GETUSERINFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=%s&code=%s";
        //旧的地址                      "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=%s&code=%s";
        String url = String.format(OAUTH_GETUSERINFO_URL, getAccessToken(), code);
        String ret = FF.getStringFromURL(url, "UTF-8");
        JSONObject j = new JSONObject(ret);
        if (j.getInt("errcode", 0) != 0) throw new Exception(j.getString("errmsg", ""));
        return j;
    }

    @Deprecated
    @Override
    /**
     * 本方法已经废弃，getUserInfoWithUserTicket
     */
    public JSONObject getUserInfoWithOpenID(String openID) throws Exception
    {
        if (useProxy)
        {
            String accessToken=  getAccessToken();
            JSONObject ret= proxy("getUserInfoWithOpenID" , new JSONObject().put("accessToken",accessToken).put("openID",openID) );
            if( ! ret.getBoolean("success",false)) throw new Exception(ret.getString("message",""));
            return ret.getJSONObject("data");
        }

        String GET_USER_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=%s&userid=%s";
        String url = String.format(GET_USER_URL, getAccessToken(), openID);
        String ret = FF.getStringFromURL(url, "UTF-8");
        JSONObject j = new JSONObject(ret);
        if (j.getInt("errcode", 0) != 0) throw new Exception(j.getString("errmsg", ""));
        return j;
    }

    @Override
    public JSONObject getUserInfoWithUserTicket(String user_ticket) throws Exception
    {
        if (useProxy)
        {
            String accessToken=  getAccessToken();
            JSONObject ret= proxy("getUserInfoWithUserTicket" , new JSONObject().put("accessToken",accessToken).put("user_ticket",user_ticket) );
            if( ! ret.getBoolean("success",false)) throw new Exception(ret.getString("message",""));
            return ret.getJSONObject("data");
        }


        String GET_USER_URL = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=%s";
        String url = String.format(GET_USER_URL, getAccessToken());
        String ret = FF.postStringToURL(url, new JSONObject().put("user_ticket", user_ticket).toString(), "UTF-8", false);
        return new JSONObject(ret);
    }

    @Override
    public String getAccessToken() throws Exception
    {
        long now = System.currentTimeMillis();
        if (now < g_access_token_expire && !g_access_token.isEmpty()) return g_access_token;

        if (useProxy)
        {

            JSONObject ret= proxy("getAccessToken" , new JSONObject().put("corpid",corpid).put("corpsecret",corpsecret) );
            if( ! ret.getBoolean("success",false)) throw new Exception(ret.getString("message",""));
            ret= ret.getJSONObject("data", new JSONObject());
            g_access_token = ret.getString("access_token","");
            g_access_token_expire = ret.getLong("expires_in", 0);
            return g_access_token;
        }


        String ACCESS_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";


        String url = String.format(ACCESS_TOKEN_URL, corpid, corpsecret);
        // 根据url通过https请求获取accesstoken
        JSONObject ret = new JSONObject(FF.getStringFromURL(url, "UTF-8"));

        if (ret.getInt("errcode", 0) == 0)
        {

            g_access_token = ret.getString("access_token", "");
            g_access_token_expire = now + (ret.getInt("expires_in", 7200) - 100) * 1000; // 失效时间
            return g_access_token;

        }
        else
        {
            throw new Exception(" getAccessToken 失败：" + ret.getString("errmsg", ""));
        }
    }


    @Override
    public JSONObject login(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        JSONObject ret = new JSONObject("{success:true}");

        /*
        *   细节： 当用户直接使用企业微信的扫一扫来扫网页的二维码登录，并且从来没有使用企业微信的工作台入口进入过系统，那么
        * 通过 code获取的用户信息中只有用户名，没有user_ticket，也就无法使用它来来获取用户敏感信息（手机号，等）
        *
        * */

        try
        {
            String con = "";//数据库
            String code = FF.getStringFromRequest(request, "code", "");
            String state = FF.getStringFromRequest(request, "state", "");
            FF.log("login_qywx:  code=" + code);
            //如果某个页面中有code参数，那么在登录时，此code也会传到登录页中，此时的code并不是微信回传的code
            //所以再加上 state ，两个参数一起判断
            //但是最好是url地址上不要有code参数名ß
            if (code.isEmpty() || !state.equals("state"))
            {
                String OAUTH_CODE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s" +
                        "&response_type=code&scope=snsapi_privateinfo&state=state&agentid=" + agentid + "#wechat_redirect";
                String callbackUrl = request.getRequestURL().toString() + "?" + request.getQueryString();
                FF.log(callbackUrl);
                callbackUrl = URLEncoder.encode(callbackUrl, "utf-8");

                if (this.corpid.isEmpty()) throw new Exception("请先设置相关参数，可能是入口地址中plateform参数没有设置");
                String weixinUrl = String.format(OAUTH_CODE_URL, corpid, callbackUrl);
                FF.log("跳到企业微信oauth2校验页");
                FF.log(weixinUrl);
                ret.put("backToURL", weixinUrl);
                return ret;
            }

            JSONObject wxUser = getUserInfoWithCode(code);
            FF.log(wxUser.toString());


            String qywxUserid = wxUser.getString("userid", "");

            String user_ticket = wxUser.getString("user_ticket", "");

            // 如果是网页中扫码登录，那么是没有 user_tickeet的，而在企业微信中工作台中登录，是可以拿到user_ticket的
            // 所以在可以先用 qywxUserid 来从用户映射表中先获取用户信息，如果能拿到mobile，那么就直接登录，否则，提示异常

            JSONObject wxUserInfo = getUserInfoWithUserTicket(user_ticket);
            FF.log(wxUserInfo.toString());
            String mobile = wxUserInfo.getString("mobile", "");
            FF.log("mobile  = " + mobile);

            DataStore dsMap = DataStoreFactory.newDataStore(con, "select * from app_user_map where  platform='" + platform +
                    "' and openid='" + qywxUserid + "'");

            DataStore ds = DataStoreFactory.newDataStore(con, " select * from app_user ");

            dsMap.setUpdateProperty("app_user_map", "id", "*", "id");
            dsMap.retrieve();
            if (dsMap.getRowCount() > 0)// 关联过用户
            {
                int userid = dsMap.getInt(0, "userid");  //找到映射的用户
                ds.retrieve(" id=" + userid);
                if (ds.getRowCount() == 0) // 用户不存在，那么删除映射关系
                {
                    dsMap.deleteRow(0);
                    dsMap.update(true);
                }
                //到这里   dsMap , ds 都应该有一条数据
            }
            else
            {//没有关联记录，那么直接用手机查，看看用户存不存在
                if(!mobile.isEmpty()) ds.retrieve("mobile='" + mobile + "'");
                //到这里 dsMap没有数据 ，  ds可能有，可能没有数据
            }

            if (dsMap.getRowCount() == 0)//没有关联过用户,或者上面无效关联，那么重新建立关联
            {

                String showname = qywxUserid;
                String email = wxUserInfo.getString("email", "");

                int userid = -9999;
                if (ds.getRowCount() > 0) //手机号已存在，表示用户信息已经存在，只需要建立关联关系就可以
                {
                    //这种情况就是 手机号在本系统中已存在，但没有建立关联关系，
                    userid = ds.getInt(0, "id");
                }
                else
                {
                    //本系统中没有手机号相同的用户， 可能需要自动注册，
                    JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);


                    if (!cfg.getBoolean("qywx_autoregist", false))
                        throw new Exception("请联系管理员为您注册用户，或将系统中的手机号设置成您的手机号以完成登录绑定。");

                    if( user_ticket.isEmpty()) throw new Exception ("请先在手机上打开企业微信，并在工作台上进入本系统后，再扫码登录");

                    if( mobile.isEmpty()) throw new Exception ("请先在企业微信中设置手机号，再扫码登录");

                    //
                    String roles = FF.encryptString(cfg.getString("qywx_roles", ""), mobile);
                    String corporationid = cfg.getString("qywx_corporationid", "");

                    FF.log("自动注册新用户" + mobile);
                    JSONObject regUserInfo = new JSONObject();

                    regUserInfo.put("name", mobile); //不能用qywxUserid，因为它是可能会与其它人注册的名字重复
                    regUserInfo.put("code", qywxUserid);
                    regUserInfo.put("showname", showname);
                    regUserInfo.put("email", email);
                    regUserInfo.put("password", DataStoreFactory.newGUID());
                    regUserInfo.put("mobile", mobile);
                    regUserInfo.put("freezed", 0);
                    regUserInfo.put("roles", roles);  //加密后的角色信息，注册时同时授与
                    regUserInfo.put("corporationid", corporationid); //

                    regUserInfo.put("backMode", true); //不做权限校验，强行注册



                    //注册新用户，会自动把基本角色授与新用户，并刷新cache
                    JSONObject reg = RPCRouter.dispatch("sso", "sso.Register", "register", regUserInfo, request, response, false);

                    if (!reg.getBoolean("success", true))
                    {
                        throw new Exception("注册用户失败：" + reg.getString("message", ""));
                    }

                    userid = reg.getInt("userid", -1);

                    ds.retrieve(" id= " + userid); //再检索出来

                    //同步头像
                    UserAndDepartmentCache.syncWXPortrait(wxUserInfo.getString("avatar", ""), userid);
                    //用户信息缓存会在上面创建用户时，就缓存


                }
                // 到这里，用户信息肯定是存在了
                //  创建用户映射关系

                dsMap.insertRow(0);
                dsMap.setValue(0, "id", DataStoreFactory.newGUID());
                dsMap.setValue(0, "userid", userid);
                dsMap.setValue(0, "type", "qywx");
                dsMap.setValue(0, "platform", platform); //重要
                dsMap.setValue(0, "openid", qywxUserid);
                dsMap.setValue(0, "nickname", showname);
                dsMap.setValue(0, "mobile", mobile);
                dsMap.setValue(0, "email", email);
                dsMap.setValue(0, "headimgurl", wxUserInfo.getString("avatar", ""));

                dsMap.update(true);

            }


            if (ds.getRowCount() > 0)
            {

                int id = ds.getInt(0, "id");

                String name = ds.getString(0, "name");
                String pwd = ds.getString(0, "password");

                String backToServer = FF.getStringFromRequest(request, "backToServer", "");
                String backToURL = FF.getStringFromRequest(request, "backToURL", "");

                int freezed = ds.getInt(0, "freezed");
                if (freezed == 1) throw new Exception("用户已被冻结，请联系管理员");

                //放到Session中

                ds.setUpdatable(false); //防止下面修改数据后误保存
                ds.setValue(0, "password", null); //注意把密码清除掉， 其实放着也没事，是MD5后的数据，无法逆向出密码
                ds.setValue(0, "salt", null);
                JSONObject userInfo = ds.getJSON(0, false);
                userInfo.put("userInfoType", "local");

                //委托给真正的登录对象去登录
                ret = login.login(userInfo, request, response, backToServer, backToURL);

            }

        } catch (Exception e)
        {
            FF.log("企业微信登录异常: " + e.getMessage());
            ret.put("success", false);
            ret.put("message", e.getMessage());

        }

        return ret;
    }

    @Override
    public JSONObject login(JSONObject param, HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        return null;
    }

    @Override
    public String sendMessage(int userid, String info, String platformCode)
    {
        String openID = UserAndDepartmentCache.getUserOpenIdInPlatform(platformCode, "qywx", userid);
        if (openID.isEmpty())
            return "用户 “" + userid + "”尚未登录过" + platformCode + "尚未建立openID与用户的对应关系";


        String qywxid = openID;
        try
        {

            String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + getAccessToken();
            JSONObject msgBody = new JSONObject();

            /*touser	否	指定接收消息的成员，成员ID列表（多个接收者用‘|’分隔，最多支持1000个）。
            特殊情况：指定为”@all”，则向该企业应用的全部成员发送
            toparty	否	指定接收消息的部门，部门ID列表，多个接收者用‘|’分隔，最多支持100个。
            当touser为”@all”时忽略本参数
            totag	否	指定接收消息的标签，标签ID列表，多个接收者用‘|’分隔，最多支持100个。
            当touser为”@all”时忽略本参数
            msgtype	是	消息类型，此时固定为：text
            agentid	是	企业应用的id，整型。企业内部开发，可在应用的设置页面查看；第三方服务商，可通过接口 获取企业授权信息 获取该参数值
            content	是	消息内容，最长不超过2048个字节，超过将截断（支持id转译）
            safe	否	表示是否是保密消息，0表示可对外分享，1表示不能分享且内容显示水印，默认为0
            enable_id_trans	否	表示是否开启id转译，0表示否，1表示是，默认0。仅第三方应用需要用到，企业自建应用可以忽略。
            enable_duplicate_check	否	表示是否开启重复消息检查，0表示否，1表示是，默认0
            duplicate_check_interval	否	表示是否重复消息检查的时间间隔，默认1800s，最大不超过4小时
            * */

            msgBody.put("touser", qywxid)
                    .put("msgtype", "text")
                    .put("agentid", FF.String2Int(agentid))
                    .put("text", new JSONObject().put("content", info));

            JSONObject ret = (JSONObject) FF.$httpPost(url, (new JSONObject().put("body", msgBody)).toString(), false);

            ret = new JSONObject(ret.getString("response", ""));
            if (ret.getInt("errcode", 0) == 0) return "";


            return ret.getString("errmsg", "");

        } catch (Exception e)
        {
            return FF.exceptionMessage(e);
        }


    }


}
