package platform;

import app.User;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import util.AppCache;
import util.DBF;
import util.FF;
import util.RPCBase;
import webApp.App;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Connection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 移动平台的接入处理
 * <p>
 * 本类虽然放到公共 包中，但是仅仅在  sso ， script 两个服务中使用。因为 在 *
 */
public class PlatformConfig extends RPCBase
{

    @Override
    public boolean mustLogin(String method, JSONObject param)
    {
        return false;
    }

    public static ConcurrentHashMap<String, JSONObject> platformDefine = new ConcurrentHashMap<>();
    public static ConcurrentHashMap<String, DDStreamThread> ddStreamPool = new ConcurrentHashMap<>();

    public static synchronized void init()
    {
        FF.log(App.appName + " 加载应用平台定义到本地缓存");

        String info = "";
        try
        {
            platformDefine.clear();
            String con = "";
            DataStore ds = DataStoreFactory.newDataStore(con, "select * from  v_app_platform");
            int n = ds.retrieve();
            for (int i = 0; i < n; i++)
            {
                JSONObject one = ds.getJSON(i, true, false, false, true);
                platformDefine.put(ds.getString(i, "code"), one);  //代码对应的配置缓存起来
                //平台与移动工作台的绑定放到中央缓存中，在app服务中直接用
                AppCache.setCache(AppCache.CS_PREFIX_PLATFORM2WORKSPACE + ds.getString(i, "code"), ds.getString(i, "workspace"));


                //2025.-3.05在脚本服务中，启动钉钉的消息推送，注意，这里存在一个问题，如果启动多个script服务，则这个会重复启动
                if (App.appName.equalsIgnoreCase("script"))
                {

                    startDDStream(one);

                }
            }

            WX.reset();
            DD.reset();
            QYWX.reset();

        } catch (Exception e)
        {
            FF.log("script服务初始化时出现异常：");
            FF.log(FF.exceptionMessage(e));
        } finally
        {


        }

    }

    public static void destroy()
    {
        Iterator<DDStreamThread> it = ddStreamPool.values().iterator();
        while (it.hasNext())
        {
            DDStreamThread t = it.next();
            t.cancel();
        }
        ddStreamPool.clear();
    }

    public static void startDDStream(JSONObject cfg)
    {
        boolean enabled = (cfg.getBoolean("dd_stream_enabled", false));
        String code = cfg.getString("code", "");
        DDStreamThread t = ddStreamPool.get(code);
        if (t != null)
        {
            t.cancel();
            ddStreamPool.remove(code);
        }


        if (enabled)
        {
            t = new DDStreamThread(code, cfg.getString("dd_appkey", ""),
                                   cfg.getString("dd_secret", ""),
                                   cfg.getString("dd_scriptid", ""));
            ddStreamPool.put(code, t);

            FF.log("移动平台:" + code + "开始接收DingDing推送消息");
            t.start();
        }

    }

    public static String sendMessage(int userid, String info, String platformCode)
    {
        JSONObject cfg = getConfigForPlatform(platformCode);
        String ret = "";
        if (cfg.getBoolean("qywx_enabled", false))
        {
            ret += QYWX.getInstance(platformCode).sendMessage(userid, info, platformCode);
        }

        if (cfg.getBoolean("wx_enabled", false))
        {
            ret += WX.getInstance(platformCode).sendMessage(userid, info, platformCode);
        }
        if (cfg.getBoolean("dd_enabled", false))
        {
            ret += DD.getInstance(platformCode).sendMessage(userid, info, platformCode);
        }
        return ret;
    }


    public static JSONObject getConfigForPlatform(String platformCode)
    {
        if (platformDefine.containsKey(platformCode)) return platformDefine.get(platformCode);
        FF.log(platformCode + " 不存在");
        return null;
    }

    //企业微信中进入本系统
    public static JSONObject qywx_login(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        String platformCode = FF.getStringFromRequest(request, "platform", "default");
        return QYWX.getInstance(platformCode).login(request, response, login);
    }

    //微信中进入本系统
    public static JSONObject wx_login(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        String platformCode = FF.getStringFromRequest(request, "platform", "default");
        return WX.getInstance(platformCode).login(request, response, login);
    }


    //当app_platform修改后，重新缓存配置信息
    //参看 config服务中的TreeManage中的处理
    public JSONObject reset(JSONObject param)
    {
        JSONObject ret = new JSONObject("{success:true}");


        synchronized (PlatformConfig.class)
        {
            PlatformConfig.init();
            QYWX.reset();
        }
        return ret;
    }

}
