package platform;

import org.json.JSONObject;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface IPlatform
{
    /**
     * 通过回调地址中的code参数获取用户openID等
     * @param code
     * @return
     */
    public JSONObject getUserInfoWithCode(String code)  throws Exception;

    /**
     * 通过 openID获取用户信息
     * @param openID
     * @return
     */
    public JSONObject getUserInfoWithOpenID( String openID)  throws Exception ;

    /**
     * 通过 user_ticket 获取用户信息
     * @param user_ticket
     * @return
     */
    public JSONObject getUserInfoWithUserTicket(String user_ticket) throws Exception;

    /**
     * 获取 access_token
     * @return
     */
    public String  getAccessToken()  throws Exception ;


    /**
     * 登录
     * @param request
     * @param response
     * @return
     */
    public JSONObject login(HttpServletRequest request , HttpServletResponse response , IPlatformLogin login);

    /**
     * 直接带上 code 登录
     * @param request
     * @param response
     * @return
     */
    public JSONObject login(JSONObject param, HttpServletRequest request , HttpServletResponse response , IPlatformLogin login);


    /**
     * 给系统中的用户发送信息
     * @param userid
     * @param info
     * @return
     */
    public String sendMessage( int userid, String info,String platformCode);

}
