package platform;

import com.dingtalk.open.app.api.GenericEventListener;
import com.dingtalk.open.app.api.OpenDingTalkClient;
import com.dingtalk.open.app.api.OpenDingTalkStreamClientBuilder;
import com.dingtalk.open.app.api.message.GenericOpenDingTalkEvent;
import com.dingtalk.open.app.api.security.AuthClientCredential;
import com.dingtalk.open.app.stream.protocol.event.EventAckStatus;
import jun.db.core.ObjectTool;
import jun.db.core.ObjectType;
import shade.com.alibaba.fastjson2.JSONObject;
import util.FF;

public class DDStreamThread extends Thread
{
    String code;
    String appid;
    String appsecret;
    String scriptCode;
    public volatile boolean exit = false;

    public DDStreamThread(String code,String appid, String appsecret, String scriptCode)
    {
        resetParam(code,appid, appsecret, scriptCode);
    }

    public void resetParam(String code,String appid, String appsecret, String scriptCode)
    {
        if (appsecret.startsWith("encryped:"))
        {
            appsecret = appsecret.substring(9);
            appsecret = FF.decryptString(appsecret);

        }

        this.code=code;
        this.appid = appid;
        this.appsecret = appsecret;
        this.scriptCode = scriptCode;
        exit = false;
        this.setName(  "移动平台[" +code +    "]接收钉钉推送");
    }

    public void cancel()
    {
        exit = true;
        FF.delay(2000);
    }

    public void run()
    {
        exit = false;
        OpenDingTalkClient client = OpenDingTalkStreamClientBuilder
                .custom()
                .credential(new AuthClientCredential(appid, appsecret ))
                //注册事件监听
                .registerAllEventListener(new GenericEventListener()
                {
                    @Override
                    public EventAckStatus onEvent(GenericOpenDingTalkEvent event)
                    {
                        try
                        {
                            //事件唯一Id
                            String eventId = event.getEventId();
                            //事件类型
                            String eventType = event.getEventType();
                            //事件产生时间
                            Long bornTime = event.getEventBornTime();
                            //获取事件体
                            JSONObject bizData = event.getData();

                            org.json.JSONObject param= new org.json.JSONObject();
                            param.put("eventId", eventId);
                            param.put("eventType", eventType);
                            param.put("bornTime", bornTime);
                            param.put("data", bizData);

                            FF.log("钉钉Stream接收事件:" + param.toString());
                            Object v = FF.runScript(scriptCode,  param );
                            if (v == null) return EventAckStatus.LATER;

                            boolean ok = (Boolean) ObjectTool.ChangeType(v, ObjectTool.java_lang_Boolean);
                            return ok ? EventAckStatus.SUCCESS:EventAckStatus.LATER;

                        } catch (Exception e)
                        {
                            //消费失败
                            return EventAckStatus.LATER;
                        }
                    }
                })
                .build();
        try
        {
            client.start();
            while (!exit)
            {
                FF.sleep(1000);
            }
            client.stop();
        } catch (Exception e)
        {
            FF.log("钉钉Stream接收启动失败" + FF.exceptionMessage(e));
        }

        exit = true;
    }
}
