package platform;

import appCache.UserAndDepartmentCache;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.request.OapiUserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserGetuserinfoResponse;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import util.DBF;
import util.FF;
import util.RPCBase;
import util.RPCRouter;
import webApp.App;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;

public class DD implements IPlatform
{


    public static ConcurrentHashMap<String, DD> ddInsts = new ConcurrentHashMap();//平台对应的企业微信接入对象

    String platform = "";

    private volatile String g_access_token = "";  //不要直接访问
    private volatile long g_access_token_born_date = 0;


    public volatile String agentid = "";
    public volatile String corpid = "";
    public volatile String appKey = "";
    public volatile String appSecret = "";


    public static void reset()
    {
        ddInsts.clear();
    }

    private DD(String platform)
    {

        this.platform = platform;
        JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);
        if (cfg == null) return;
        agentid = cfg.getString("dd_agentid", "");

        corpid = cfg.getString("dd_corpid", "");
        appKey = cfg.getString("dd_appkey", "");
        appSecret = cfg.getString("dd_secret", "");

        corpid = cfg.getString("dd_corpid", "");


        if (appSecret.startsWith("encryped:"))
        {
            appSecret = appSecret.substring(9);
            appSecret = FF.decryptString(appSecret);

        }
        g_access_token = "";
        g_access_token_born_date = 0;
    }


    public static DD getInstance(String platform)
    {
        if (ddInsts.containsKey(platform)) return ddInsts.get(platform);
        DD ins = new DD(platform);
        ddInsts.put(platform, ins);
        return ins;
    }

    @Override
    public JSONObject getUserInfoWithCode(String code) throws Exception
    {
        //https://open-dev.dingtalk.com/apiExplorer#/?devType=org&api=/user/getuserinfo
        DingTalkClient client = new DefaultDingTalkClient(getApiURL() + "user/getuserinfo");
        OapiUserGetuserinfoRequest req = new OapiUserGetuserinfoRequest();
        req.setCode(code);
        req.setHttpMethod("GET");
        OapiUserGetuserinfoResponse rsp = client.execute(req, getAccessToken());
        JSONObject js = new JSONObject(rsp.getBody());
        return js;
    }

    @Override
    public JSONObject getUserInfoWithOpenID(String openID) throws Exception
    {
        //可能用 https://open.dingtalk.com/document/app/dingtalk-retrieve-user-information  这个接口更好


        DingTalkClient client = new DefaultDingTalkClient(getApiURL() + "user/get");
        OapiUserGetRequest req = new OapiUserGetRequest();
        req.setUserid(openID);
        req.setHttpMethod("GET");
        OapiUserGetResponse rsp = client.execute(req, getAccessToken());
        return new JSONObject(rsp.getBody());
    }

    @Override
    public JSONObject getUserInfoWithUserTicket(String user_ticket) throws Exception
    {
        return null;
    }

    @Override
    public String getAccessToken() throws Exception
    {
        long now = System.currentTimeMillis();

        if (now - g_access_token_born_date < 7100 * 1000 && !g_access_token.isEmpty()) return g_access_token;


        DingTalkClient client = new DefaultDingTalkClient(getApiURL() + "gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        req.setAppkey(appKey);

        req.setAppsecret(appSecret);

        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = client.execute(req);
        String s = rsp.getBody();
        JSONObject js = new JSONObject(s);
        if (js.getInt("errcode", 0) == 0)
        {
            g_access_token = js.getString("access_token", "");
            g_access_token_born_date = System.currentTimeMillis();
            return g_access_token;
        }
        else
        {
            throw new Exception(js.getString("errmsg", ""));

        }
    }


    @Override
    public JSONObject login(JSONObject param ,  HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        JSONObject ret = new JSONObject("{success:true}");
        DBF dbf = DBF.getInstance();
        Connection con = null;

        try
        {

            String code= param.getString("ddCode","");



            JSONObject dd = getUserInfoWithCode(code);

            FF.log(dd.toString());

            if( dd.getInt("errcode",0)!=0) throw new Exception(dd.getString("errmsg",""));
            String ddUserid = dd.getString("userid", "");

            JSONObject ddUserInfo = getUserInfoWithOpenID(ddUserid);
            String mobile = ddUserInfo.getString("mobile", "");

            FF.log( "钉钉id："+ddUserid+   " 手机号："+ mobile);

            if( mobile.isEmpty())
            {
                throw new Exception("请在钉钉中开通“企业员工手机号信息”权限");
            }


            con = dbf.getConnection();
            DataStore ds = DataStoreFactory.newDataStore(con, " select * from app_user ");


            DataStore dsMap = DataStoreFactory.newDataStore(con, "select * from app_user_map where  platform='" + platform +  "' and openid='" + ddUserid + "'");


            dsMap.setUpdateProperty("app_user_map", "id", "*", "id");
            dsMap.retrieve();

            if (dsMap.getRowCount() > 0)// 关联过用户
            {
                int userid = dsMap.getInt(0, "userid");  //找到映射的用户
                FF.log("已经关联到用户："+userid);
                ds.retrieve(" id=" + userid);
                if (ds.getRowCount() == 0) // 用户不存在，那么删除映射关系
                {
                    dsMap.deleteRow(0);
                    dsMap.update(true);
                }
                //到这里   dsMap , ds 都应该有一条数据
            }
            else
            {//没有关联记录，那么直接用手机查，看看用户存不存在
                ds.retrieve("mobile='" + mobile + "'");
                FF.log("尚未关联用户，通过手机号检索用户信息：" + ds.getSelectLastRetrieved());
                FF.log("检索到用户信息条数：" + ds.getRowCount());
                //到这里 dsMap没有数据 ，  ds可能有，可能没有数据
            }

            if (dsMap.getRowCount() == 0)//没有关联过用户,或者上面无效关联，那么重新建立关联
            {

                FF.log("现在关联用户");
                String showname = ddUserInfo.getString("name", "");
                String email = ddUserInfo.getString("email", "");

                int userid = -9999;
                if (ds.getRowCount() > 0) //手机号已存在，表示用户信息已经存在，只需要建立关联关系就可以
                {
                    //这种情况就是 手机号在本系统中已存在，但没有建立关联关系，
                    userid = ds.getInt(0, "id");
                }
                else
                {
                   FF.log("创建新用户");
                    //本系统中没有手机号相同的用户， 可能需要自动注册，
                    JSONObject cfg = PlatformConfig.getConfigForPlatform(platform);

                    if ( !cfg.getBoolean("dd_autoregist", false))
                        throw new Exception("请联系管理员为您注册用户，或将系统中的手机号设置成您的手机号以完成登录绑定。");

                    //
                    String roles = FF.encryptString(cfg.getString("dd_roles", ""), mobile);
                    String corporationid = cfg.getString("dd_corporationid", "");

                    FF.log("自动注册新用户" + mobile);
                    JSONObject regUserInfo = new JSONObject();

                    regUserInfo.put("name", mobile); //不能用ddUserid，因为它是可能会与其它人注册的名字重复
                    regUserInfo.put("code", ddUserid);
                    regUserInfo.put("showname", showname);
                    regUserInfo.put("email", email);
                    regUserInfo.put("password", DataStoreFactory.newGUID());
                    regUserInfo.put("mobile", mobile);
                    regUserInfo.put("freezed", 0);
                    regUserInfo.put("roles", roles);  //加密后的角色信息，注册时同时授与
                    regUserInfo.put("corporationid", corporationid); //
                    regUserInfo.put("backMode", true); //不做权限校验，强行注册

                    //注册新用户，会自动把基本角色授与新用户，并刷新cache
                    JSONObject reg = RPCRouter.dispatch("sso", "sso.Register", "register", regUserInfo, request, response, false);

                    if (!reg.getBoolean("success", true))
                    {
                        throw new Exception("注册用户失败：" + reg.getString("message", ""));
                    }

                    userid = reg.getInt("userid", -1);

                    ds.retrieve(" id= " + userid); //再检索出来

                    //同步头像
                    UserAndDepartmentCache.syncWXPortrait(ddUserInfo.getString("avatar", ""), userid);
                    //用户信息缓存会在上面创建用户时，就缓存


                }
                // 到这里，用户信息肯定是存在了
                //  创建用户映射关系

                dsMap.insertRow(0);
                dsMap.setValue(0, "id", DataStoreFactory.newGUID());
                dsMap.setValue(0, "userid", userid);
                dsMap.setValue(0, "type", "dd");
                dsMap.setValue(0, "platform", platform); //重要
                dsMap.setValue(0, "openid", ddUserid);
                dsMap.setValue(0, "nickname", showname);
                dsMap.setValue(0, "mobile", mobile);
                dsMap.setValue(0, "email", email);
                dsMap.setValue(0, "headimgurl", ddUserInfo.getString("avatar", ""));

                dsMap.update(true);

                FF.log("他建用户关联：" + dsMap.getJSONRow(0,false) );

            }


            if (ds.getRowCount() > 0)
            {

                int id = ds.getInt(0, "id");

                String name = ds.getString(0, "name");
                String pwd = ds.getString(0, "password");

                String backToServer = param.getString("backToServer", "");
                String backToURL = param.getString("backToURL", "");

                int freezed = ds.getInt(0, "freezed");
                if (freezed == 1) throw new Exception("用户已被冻结，请联系管理员");

                //放到Session中

                ds.setUpdatable(false); //防止下面修改数据后误保存
                ds.setValue(0, "password", null); //注意把密码清除掉， 其实放着也没事，是MD5后的数据，无法逆向出密码
                ds.setValue(0, "salt", null);
                JSONObject userInfo = ds.getJSON(0, false);
                userInfo.put("userInfoType", "local");

                //委托给真正的登录对象去登录
                FF.log( "最终登录用户："+userInfo.toString());
                ret = login.login(userInfo, request, response, backToServer, backToURL);


            }

        } catch (Exception e)
        {
            FF.log(" dd login error: " + e.getMessage());
            ret.put("success", false);
            ret.put("message", e.getMessage());

        } finally
        {
            dbf.releaseConnection(con);

        }

        return ret;
    }

    @Override
    public JSONObject login(HttpServletRequest request, HttpServletResponse response, IPlatformLogin login)
    {
        return null;
    }

    @Override
    public String sendMessage(int userid, String info, String platformCode)
    {

        String openID = UserAndDepartmentCache.getUserOpenIdInPlatform(platformCode, "dd", userid);
        if (openID.isEmpty()) return "用户 “" + userid + "”尚未登录过" + platformCode + "尚未建立openID与用户的对应关系";

        try
        {

            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");

            OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
            String dingding_userid = openID;
            if (dingding_userid.isEmpty()) return userid + "没有绑定dingding";

            request.setUseridList(dingding_userid);


            request.setAgentId(FF.String2Long(agentid));
            request.setToAllUser(false);

            OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
            msg.setMsgtype("text");
            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
            msg.getText().setContent(info);
            request.setMsg(msg);

            String accessToken = getAccessToken();

            OapiMessageCorpconversationAsyncsendV2Response response = client.execute(request, accessToken);
            return response.getBody();
        } catch (Exception e)
        {
            return e.getMessage();
        }

    }


    public String getApiURL()
    {
        String apiURL = PlatformConfig.getConfigForPlatform(platform).getString("APIURL", "https://oapi.dingtalk.com/").trim();
        if (!apiURL.endsWith("/")) apiURL = apiURL + "/";
        return apiURL;
    }


}

