package nettyrpc.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import nettyrpc.common.CustomHeartbeatHandler;
import org.json.JSONObject;
import util.FF;
import util.RPCBase;
import webApp.App;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;


public class ServerHandler extends CustomHeartbeatHandler {

    private static ConcurrentHashMap<String, Method> classMethodMap = new ConcurrentHashMap<String, Method>();
    private final static String flatReturn = "jun_only_return_flat_string";

    private final String CONTENT_TYPE = "text/html;charset=UTF-8";


    public ServerHandler() {
        super("server");
    }

    @Override
    protected void handleData(ChannelHandlerContext channelHandlerContext, ByteBuf buf) {
        byte[] data = new byte[buf.readableBytes() - 5-8];

        buf.skipBytes(5);
        long no=buf.readLong();
        buf.readBytes(data);
        try
        {
            String content = new String(data, "UTF-8");

            String ret= RPC(content).toString();
            byte[] bs= ret.getBytes("UTF-8");

            ByteBuf responseBuf = channelHandlerContext.alloc().buffer(5 + 8+bs.length);
            responseBuf.writeInt(5 + 8 + bs.length);
            responseBuf.writeByte(CustomHeartbeatHandler.CUSTOM_MSG);
            responseBuf.writeLong(no);
            responseBuf.writeBytes(bs  );
            channelHandlerContext.writeAndFlush(responseBuf);
        }catch(Exception e)
        {

        }

    }

    @Override
    protected void handleReaderIdle(ChannelHandlerContext ctx) {
        super.handleReaderIdle(ctx);
        FF.log(App.appName+" client " + ctx.channel().remoteAddress().toString() + " reader timeout, close it---");
        ctx.close();
    }


    private static JSONObject RPC( String content)
    {

        long d1= System.currentTimeMillis();
        JSONObject ret = null;
        Object rpc = null;
        try
        {

            JSONObject p= new JSONObject(content);

            String className= p.getString("className","");
            String methodName=p.getString("methodName","");
            JSONObject param = p.getJSONObject("param",null);

            //创建对象实例
            rpc = Class.forName(className).newInstance();
            ((RPCBase) rpc).init(null, null);

            String methodFullName = className + "." + methodName;

            String err = ((RPCBase) rpc).rightVerify(methodFullName, param);
            if (!err.isEmpty()) throw new Exception(err);

            Method m = classMethodMap.get(methodFullName);
            if (m == null)
            {
                Class c = rpc.getClass();
                m = c.getMethod(methodName, new Class[]{JSONObject.class});
                classMethodMap.put(methodFullName, m);
            }

            ret = (JSONObject) m.invoke(rpc, new Object[]{param});
            if (ret == null)
            {
                ret = new JSONObject().put("success", true).put("message", "");
            }
            RpcCallLog(   className, methodName, param, "");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
            ret = new JSONObject().put("success", false).put("message", e.getClass().getName()+":"+e.getMessage());

        } finally
        {

            long d2=System.currentTimeMillis();
             ret.put("rpcCallCost", d2-d1);

        }

        return ret;
    }

    static void RpcCallLog(  String classname, String funcname, JSONObject param, Object sessionID) throws Exception
    {

        return;
        /*
        HashMap log= new HashMap();
		log.put( "address", request.getRemoteAddr());
		log.put( "classname", classname + "." + funcname);
		log.put("parameter", (param.length() > 200 ? param.substring(0, 200) : param));
		log.put( "calldate", new Date());
		log.put( "username", sessionID);

		RemoteScriptingLog.newLog(log);

		*/

    }


}