package nettyrpc.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import nettyrpc.client.Client;


public class Server
{

    int port;
    Channel ch;
    int threadCount;

    NioEventLoopGroup bossGroup;
    NioEventLoopGroup workGroup;

    public Server(int port, int threadCount)
    {
        this.port = port;
        this.threadCount = threadCount;
    }


    public static void main(String[] args)
    {
        Server server = new Server(7777, 10);
        server.start();
        try
        {
            server.ch.closeFuture().sync();
        } catch (Exception e)
        {

        }
    }

    public void start()
    {
        bossGroup = new NioEventLoopGroup(1);
        workGroup = new NioEventLoopGroup(threadCount);
        try
        {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap
                    .group(bossGroup, workGroup)
                    .channel(NioServerSocketChannel.class)
                    .childHandler(new ChannelInitializer<SocketChannel>()
                    {
                        protected void initChannel(SocketChannel socketChannel) throws Exception
                        {
                            ChannelPipeline p = socketChannel.pipeline();
                            //为什么要IDLE*2，反正就是要把客户连接的IDLE 大，不然就就会自动断开客户的连接
                            p.addLast(new IdleStateHandler(Client.IDLE * 2, 0, 0));
                            p.addLast(new LengthFieldBasedFrameDecoder(2 * 1024 * 1024, 0, 4, -4, 0));
                            p.addLast(new ServerHandler());
                        }
                    });

            ch = bootstrap.bind(port).sync().channel();


        } catch (Exception e)
        {
            throw new RuntimeException(e);
        } finally
        {

        }
    }

    public void stop()
    {

        ch.close();
        bossGroup.shutdownGracefully();
        workGroup.shutdownGracefully();
    }
}