package nettyrpc.manage;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import nettyrpc.client.Client;
import nettyrpc.server.Server;
import org.json.JSONObject;
import rpc.RPC;
import util.FF;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;


public class NettyRPC extends RPC
{

    private static ConcurrentHashMap<String, Client> rpcClientMap = new ConcurrentHashMap<String, Client>();
    private static ConcurrentHashMap<Integer, Server> rpcServerMap= new ConcurrentHashMap<Integer,Server>();

    private static String HomeURL = "";
    private static EurekaClient eurekaClient = null; //用来查询其它服务
    private static String virtualHostName = ""; // 所在应用提供的eureka服务的名称
    private static String hostIPAddress = ""; //所在应用的地址

    public static final String S_NETTY_RPC_PORT = "netty-rpc-port";

    public static void init(String homeURL, EurekaClient client, String vipName, String hostIP)
    {
        HomeURL = homeURL;
        eurekaClient = client;
        //当需要调用其它服务时，可能需要把自身的信息传递过去做权限控制
        virtualHostName = vipName;
        hostIPAddress = hostIP;

    }

    public static ArrayList<RPCServerInfo> getAllRPCServerInfoForService(String serviceName) throws Exception
    {
        ArrayList<RPCServerInfo> ret = new ArrayList<RPCServerInfo>();
        String vipAddress = serviceName; //需要调用的服务的名称

        List<InstanceInfo> serverInfoList = eurekaClient.getInstancesByVipAddress(vipAddress, false); //非加密方式

        for (InstanceInfo nextServerInfo : serverInfoList)
        {
            //检查服务的状态是不是有效的
            String ip = nextServerInfo.getIPAddr();
            int port = FF.String2Int(nextServerInfo.getMetadata().get(S_NETTY_RPC_PORT));
            ret.add(new RPCServerInfo(ip, port));
        }
        return ret;
    }

    /**
     * 得到一个可用的netth rpc 服务的地址
     *
     * @param serviceName
     * @return
     * @throws Exception
     */
    public static RPCServerInfo getRPCServerInfoForService(String serviceName) throws Exception
    {
        String vipAddress = serviceName; //需要调用的服务的名称

        InstanceInfo nextServerInfo = null;

        int tryCount = 0;
        while (true)
        {
            try
            {
                nextServerInfo = eurekaClient.getNextServerFromEureka(vipAddress, false); //非加密方式
            } catch (Exception e)
            {

            }

            tryCount++;
            if (tryCount > 800) break; //最多尝试40秒
            //可能在启动中，服务还不能得到，那就等一下
            if (nextServerInfo == null)
            {
                FF.sleep(50);
                continue;
            }


            String ip = nextServerInfo.getIPAddr();
            int port = FF.String2Int(nextServerInfo.getMetadata().get(S_NETTY_RPC_PORT));
            return new RPCServerInfo(ip, port);

        }

        return null;
    }


    public static void startServer(int port)
    {
        if( rpcServerMap.containsKey(port)) return ;
        int threadCount=10; //可以从配置中读取
        Server server= new Server( port , threadCount);
        rpcServerMap.put(port , server);
        server.start();

    }

    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param,
                                      HttpServletRequest req, HttpServletResponse res )
    {
        return dispatch( serviceName, className,methodName,param,req,res,false,60);
    }

    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param,
                                      HttpServletRequest req, HttpServletResponse res, boolean broadcast ,int timeoutSecond)
    {


        try
        {
            if (broadcast)
            {
                ArrayList<RPCServerInfo> serverList = getAllRPCServerInfoForService(serviceName);
                for (RPCServerInfo serverInfo : serverList)
                {
                    dispatchToService(serverInfo, className, methodName, param, req, res ,  timeoutSecond);
                }
                return null;
            }
            else
            {
                RPCServerInfo serverInfo = getRPCServerInfoForService(serviceName);
                if( serverInfo==null) return new JSONObject().put("success",false).put("message","无法定位"+serviceName+"服务所在地址" );
                return dispatchToService(serverInfo, className, methodName, param, req, res ,  timeoutSecond);
            }
        } catch (Exception e)
        {
            return null;
        }
    }


    private static JSONObject dispatchToService(RPCServerInfo serverInfo,
                                                String className, String methodName, JSONObject param,
                                                HttpServletRequest req, HttpServletResponse res,int timeoutSecond)
    {


        Client client = findRPCClient(serverInfo);
        if(client==null)
        {
            return new JSONObject().put("success",false).put("message","无法连接"+serverInfo.toString());
        }

        //整这么个特别的名称 ，是防止与调用的参数名冲突
        param.put("${rpcRouteRemoteAddr}$" , App.IPADDRESS);//调用者的IP地址放进来
        JSONObject j=new JSONObject();
        j.put("className", className);
        j.put("methodName",methodName);
        j.put("param",param);

        String ret=client.call( j.toString(),timeoutSecond);
        return new JSONObject(ret);
    }


    /**
     * 根据服务器地址和端口号，看看有没有连接上，如果连接上了，就返回连接上的Client对象
     * 如果没有，就创建一个连接 ，等它连接成功后，返回
     * @param serverInfo
     * @return
     */
    private static Client findRPCClient(RPCServerInfo serverInfo)
    {
        if (rpcClientMap.containsKey(serverInfo.toString())) return rpcClientMap.get(serverInfo.toString());

        int threadCount = 10; //可以从配置中取
        Client client = new Client(serverInfo, threadCount);
        if (client.start())
        {
            rpcClientMap.put(serverInfo.toString(), client);
            return client;
        }

        return null;


    }

    /**
     * 当连接断开时，移除连接
     * @param client
     */
    public static void removeClient(Client client)
    {
        rpcClientMap.remove(client.serverInfo.toString());
    }


    public static void shutdown()
    {
        Iterator<Client> it= rpcClientMap.values().iterator();
        while( it.hasNext())
        {
            Client client= it.next();
            client.close();
        }

        rpcClientMap.clear();

        Iterator<Server> it2=rpcServerMap.values().iterator();
        while( it2.hasNext())
        {
            Server server= it2.next();
            server.stop();
        }

        rpcServerMap.clear();
    }
}