package nettyrpc.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import nettyrpc.common.CustomHeartbeatHandler;
import nettyrpc.manage.NettyRPC;
import util.FF;
import webApp.App;


public class ClientHandler extends CustomHeartbeatHandler
{
    private Client client;

    public ClientHandler(Client client)
    {
        super("client");
        this.client = client;
    }

    /**
     * 数据包协议：    0-3 表示数据包的长度，包括头。 4：标记位，1：ping, 2:pong 3:msg ;  5-12: 数据包的唯一标记 , 12--结束 ：数据包的内容
     * 所以整个数据包的头是13位，
     * @param channelHandlerContext
     * @param byteBuf
     */
    @Override
    protected void handleData(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf)
    {
        byte[] data = new byte[byteBuf.readableBytes() - 5 - 8];
        byteBuf.skipBytes(5);
        long no = byteBuf.readLong(); //8字节的唯一标记
        byteBuf.readBytes(data);
        RPCContext ctx = client.no2ctx.get(no);

        if (ctx == null)
        {
            FF.log(App.appName+"  已经超时，序号为" + no + "的请求已经放弃等待");
        }
        else
        {
            client.no2ctx.remove(no);
            ctx.response = new String(data);
            ctx.semp.release();//释放许可证
        }
    }

    @Override
    protected void handleAllIdle(ChannelHandlerContext ctx)
    {
        super.handleAllIdle(ctx);
        sendPingMsg(ctx);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception
    {
        super.channelInactive(ctx);
        //client.doConnect();
        try
        {
            ctx.close();
        } catch (Exception e)
        {
        }

        FF.log(App.appName+"连接断开，从缓存的socket长连接中移除对" + client.serverInfo.toString() + "的连接 ");
        NettyRPC.removeClient(client);

    }
}