package mq_zbus;



import io.zbus.mq.MqClient;
import io.zbus.mq.Protocol;
import io.zbus.transport.ErrorHandler;
import io.zbus.transport.Message;
import util.FF;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class PushConsumer
{

    MqClient consumer;

     HashMap<String , MessageFilter> filterMap= new HashMap<String , MessageFilter>();

    String  consumerGroup ;
    String topic;

    public PushConsumer()
     {

     }

     public PushConsumer addFilter(String tag , MessageFilter filter)
     {
        filterMap.put(tag , filter);
        return this;
     }

    public  void  connect ( String  consumerGroup , String topic )
    {

        this.consumerGroup= consumerGroup;
        this.topic=topic;

        try
        {
            if (consumerGroup.isEmpty()) consumerGroup = "defaultGroup";

            String namesrvAddr ="";


            while( namesrvAddr.isEmpty())
            {
                FF.delay(10*1000);  //停10秒，等等zbus服务上线
                namesrvAddr = FF.getZBusNameServer();

            }

            FF.log("连接到： "+ namesrvAddr);

            consumer = new MqClient(namesrvAddr);
            consumer.heartbeat(30, TimeUnit.SECONDS);
            consumer.setReconnectDelay( 10000000); //设置重连时间长一点，方便下面在它重连之前强行中断，然后重新查询服务地址
            final String mq= topic; //关注的主题

            final String channel = consumerGroup; //频道 ， 等同于rocketMQ中的 client_id  ,相同channel 的客户端分享消息
            final String mqType = Protocol.MEMORY;

            consumer.addMqHandler(mq, channel, data -> {

                String tag = data.getHeader("tag" ) ;
                //如果不是需要的标签，那么忽略
                MessageFilter filter = filterMap.get(tag);
                if (filter == null) return;
                filter.onMessage(data);

            });

            consumer.onOpen(() -> {
                Message req = new Message();

                req.setHeader("cmd", "create"); //create MQ/Channel
                req.setHeader("mq", mq);
                req.setHeader("mqType", mqType);
                req.setHeader("channel", channel);
                Message res = consumer.invoke(req);


                Message sub = new Message();
                sub.setHeader("cmd", "sub"); //Subscribe on MQ/Channel
                sub.setHeader("mq", mq);
                sub.setHeader("channel", channel);
                sub.setHeader("window", 1);
                //sub.setHeader("filter", "abc");

                consumer.invoke(sub );
            });

            consumer.onError(new ErrorHandler()
            {
                @Override
                public void handle(Throwable throwable)
                {
                    FF.log("消费者断开");
                }

            });

            PushConsumer that=this;
            consumer.onError(new ErrorHandler()
            {
                @Override
                public void handle(Throwable throwable)
                {
                    FF.log(that.consumerGroup +"/" +that.topic+"/  消费者异常："+ FF.exceptionMessage( throwable));


                    shutDown();

                    FF.log( "重新连接");
                    reConnect();
                }
            });

            consumer.connect();
            FF.log("消费者成功链接");

        }catch(Exception e)
        {
            FF.log("zbus消费者出现异常："+e.getMessage());

        }

    }

    public void  reConnect()
    {
        connect (   this.consumerGroup ,   this.topic );
    }

    public void shutDown()
    {
        try
        {
            if (consumer != null) consumer.close();
        }catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
    }
}
