package mq_zbus;

import io.zbus.mq.MqClient;
import io.zbus.mq.Protocol;
import io.zbus.transport.ErrorHandler;
import io.zbus.transport.EventHandler;
import io.zbus.transport.Message;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import util.FF;
import webApp.App;

import java.util.concurrent.TimeUnit;

public class MessageProducerFactory implements PooledObjectFactory<MqClient>
{


    private String producerGroupName;
    private int c = 0;


    public MessageProducerFactory(String producerGroupName)
    {

        this.producerGroupName = producerGroupName;

    }

    @Override
    public PooledObject<MqClient> makeObject()
    {
        try
        {

            c++;

            String id = "" + c + "_" + App.getInstance().getVirtualHostName() + "_" + App.IPADDRESS;
            id = id.replaceAll("[.]", "-");

            //   System.out.println( " zbus 消息发布者 "+ id+" 被创建");

            String nameSrvAddr = FF.getZBusNameServer();

            while( nameSrvAddr.isEmpty())
            {
                FF.delay(5000);
                nameSrvAddr = FF.getZBusNameServer();

            }


            FF.log("连接到zbus:    " + nameSrvAddr);
            MqClient producer = new MqClient(nameSrvAddr);

            DefaultPooledObject ret = new DefaultPooledObject(producer);
            producer.heartbeat(30, TimeUnit.SECONDS);

            producer.setReconnectDelay(1000000);

            producer.onClose(new EventHandler()
            {
                @Override
                public void handle() throws Exception
                {
                    FF.log("zbus消息生产者关闭");
                }
            });

            producer.onError(new ErrorHandler()
            {
                @Override
                public void handle(Throwable throwable)
                {
                    FF.log("消息生产者异常：" + FF.exceptionMessage(throwable));
                    try
                    {
                        FF.log("生产者关闭");
                        producer.close();


                    } catch (Exception e)
                    {
                        FF.log("生产者关闭异常：" + FF.exceptionMessage(e));
                    }finally
                    {
                        ret.invalidate();  //设置成非法，让它在取用时忽略
                    }
                }
            });

            String mqType = Protocol.MEMORY;

            //1) Create MQ if necessary
            Message req = new Message();
            req.setHeader("cmd", "create");  //Create
            req.setHeader("mq", this.producerGroupName);

            req.setHeader("mqType", mqType); //disk|memory|db

            producer.invoke(req);

            return ret;

        } catch (Exception e)
        {
            FF.log("mq  创建连接失败: " + e.getMessage());
        }
        return null;
    }


    @Override
    public void destroyObject(PooledObject<MqClient> pooledObject) throws Exception
    {
        FF.log("zbus 消息发布者 被销毁");

        MqClient obj = pooledObject.getObject();

        obj.close();
    }

    @Override
    public boolean validateObject(PooledObject<MqClient> pooledObject)
    {
        // System.out.println("zbus 检测消息发布者的合法性");

        return pooledObject.getState().compareTo(PooledObjectState.IDLE) == 0;
    }

    @Override
    public void activateObject(PooledObject<MqClient> pooledObject) throws Exception
    {
        //  System.out.println("zbus 休息的消息发布者被激活");
    }

    @Override
    public void passivateObject(PooledObject<MqClient> pooledObject) throws Exception
    {
        //  System.out.println(" zbus 消息发布者休息去了");
    }
}
