package http;

import okhttp3.*;
import util.FF;

import javax.net.ssl.*;
import java.io.File;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OkHttpConfig
{

    public static  OkHttpClient newOkHttpClient(int timeoutSeconds ) throws NoSuchAlgorithmException, KeyStoreException
    {


        // 详细配置可参考 https://www.freesion.com/article/3815946206/
        return new OkHttpClient.Builder()
                .connectTimeout(timeoutSeconds, TimeUnit.SECONDS)      //设置连接超时
                .readTimeout(timeoutSeconds, TimeUnit.SECONDS)         //设置读超时
                .writeTimeout(timeoutSeconds, TimeUnit.SECONDS)        //设置写超时
                .retryOnConnectionFailure(true)                     //是否自动重连

                // 设置https配置，此处忽略了所有证书
                .sslSocketFactory(sslSocketFactory(), new EasyX509TrustManager(null))
                // 验证服务器的证书域名。在https握手期间，如果 URL 的主机名和服务器的标识主机名不匹配，则验证机制可以回调此接口的实现程序来确定是否应该允许此连接
                .hostnameVerifier(new HostnameVerifier()
                {
                    @Override
                    public boolean verify(String hostname, SSLSession session)
                    {
                        return true;
                    }
                })
                // 拦截器日志记录
            //    .addInterceptor((Interceptor.Chain chain) -> {
            //        Request request = chain.request();
            //        FF.log("intercept 接口地址:" + request.url() +" "
            //                       + "\r\n接口参数）:" + request.body().toString());
            //        return chain.proceed(chain.request());
            //    })
                // 添加证书，一般不要设置
                //  .certificatePinner(new CertificatePinner.Builder()
                //                            .add("test1.com", "sha1/sdfsdsdsdsdsdsdsdsdsdsdds=")
                //                            .add("test2.com", "sha1/sdsdsdsdsdsdsdsdsdssdssds=")
                //                            .build())
                //.connectionSpecs(...) // 设置连接的规格、TLS版本和密码套件等，最好不要去设置
                //.socketFactory(new SocketFactory() {...}) // 使用定制的用于http请求的套接字
/*                .authenticator(new Authenticator() { // 添加授权证书
                    @Override
                    public Request authenticate(Route route, Response response) throws IOException {
                    }
                }) */
                .cache(new Cache(new File("cache.tmp"), 100 * 1024 * 1024)) // 100M缓存
                // 定义连接池，最多有五个空闲连接，每个空闲连接最多保持6分钟
                .connectionPool(new ConnectionPool(5, 5, TimeUnit.MINUTES))
                // 指定分发器，即异步执行http请求时的线程池，http响应的回调也是在此线程池的线程中执行
                // .dispatcher(new Dispatcher(new ThreadPoolExecutor( )))
                .followRedirects(true)       // 允许http重定向
                .followSslRedirects(false)   // 截断https的重定向
                .pingInterval(30, TimeUnit.SECONDS) // 设置ping检测网络连通性的间隔。默认为0
                //.proxy(...) // 设置单个代理
                //.proxyAuthenticator(...)  // 设置代理验证
                //.proxySelector(...) // 为不同的链接设置不同的代理
                .build();

    }


    public static  SSLSocketFactory sslSocketFactory()
    {
        try
        {
            //信任任何链接
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, new SecureRandom());
            return sslContext.getSocketFactory();
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        } catch (KeyManagementException e)
        {
            e.printStackTrace();
        } catch (KeyStoreException e)
        {
            e.printStackTrace();
        }
        return null;
    }
}
