/*
 * Created on 2004-5-29
 *
 *
 */

package gdi;


import org.json.JSONObject;
import util.FF;

import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import java.applet.Applet;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.*;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.List;
import java.util.*;

/**
 *
 */
public class Tools
{

    // 注意资源的名字也是大小写敏感的
    final static String IDC_WE = "WE.gif";
    final static String IDC_NS = "NS.gif";
    final static String IDC_ARROW = "DEFAULT";
    final static String IDC_SYS_WE = "SYS_WE";
    final static String IDC_SYS_NS = "SYS_NS";
    final static String IDC_MOVE = "MOVE.gif";
    final static String IDC_EXCHANGE = "EXCHANGE.gif";

    static HashMap m_FontMap = new HashMap();
    static HashMap m_StrokeMap = new HashMap();

    static HashMap/*<String, Cursor>*/m_CursorMap = new HashMap/*<String, Cursor>*/();
    static HashMap m_ImgMap = new HashMap();

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic,
                                  boolean FontUnderline, int hAlign, int vAlign)
    {
        DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, null);
    }


    public static void drawAsHTML(Graphics2D g, Rectangle rc, String s)
    {
        if (s.trim().isEmpty()) return;

        HTMLDocument document;
        JTextPane textPane = new JTextPane();
        HTMLEditorKit editorKit = new HTMLEditorKit()
        {

            //下面一段是解决一个Jre的Bug ，参看http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6993691
            protected Parser getParser()
            {
                try
                {
                    Class c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                    Parser defaultParser = (Parser) c.newInstance();
                    return defaultParser;
                } catch (Throwable e)
                {
                }
                return null;
            }
        };

        document = (HTMLDocument) editorKit.createDefaultDocument();
        textPane = new JTextPane(document);
        textPane.setContentType("text/html");
        textPane.setBounds(rc);
        textPane.setText(s);

        BufferedImage img = new BufferedImage(textPane.getWidth(), textPane.getHeight(), BufferedImage.TYPE_INT_RGB);
        Graphics tg = img.getGraphics();

        textPane.paint(tg);

        g.drawImage(img, null, rc.x, rc.y);

        //因为上面的操作后，有些单元格在画时，字体就模糊了。强制设置成不要有模糊
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);

        textPane = null;
        document = null;
        editorKit = null;
    }

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic,
                                  boolean FontUnderline, int hAlign, int vAlign, Color highLightColor)
    {
        g.setColor(bkcolor);
        if (bkMode != 0) g.fillRect(rc.x, rc.y, rc.width, rc.height);

        if (s.length() == 0) return;

        g.setColor(textcolor);

        Shape oc = g.getClip();
        try
        {
            Tools.clip(g, rc);

            Font font = GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(s, font, frc);
            float drawPosY = rc.y;
            switch (vAlign)
            {
                case ALIGNMENT.Bottom: // 底边
                    drawPosY += (rc.height - layout.getDescent() - layout.getLeading());
                    break;
                case ALIGNMENT.Center: // 居中
                    drawPosY += layout.getAscent() + (rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2;
                    break;
                default:
                    drawPosY += layout.getAscent();
                    break;
            }
            float drawPosX = rc.x;
            switch (hAlign)
            {
                case ALIGNMENT.Right: // 右对齐
                    drawPosX = rc.x + rc.width - layout.getAdvance();
                    break;
                case ALIGNMENT.Center: // 居中对齐
                    drawPosX = rc.x + (rc.width - layout.getAdvance()) / 2;
                    break;
                default:
                    drawPosX = rc.x;
                    break;
            }

            if (highLightColor != null)
            {
                g.setColor(highLightColor);
                layout.draw(g, drawPosX - 1, drawPosY - 1);
                layout.draw(g, drawPosX + 1, drawPosY - 1);
                layout.draw(g, drawPosX - 1, drawPosY + 1);
                layout.draw(g, drawPosX + 1, drawPosY + 1);

            }
            g.setColor(textcolor);
            layout.draw(g, drawPosX, drawPosY);
        } catch (Exception e)
        {
        } finally
        {
            // 恢复旧的裁减区域
            Tools.setClip(g, oc);
        }
    }

    public static void DrawCheckBoxOrRadioButtonString(Component pwnd, Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize,
                                                       boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean checkOn, boolean drawFocus, boolean isCheckBox)
    {

        int checkBoxSize = 18;
        float checkBoxX;
        float checkBoxY;

        g.setColor(bkcolor);
        if (bkMode != 0) g.fillRect(rc.x, rc.y, rc.width, rc.height);

        if (s.length() == 0) return;

        g.setColor(textcolor);
        Shape oc = g.getClip();
        try
        {
            Tools.clip(g, rc);

            Font font = GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(s, font, frc);
            float drawPosY = rc.y;
            switch (vAlign)
            {
                case ALIGNMENT.Bottom: // 底边
                    drawPosY += (rc.height - layout.getDescent() - layout.getLeading());
                    break;
                case ALIGNMENT.Center: // 居中
                    drawPosY += layout.getAscent() + (rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2;
                    break;
                default:
                    drawPosY += layout.getAscent();
                    break;
            }
            float drawPosX = rc.x;
            switch (hAlign)
            {
                case ALIGNMENT.Right: // 右对齐
                    drawPosX = rc.x + rc.width - layout.getAdvance();

                    drawPosX -= checkBoxSize;
                    checkBoxX = rc.x + rc.width - checkBoxSize;

                    break;
                case ALIGNMENT.Center: // 居中对齐
                    drawPosX = rc.x + (rc.width - layout.getAdvance()) / 2;

                    drawPosX += checkBoxSize / 2;
                    checkBoxX = drawPosX - checkBoxSize;

                    break;
                default:
                    drawPosX = rc.x;
                    drawPosX += checkBoxSize;
                    checkBoxX = rc.x;
                    break;
            }
            layout.draw(g, drawPosX, drawPosY);

            checkBoxY = drawPosY - 10;
            checkBoxX += 2;
            Image img = getBuffredImageFromURL(pwnd, "excel/edit/res/" + (isCheckBox ? "checkbox" : "radio") + "_" + (checkOn ? "on" : "off") + ".gif");
            g.drawImage(img, (int) checkBoxX, (int) checkBoxY, pwnd);

            //Tools.log("print radio or checkbox " + new java.util.Date());

            if (drawFocus)
            {
                Stroke oldStroke = g.getStroke();
                float dash[] =
                        {1};
                g.setStroke(Tools.getStroke(1, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10f, dash, 1.0f));
                g.setColor(new Color(217, 147, 0));
                g.drawRect(rc.x + 1, rc.y + 1, rc.width - 2, rc.height - 2);
                g.setStroke(oldStroke);
            }
        } catch (Exception e)
        {
        } finally
        {
            // 恢复旧的裁减区域
            Tools.setClip(g, oc);
        }
    }

    // 本函数即可以显示多行，也可以显示单行，但为了速度，单行使用另外一个优化后的函数
    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic,
                                  boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine)
    {
        if (s == null) return;
        if (s.trim().isEmpty()) return;
        if (rc.width <= 0 || rc.height <= 0) return;

        // 对单行进行优化， 即使去掉这两行，单行也能正确显示，只是速度稍慢。
        if (!MultiLine && s.indexOf("\n") < 0 && s.indexOf("\\n") < 0)
        {
            DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }

        // 如果是有回车的多行
        if (s.indexOf("\n") >= 0 || s.indexOf("\\n") >= 0)
        {
            DrawStringAcceptReturn(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }

        // 背景颜色
        g.setColor(bkcolor);
        if (bkMode != 0) g.fillRect(rc.x, rc.y, rc.width, rc.height);
        g.setColor(textcolor); // 文字颜色
        LineBreakMeasurer lineMeasurer;
        // The LineBreakMeasurer used to line-break the paragraph.
        int paragraphStart;
        // The index in the LineBreakMeasurer of the first character in the paragraph.
        int paragraphEnd;
        // The index in the LineBreakMeasurer of the first character after the end of the paragraph.
        Dimension size = rc.getSize();
        // 保存旧的剪裁区
        Shape oc = g.getClip();
        try
        {
            Tools.clip(g, rc);

            HashMap map = new HashMap();
            map.put(TextAttribute.FAMILY, FontName);
            map.put(TextAttribute.SIZE, new Float(FontSize));
            if (FontUnderline) map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            if (FontBold) map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            if (FontItalic) map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            AttributedString ss = new AttributedString(s, map);
            AttributedCharacterIterator text = ss.getIterator();
            // FontRenderContext frc =new FontRenderContext(g.getTransform(), false, false);
            FontRenderContext frc = g.getFontRenderContext();
            paragraphStart = text.getBeginIndex();
            paragraphEnd = text.getEndIndex();
            // Create a new LineBreakMeasurer from the paragraph.
            lineMeasurer = new LineBreakMeasurer(text, frc);
            // Set formatting width to width of Component.
            float formatWidth = (float) size.width;
            float drawPosY = rc.y;
            // 多行时，计算文本总高度
            if (MultiLine && vAlign != ALIGNMENT.Top)
            {
                double gg = 0;
                lineMeasurer.setPosition(paragraphStart);
                while (lineMeasurer.getPosition() < paragraphEnd)
                {
                    TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                    gg += layout.getDescent() + layout.getLeading() + layout.getAscent();
                }
                if (gg < rc.height)
                {
                    if (vAlign == ALIGNMENT.Center) drawPosY += (rc.height - gg) / 2;
                    if (vAlign == ALIGNMENT.Bottom) drawPosY += (rc.height - gg);
                }
            }
            // Get lines from lineMeasurer until the entire
            // paragraph has been displayed.
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd)
            {
                // Retrieve next layout.
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                // Move y-coordinate by the ascent of the layout.
                switch (vAlign)
                {
                    case ALIGNMENT.Bottom: // 底边
                        if (!MultiLine)
                        {
                            drawPosY += (rc.height - layout.getDescent() - layout.getLeading());
                            break;
                        }
                    case ALIGNMENT.Center: // 居中
                        if (!MultiLine)
                        {
                            drawPosY += layout.getAscent() + (rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2;
                            break;
                        }
                    default:
                        drawPosY += layout.getAscent();
                        break;
                }
                float drawPosX = rc.x;
                switch (hAlign)
                {
                    case ALIGNMENT.Right: // 右对齐
                        drawPosX = rc.x + formatWidth - layout.getAdvance();
                        break;
                    case ALIGNMENT.Center: // 居中对齐
                        drawPosX = rc.x + (formatWidth - layout.getAdvance()) / 2;
                        break;
                    default:
                        drawPosX = rc.x;
                        break;
                }
                layout.draw(g, drawPosX, drawPosY);
                // Move y-coordinate in preparation for next layout.
                drawPosY += layout.getDescent() + layout.getLeading();
                // 如果多行文本超出了显示区域，那么退出
                if (drawPosY >= rc.y + rc.height) break;
                if (!MultiLine) // 如果不是多行，那么退出
                    break;
            }
        } catch (Exception e)
        {
        } finally
        {
            // 恢复旧的裁减区域
            Tools.setClip(g, oc);
        }
    }

    // 多行文本显示
    public static void DrawStringAcceptReturn(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic,
                                              boolean FontUnderline, int hAlign, int vAlign)
    {
        if (s == null) return;
        if (s.trim().isEmpty()) return;
        if (rc.width <= 0 || rc.height <= 0) return;

        s = s.replaceAll("\\\\n", "\r\n");

        // 对单行进行优化， 即使去掉这两行，单行也能正确显示，只是速度稍慢。
        if (s.indexOf("\n") < 0)
        {
            DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, true);
            return;
        }

        // 背景颜色
        g.setColor(bkcolor);
        if (bkMode != 0) g.fillRect(rc.x, rc.y, rc.width, rc.height);
        g.setColor(textcolor); // 文字颜色

        // 保存旧的剪裁区
        Shape oc = g.getClip();
        try
        {
            Tools.clip(g, rc);
            // 设置新得剪裁区

            float textHeight = MultiLineTextHeight(g, rc.width, s, FontName, FontSize, FontBold, FontItalic, FontUnderline);

            HashMap map = new HashMap();
            map.put(TextAttribute.FAMILY, FontName);
            map.put(TextAttribute.SIZE, new Float(FontSize));
            if (FontUnderline) map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            if (FontBold) map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            if (FontItalic) map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            AttributedString ss = new AttributedString(s, map);

            AttributedCharacterIterator styledText = ss.getIterator();
            FontRenderContext frc = g.getFontRenderContext();

            float leftMargin = 0;

            ArrayList tabLocations = new ArrayList();

            int i = 0;
            for (char c = styledText.first(); c != AttributedCharacterIterator.DONE; c = styledText.next())
            {
                if (c == '\n')
                {
                    tabLocations.add(new Integer(styledText.getIndex()));
                }
            }
            tabLocations.add(new Integer(styledText.getEndIndex() - 1));
            int tabCount = tabLocations.size();
            // Now tabLocations has an entry for every tab's offset in
            // the text. For convenience, the last entry is tabLocations
            // is the offset of the last character in the text.

            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);

            int currentTab = 0;
            float verticalPos = 0;

            switch (vAlign)
            {
                case ALIGNMENT.Bottom: // 底边
                    verticalPos = rc.y + rc.height - textHeight;
                    break;
                case ALIGNMENT.Center: // 居中
                    verticalPos = rc.y + (rc.height - textHeight) / 2;
                    break;
                default:
                    verticalPos = rc.y;
                    break;
            }

            while (measurer.getPosition() < styledText.getEndIndex())
            {

                // Lay out and draw each line. All segments on a line
                // must be computed before any drawing can occur, since
                // we must know the largest ascent on the line.
                // TextLayouts are computed and stored in a Vector;
                // their horizontal positions are stored in a parallel
                // Vector.

                // lineContainsText is true after first segment is drawn
                boolean lineContainsText = false;

                float maxAscent = 0, maxDescent = 0;
                float horizontalPos = leftMargin;
                Vector layouts = new Vector(1);
                Vector penPositions = new Vector(1);

                float wrappingWidth = (float) rc.width;
                TextLayout layout = measurer.nextLayout(wrappingWidth, ((Integer) tabLocations.get(currentTab)).intValue() + 1, lineContainsText && false);

                // layout can be null if lineContainsText is true
                if (layout != null)
                {
                    layouts.addElement(layout);
                    penPositions.addElement(new Float(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                }

                if (measurer.getPosition() == ((Integer) tabLocations.get(currentTab)).intValue() + 1)
                {
                    currentTab++;
                }

                verticalPos += maxAscent;

                Enumeration layoutEnum = layouts.elements();
                Enumeration positionEnum = penPositions.elements();

                // now iterate through layouts and draw them
                while (layoutEnum.hasMoreElements())
                {
                    TextLayout nextLayout = (TextLayout) layoutEnum.nextElement();
                    float horizPos = 0f; // (Float) positionEnum.nextElement();

                    switch (hAlign)
                    {
                        case ALIGNMENT.Right: // 右对齐
                            horizPos = rc.x + rc.width - nextLayout.getAdvance();
                            break;
                        case ALIGNMENT.Center: // 居中对齐
                            horizPos = rc.x + (rc.width - nextLayout.getAdvance()) / 2;
                            break;
                        default:
                            horizPos = rc.x + 0f;
                            break;
                    }

                    nextLayout.draw(g, horizPos, verticalPos);
                }

                verticalPos += maxDescent;
            }

        } catch (Exception e)
        {
        } finally
        {
            // 恢复旧的裁减区域
            Tools.setClip(g, oc);
        }
    }

    // 多行文本的高度
    public static float MultiLineTextHeight(Graphics2D g, int width, String s, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline)
    {
        if (s == null) return 0;
        if (s.trim().isEmpty()) return 0;
        if (width <= 0) return 0;

        HashMap map = new HashMap();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        if (FontBold) map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        if (FontItalic) map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        AttributedString ss = new AttributedString(s, map);

        AttributedCharacterIterator styledText = ss.getIterator();
        FontRenderContext frc = g.getFontRenderContext();

        ArrayList tabLocations = new ArrayList();

        int i = 0;
        for (char c = styledText.first(); c != AttributedCharacterIterator.DONE; c = styledText.next())
        {
            if (c == '\n')
            {
                tabLocations.add(new Integer(styledText.getIndex()));
            }
        }
        tabLocations.add(new Integer(styledText.getEndIndex() - 1));
        int tabCount = tabLocations.size();
        // Now tabLocations has an entry for every tab's offset in
        // the text. For convenience, the last entry is tabLocations
        // is the offset of the last character in the text.

        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);

        int currentTab = 0;
        float verticalPos = 0;

        while (measurer.getPosition() < styledText.getEndIndex())
        {

            // Lay out and draw each line. All segments on a line
            // must be computed before any drawing can occur, since
            // we must know the largest ascent on the line.
            // TextLayouts are computed and stored in a Vector;
            // their horizontal positions are stored in a parallel
            // Vector.

            // lineContainsText is true after first segment is drawn
            boolean lineContainsText = false;

            float maxAscent = 0, maxDescent = 0;
            float horizontalPos = 0;
            Vector layouts = new Vector(1);
            Vector penPositions = new Vector(1);

            float wrappingWidth = (float) width;
            TextLayout layout = measurer.nextLayout(wrappingWidth, ((Integer) tabLocations.get(currentTab)).intValue() + 1, lineContainsText && false);

            // layout can be null if lineContainsText is true
            if (layout != null)
            {
                layouts.addElement(layout);
                penPositions.addElement(new Float(horizontalPos));
                horizontalPos += layout.getAdvance();
                maxAscent = Math.max(maxAscent, layout.getAscent());
                maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
            }

            if (measurer.getPosition() == ((Integer) tabLocations.get(currentTab)).intValue() + 1)
            {
                currentTab++;
            }

            verticalPos += maxAscent;

            Enumeration layoutEnum = layouts.elements();
            Enumeration positionEnum = penPositions.elements();

            // now iterate through layouts and draw them
            while (layoutEnum.hasMoreElements())
            {
                TextLayout nextLayout = (TextLayout) layoutEnum.nextElement();
                Float nextPosition = new Float(0f); // (Float) positionEnum.nextElement();

            }

            verticalPos += maxDescent;
        }

        return verticalPos;
    }

    public static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline)
    {
        String key = FontName + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        if (m_FontMap.containsKey(key))
        {
            return (Font) (m_FontMap.get(key));
        }
        HashMap map = new HashMap();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline)
        {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (FontBold)
        {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic)
        {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        m_FontMap.put(key, font);
        return font;
    }

    public static Rectangle LeftPartOfRectangle(Rectangle rc)
    {
        return new Rectangle(rc.x, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle TopPartOfRectangle(Rectangle rc)
    {
        return new Rectangle(rc.x + rc.width / 4, rc.y, rc.width / 2, rc.height / 4);
    }

    public static Rectangle RightPartOfRectangle(Rectangle rc)
    {
        return new Rectangle(rc.x + rc.width * 3 / 4, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle BottomPartOfRectangle(Rectangle rc)
    {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height * 3 / 4, rc.width / 2, rc.height / 4);
    }

    public static Rectangle MiddlePartOfRectangle(Rectangle rc)
    {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height / 4, rc.width / 2, rc.height / 2);
    }

    static public Container GetRootContainer(Container op)
    {
        Container ct;
        ct = op;
        while (ct != null)
        {
            // Tools.log("aaa " +ct.getClass().getName());
            if (ct.getParent() == null) return ct;
            ct = ct.getParent();
        }
        return ct;
    }

    // 判断op 是否是在Applet中,并返回这个Applet
    static public Applet ContainedByApplet(Component op)
    {
        Component ct = op;
        while (ct != null)
        {
            // Tools.log("eeee " +ct.getClass().getName());
            if (ct instanceof Applet) return (Applet) ct;
            ct = ct.getParent();
        }
        return null;
    }

    // 从1累加到n
    static public int RecursionAdd(int n)
    {
        if (n <= 0) return 0;
        return n + RecursionAdd(n - 1);
    }

    static public Cursor GetCursor(Component obj, String curName, Point hotPoint)
    {

        if (m_CursorMap.containsKey(curName)) return (Cursor) m_CursorMap.get(curName);
        Cursor cur = null;

        if (curName == IDC_ARROW) cur = new Cursor(Cursor.DEFAULT_CURSOR);
        if (curName == IDC_SYS_WE) cur = new Cursor(Cursor.W_RESIZE_CURSOR);
        if (curName == IDC_SYS_NS) cur = new Cursor(Cursor.N_RESIZE_CURSOR);

        if (cur == null)
        {
            Applet ContainedByApplet = Tools.ContainedByApplet(obj);

            Image img = null;

            Toolkit tk = Toolkit.getDefaultToolkit();

            URL url = obj.getClass().getClassLoader().getResource("excel/res/" + curName);

            if (curName.equals("sort.gif"))
            {
                Tools.log(url.toString());
                Tools.log(" ContainedByApplet is null :" + (ContainedByApplet == null));
            }
            //Tools.log( url);
            //2009.12.30 增加判断：如果url是以 file:/开头，表明是把applet嵌在非浏览器界面中，此时不能用applet.getImage
            if (ContainedByApplet != null && !(url.toString().startsWith("file:/")) && !(url.toString().startsWith("jar:file:/")))
            {

                try
                {
                    img = ContainedByApplet.getImage(url);
                } catch (Exception e)
                {
                    img = null;
                }

                if (img == null) return new Cursor(Cursor.DEFAULT_CURSOR);
                MediaTracker tracker = new MediaTracker(ContainedByApplet);
                tracker.addImage(img, 0);

                cur = tk.createCustomCursor(img, hotPoint, curName);

            }
            else
            {
                img = tk.getImage(url);
                if (img == null) return new Cursor(Cursor.DEFAULT_CURSOR);
                cur = tk.createCustomCursor(img, hotPoint, curName);
            }
        }

        if (cur == null) return new Cursor(Cursor.DEFAULT_CURSOR);
        m_CursorMap.put(curName, cur);
        return cur;

    }

    //仅一些系统的，常用的， 小的图片放到缓存里，其它图片不要缓存在这里
    static public Image getBuffredImageFromURL(Component Wnd, String imgURL)
    {
        if (!m_ImgMap.containsKey(imgURL)) m_ImgMap.put(imgURL, GetImageFromURL(Wnd, imgURL));
        return (Image) m_ImgMap.get(imgURL);
    }

    static public Image GetImageFromURL(Component Wnd, String imgURL)
    {
        //Tools.log(imgURL);

        Applet ContainedByApplet = ContainedByApplet(Wnd);

        Image img = null;

        URL url = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try
        {
            url = Wnd.getClass().getClassLoader().getResource(imgURL);
        } catch (Exception e)
        {

        }

        try
        {
            if (url == null) url = new URL(imgURL);
        } catch (Exception e)
        {

        }

        if (url == null) try
        {
            url = Wnd.getClass().getClassLoader().getResource("excel/res/notexists.gif");
        } catch (Exception e)
        {

        }

        MediaTracker tracker;

        //2009.12.30 疑问：
        // 下面的  ! url.startWith("jar:http:/") 实际上可能让本控制在浏览器中时也是直接用下面的 tk.getImage(url)
        // 而不是使用applet.getImage()  通常情况下，不需要加上  ! url.startWith("jar:http:/")
        //但当浏览器中的applet 打开一个JDialog，并且 在JDialog中有一个zexcel控件时，那么applet.getImage就会取不到图片，但是直接用 tk.getImage
        //却是取得到图片的，所以可以认为，其实不需要用applet.getImage,而直接到 tk.getImage 是能取到图片的。因为现在可以用了，所以这一点没有
        //继续验证下去。 还有一个问题就是，基于相同的理由， getCursor 在 url.startWith("jar:http:/")也应该会有问题,但是现在却是正常的
        if (ContainedByApplet != null && !(url.toString().startsWith("file:/")) && !(url.toString().startsWith("jar:file:/")) && !(url.toString().startsWith("jar:http:/")))
        {
            try
            {
                img = ContainedByApplet.getImage(url);
                tracker = new MediaTracker(ContainedByApplet);
            } catch (Exception e)
            {
                img = tk.getImage(url);
                tracker = new MediaTracker(Wnd);

            }
        }
        else
        {

            img = tk.getImage(url);
            tracker = new MediaTracker(Wnd);

        }

        tracker.addImage(img, 0);
        try
        {
            tracker.waitForAll();
        } catch (Exception e)
        {

        }

        return img;

    }

    public static Rectangle getStringBounds(Graphics2D g, String str, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline)
    {
        Rectangle ret = new Rectangle(0, 0, 0, 0);
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);

        if (g == null) return ret;
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, frc);
        ret.width = (int) layout.getAdvance();
        ret.height = (int) layout.getAscent();

        return ret;
    }

    public static void Delay(int mm)
    {
        FF.delay(mm);
    }

    static public void ShowInfo(Component parentComponent, String info)
    {
        JOptionPane.showMessageDialog(parentComponent, info, "提示", JOptionPane.WARNING_MESSAGE);
    }

    public static Point GetAbsolutePoint(Component obj, Point p)
    {
        if (obj == null) return p;
        Point ret = (Point) p.clone();
        SwingUtilities.convertPointToScreen(ret, obj);
        return ret;
        /*
         * Point ret= (Point)p.clone(); ret.x+=obj.getX(); ret.y+=obj.getY(); Component pObj=obj.getParent(); if (
         * pObj==null) return ret; return GetAbsolutePoint( pObj, ret);
         */
    }

    public static String Color2Hex(Color c)
    {
        String ret;
        String r = ("00" + Integer.toString(c.getRed(), 16));
        r = r.substring(r.length() - 2, r.length());

        String g = ("00" + Integer.toString(c.getGreen(), 16));
        g = g.substring(g.length() - 2, g.length());

        String b = ("00" + Integer.toString(c.getBlue(), 16));
        b = b.substring(b.length() - 2, b.length());

        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c)
    {
        try
        {
            Color color = Color.decode(c);
            return color;
        } catch (Exception e)
        {
            return Color.BLACK;
        }

    }

    static public void MoveToScreenCenter(Component jf)
    {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((d.width - jf.getWidth()) / 2, (d.height - jf.getHeight()) / 2);

    }

    public static byte[] ReadFile(String filename)
    {
        byte[] ret = null;

        try (
                BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(filename)));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();)
        {


            int once = 1024;
            byte buffer[] = new byte[once];
            int actually = 0;

            while (true)
            {
                actually = bis.read(buffer);
                if (actually <= 0) break;
                bos.write(buffer, 0, actually);
            }

            bos.flush();
            bis.close();
            ret = bos.toByteArray();
            bos.close();
        } catch (Exception e)
        {
            return null;
        }
        return ret;
    }

    public static void clip(Graphics2D g, Shape shape) throws Exception
    {
        g.clip(shape);
    }

    public static void clip(Graphics2D g, Shape shape, boolean union)
    {
        if (!union) g.setClip(null);
        g.clip(shape);
    }

    public static void setClip(Graphics2D g, Shape shape)
    {
        g.setClip(shape);
    }

    //	 提取HTML中的文本

    public static void initAllFontSon9()
    {
        try
        {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            Font f1 = new Font("SimSun", 0, 12);
            Font f2 = new Font("SimSun", Font.BOLD, 12);
            Tools.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
        } catch (Exception e)
        {

        }

    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont,
                                        Object windowFont)
    {

        // LookUtils.log("Menu font =" + menuFont);
        // LookUtils.log("Control font=" + controlFont);
        // LookUtils.log("Message font=" + messageFont);

        Object[] defaults =
                {"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font",
                        controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font",
                        controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font",
                        controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont,

                        "InternalFrame.titleFont",
                        windowFont, // controlBold
                        "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont,
                        "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont,};
        table.putDefaults(defaults);

        if (menuFont != null)
        {
            Object[] menuDefaults =
                    {"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont",
                            menuFont, // 1.3 only ?
                            "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont,
                            "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont, // 1.3
                            // only
                            // ?
                    };
            table.putDefaults(menuDefaults);
        }
    }


    //Determining If an Image Has Transparent Pixels

    // This method returns true if the specified image has transparent pixels
    public static boolean hasAlpha(Image image)
    {
        // If buffered image, the color model is readily available
        if (image instanceof BufferedImage)
        {
            BufferedImage bimage = (BufferedImage) image;
            return bimage.getColorModel().hasAlpha();
        }

        // Use a pixel grabber to retrieve the image's color model;
        // grabbing a single pixel is usually sufficient
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try
        {
            pg.grabPixels();
        } catch (InterruptedException e)
        {
        }

        // Get the image's color model
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    // This method returns a buffered image with the contents of an image
    public static BufferedImage toBufferedImage(Image image)
    {
        if (image instanceof BufferedImage)
        {
            return (BufferedImage) image;
        }

        // This code ensures that all the pixels in the image are loaded
        image = new ImageIcon(image).getImage();

        // Determine if the image has transparent pixels; for this method's
        // implementation, see e661 Determining If an Image Has Transparent Pixels
        boolean hasAlpha = hasAlpha(image);

        // Create a buffered image with a format that's compatible with the screen
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try
        {
            // Determine the type of transparency of the new buffered image
            int transparency = Transparency.OPAQUE;
            if (hasAlpha)
            {
                transparency = Transparency.BITMASK;
            }

            // Create the buffered image
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        } catch (HeadlessException e)
        {
            // The system does not have a screen
        }

        if (bimage == null)
        {
            // Create a buffered image using the default color model
            int type = BufferedImage.TYPE_INT_RGB;
            if (hasAlpha)
            {
                type = BufferedImage.TYPE_INT_ARGB;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }

        // Copy image to buffered image
        Graphics g = bimage.createGraphics();

        // Paint the image onto the buffered image
        g.drawImage(image, 0, 0, null);
        g.dispose();

        return bimage;
    }

    public static BufferedImage grayImage(Image img)
    {
        BufferedImage srcImg = toBufferedImage(img);
        int iw = srcImg.getWidth();
        int ih = srcImg.getHeight();
        Graphics2D srcG = srcImg.createGraphics();
        RenderingHints rhs = srcG.getRenderingHints();

        ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_GRAY);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        BufferedImage dstImg = new BufferedImage(iw, ih, BufferedImage.TYPE_INT_RGB);

        theOp.filter(srcImg, dstImg);
        return dstImg;
    }

    public static String getStringFromClipboard()
    {

        try
        {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();//获取系统剪贴板

            // 获取剪切板中的内容

            Transferable clipT = clip.getContents(null);

            if (clipT != null)
            {

                // 检查内容是否是文本类型

                if (clipT.isDataFlavorSupported(DataFlavor.stringFlavor))

                    return (String) clipT.getTransferData(DataFlavor.stringFlavor);

            }
        } catch (Exception e)
        {

        }
        return null;

    }

    public static byte[] getImageFromClipboard()
    {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable cc = sysc.getContents(null);
        if (cc != null) //看是不是图片文件，再看是不是直接复制的图片数据
        {
            byte[] imgData = null;
            try
            {
                DataFlavor df[] = cc.getTransferDataFlavors();
                for (int i = 0; i < df.length; i++)
                {
                    String type = df[i].getMimeType();
                    //Tools.log(type);

                    if (type.equals("application/x-java-file-list; class=java.util.List"))
                    {
                        Object obj = cc.getTransferData(df[i]);
                        List list = (List) obj;
                        if (list.size() == 0) continue;

                        for (int n = 0; n < list.size(); n++)
                        {
                            String name = list.get(n).toString();
                            try
                            //看是不是图片文件
                            {
                                Image imga = ImageIO.read(new File(name));
                                if (imga != null)
                                {
                                    imgData = Tools.ReadFile(name);
                                    break;
                                }

                            } catch (Exception er)
                            {

                            }

                        }
                        if (imgData != null) break;
                    }
                }

                if (imgData == null && cc.isDataFlavorSupported(DataFlavor.imageFlavor))
                {

                    Image imga = (Image) cc.getTransferData(DataFlavor.imageFlavor);

                    BufferedImage img = new BufferedImage(imga.getWidth(null), imga.getHeight(null), BufferedImage.TYPE_INT_RGB);
                    Graphics2D graphics = (Graphics2D) img.getGraphics();
                    graphics.drawImage(imga, null, null);

                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    BufferedOutputStream bos = new BufferedOutputStream(bo);

                    ImageIO.write(img, "png", bos);
                    bos.flush();
                    bos.close();
                    byte[] ret = bo.toByteArray();

                    imgData = ret;

                }
            } catch (Exception e)
            {


            }
            return imgData;
        }
        else
        {
            return null;
        }
    }

    public static void requestInputFocus(JComponent comp)
    {
        comp.requestFocus();

        final JComponent comp_ = comp;

        SwingUtilities.invokeLater(new Runnable()
        {

            public void run()
            {
                comp_.requestFocus();
            }

        });
    }

    public static Dialog getDialogContainsComponent(Component component)
    {
        Component comp = component.getParent();
        while (comp != null)
        {
            if (comp instanceof Dialog) return (Dialog) comp;
            comp = comp.getParent();
        }
        return null;
    }

    public static void log(String info)
    {
        System.out.print("zexcel log:");
        System.out.println(info);
    }

    public static void log(int info)
    {
        System.out.println(info);
    }

    public static void log(boolean info)
    {
        System.out.println(info);
    }

    public static Stroke getStroke(float width, int cap, int join)
    {

        String key = width + "-" + cap + "-" + join;
        if (!m_StrokeMap.containsKey(key))
        {
            m_StrokeMap.put(key, new BasicStroke(width, cap, join));
        }

        return (Stroke) m_StrokeMap.get(key);

    }

    public static Stroke getStroke(float width, int cap, int join, float miterlimit, float dash[], float dash_phase)
    {
        StringBuffer key = new StringBuffer();
        key.append(width).append("-").append(cap).append("-").append(join).append("-").append(miterlimit);
        for (int i = 0; i < dash.length; i++)
        {
            key.append("-");
            key.append(dash[i]);
        }

        if (!m_StrokeMap.containsKey(key))
        {
            m_StrokeMap.put(key, new BasicStroke(width, cap, join, miterlimit, dash, dash_phase));
        }

        return (Stroke) m_StrokeMap.get(key);
    }

    public static PrintService findPrintService(PrintService[] services, String serviceName)
    {

        //选中合适的打印机
        int selectedService = 0;
        if (services.length == 0) return null;

        for (int i = 0; i < services.length; i++)
        {

            if (serviceName.equals(services[i].getName()))
            {
                return services[i];
            }
        }
        return services[0];
    }

    /**
     * 根据打印设置创建一个pageformat
     *
     * @param pj
     * @param pageConfig
     * @return
     */
    public static PageFormat createPageFormat(PrinterJob pj, JSONObject pageConfig)
    {

        PageFormat page = pj.defaultPage();


        double paperWidth = pageConfig.getDouble("pageWidth", mm2pixel(210));
        double paperHeight = pageConfig.getDouble("pageHeight", mm2pixel(297));

        double left = pageConfig.getDouble("leftMargin", mm2pixel(25.4));
        double right = pageConfig.getDouble("rightMargin", mm2pixel(25.4));
        double top = pageConfig.getDouble("topMargin", mm2pixel(25.4));
        double bottom = pageConfig.getDouble("bottomMargin", mm2pixel(25.4));

        int orientation = pageConfig.getInt("printDir", 1);

        if (orientation == 1) // 1是纵向 0横向
        {
            //原点在纸张的左上方，x 指向右方，y 指向下方
            page.setOrientation(PageFormat.PORTRAIT);
        }
        else
        {
            //原点位于纸张的左下方，x 的方向从下到上，y 的方向从左到右
            page.setOrientation(PageFormat.LANDSCAPE);

        }

        int pageHeaderHeight = pageConfig.getJSONObject("pageHeaderConfig", null).getInt("height", 0);
        int pageFooterHeight = pageConfig.getJSONObject("pageFooterConfig", null).getInt("height", 0);


        //单位 ：px ， 已由毫米转成像素
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        paper.setImageableArea(left, top - pageHeaderHeight, paperWidth - left - right, paperHeight - top - bottom + pageHeaderHeight + pageFooterHeight);
        page.setPaper(paper);

        return page;

    }

    /**
     * 根据打印设置，创建一个HashPrintRequestAttributeSet
     *
     * @param printOption
     * @param sheetName
     * @return
     */
    public static HashPrintRequestAttributeSet createHashPrintRequestAttributeSet(JSONObject printOption, String sheetName, int pageCount)
    {


        HashPrintRequestAttributeSet ret = new HashPrintRequestAttributeSet();
        ret.add(new Copies(printOption.getInt("copy", 1)));
        int fromPage = printOption.getInt("fromPage", 1);
        int toPage = printOption.getInt("toPage", 9999);
        int pageRange = printOption.getInt("pageRange", 3);


        StringBuffer sb = new StringBuffer(1024);
        if (pageRange == 3)
        {
            ret.add(new PageRanges(Math.min(pageCount, fromPage) + "-" + Math.min(pageCount, toPage)));
        }
        else
        {
            int y = pageRange == 2 ? 0 : 1;
            for (int i = Math.min(pageCount, fromPage); i <= Math.min(pageCount, toPage); i++)
            {
                if (i % 2 == y)
                {
                    if (sb.length() > 0) sb.append(",");
                    sb.append("" + i);

                }
            }
            if (sb.length() == 0) sb.append("9999"); //没有满足条件的页码，比如只有一页，但要打偶数页
            ret.add(new PageRanges(sb.toString()));
        }

        ret.add(new JobName("打印：" + sheetName, null));
        return ret;
    }

    /**
     * 毫米转化成点
     *
     * @param mm
     * @return
     */
    public static double mm2pixel(double mm)
    {
        return mm / 25.4 * 72.0;
    }

    public static int String2Int(String s)
    {
        try
        {
            return new Integer(s).intValue();
        } catch (Exception e)
        {
            return 0;
        }
    }

    public static boolean confirm(Component parentComponent, String msg)
    {

        int result = JOptionPane.showConfirmDialog(parentComponent, msg, "请选择", JOptionPane.YES_NO_OPTION);
        return (result == JOptionPane.YES_OPTION);
    }


    public static boolean stringMatch(Object v, String text, String key, boolean caseSensitive, boolean fullMatch)
    {
        if (v == null) return false;
        if (text.isEmpty()) return false;
        if (fullMatch)
        {
            if (caseSensitive) return key.equals(text);
            return key.equalsIgnoreCase(text);
        }
        else
        {

            if (caseSensitive) return text.indexOf(key) >= 0;
            return text.toLowerCase().indexOf(key.toLowerCase()) >= 0;
        }

    }
}
