package gdi;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.*;
import config.CacheConfig;
import dfs.ImageInfo;
import dfs.UploadFile;
import jun.db.impl.DataStoreFactory;
import okio.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import util.FF;
import webApp.App;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;

public class ImageWaterMark
{

    public static void main(String[] arg) throws Exception
    {

        JSONObject config = new JSONObject();
        config.put("watermark", "水印测试abc123");
        config.put("color", "#ffffff");

        config.put("alpha", 0.9);
        config.put("gutter", 50);
        config.put("rotate", -45);


        addWaterMarkRepeat("/Users/zengjun/Downloads/蒙娜丽莎.png", "/Users/zengjun/Downloads/aaa/x/pz7-w.jpg", config);

        config.put("x" ,   0);
        config.put("y",  -50);

        config.put("width", -20);
        config.put("height",30);

        config.put("hAlign",1);
        config.put("vAlign",1);

        config.put("fontSize",30);


        addWaterMarkOnce("/Users/zengjun/Downloads/蒙娜丽莎.png", "/Users/zengjun/Downloads/aaa/x/pz7-w2.jpg", config);


    }

    public static boolean addWaterMark (String sourceFile, String destFile, JSONArray configs) throws Exception
    {
        for( int i=0;i< configs.length() ;  i++ )
        {
            JSONObject config = configs.getJSONObject(i);

            if (config.getString("repeat", "none").equalsIgnoreCase("auto"))
            {
                if(! addWaterMarkRepeat(sourceFile, destFile, config)) return false;
            }
            else
            {
                if(!addWaterMarkOnce(sourceFile, destFile, config)) return false;
            }

            sourceFile= destFile;

        }
        return true;
    }

    public static boolean addWaterMarkOnce(String sourceFile, String destFile, JSONObject config) throws Exception
    {


        String extName = FF.splitFileName(destFile)[2];

        if (extName.equalsIgnoreCase("png")) extName = "jpg";

        int minSize = config.getInt("minSize", 64);


        String WaterMarkContent = config.getString("text", "");
        if (WaterMarkContent.isEmpty()) return false;

        ImageInfo ii = UploadFile.getImageInfo(sourceFile);

        BufferedImage image = ImageIO.read(new File(sourceFile));

        int width = ii.width;
        int height = ii.height;

        if (width < minSize) return false;
        if (height < minSize) return false;

        float alpha = (float) config.getDouble("alpha", 0.1);


        String color = config.getString("color", "#000000");
        Color c = Tools.Hex2Color(color);


        alpha = Math.min(1, Math.max(0, alpha));

        Rectangle rc=  getBounds( width, height , config);




        String fontName = config.getString("fontName", "宋体");
        int fontSize= config.getInt("fontSize",9);



        BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();

        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(width, height, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------

        // 绘制原始图片
        graphics.drawImage(image, 0, 0, width, height, null);


        graphics.setFont(new Font(fontName, 1, fontSize));


        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha);
        graphics.setComposite(ac);

        //消除文字锯齿
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        //消除画图锯齿

        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);

        graphics.setColor(c);

        //
        int  h_align= config.getInt("hAlign",0);
        int  v_align = config.getInt("vAlign", 0);

        Tools.DrawString(graphics, rc, WaterMarkContent, 0,null,c ,fontName ,fontSize,false,false,false,h_align, v_align);



        try  (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(destFile))))
        {

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();

        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return FF.fileExists(destFile);


    }

    private static  int  parseSize( int len , String def)
    {
        def= def.trim().toLowerCase();
        def= FF.replaceAll(def , "px", ""); //去掉px

        if(  def.endsWith("%"))
        {
            return (int) (len * Math.max(100.0,  Double.parseDouble(def.substring(0, def.length() - 1))) / 100);
        }

        return Integer.parseInt(def);

    }


    private static  Rectangle getBounds( int imgWidth, int imgHeighth ,  JSONObject config)
    {
         Rectangle tc = new Rectangle(0,0,0,0);

         String left= config.getString("left", "");
        String top= config.getString("top", "");
        String right= config.getString("right", "");
        String bottom= config.getString("bottom", "");
        String width= config.getString("width", "");
        String height= config.getString("height", "");


        // left + width

        if( !left.isEmpty() && ! width.isEmpty())
        {
            tc.x = parseSize(imgWidth, left);
            tc.width = parseSize(imgWidth , width);
        }


        if( !left.isEmpty() && ! right.isEmpty())
        {
            tc.x = parseSize(imgWidth, left);
            int n = parseSize(imgWidth , right);
            tc.width = imgWidth  - tc.x -  n;
        }

        if( !width.isEmpty() && ! right.isEmpty())
        {

            int n = parseSize(imgWidth , right);
            tc.width= parseSize(imgWidth ,width);
            tc.x = imgWidth  - tc.width -  n;
        }

        if( !top.isEmpty() && ! height.isEmpty())
        {
            tc.y = parseSize(imgHeighth, top);
            tc.height = parseSize(imgHeighth , height);
        }

        if( !top.isEmpty() && ! bottom.isEmpty())
        {
            tc.y = parseSize(imgHeighth, top);
            int n = parseSize(imgHeighth , bottom);
            tc.height = imgHeighth  - tc.y -  n;
        }

        if( !height.isEmpty() && ! bottom.isEmpty())
        {

            int n = parseSize(imgHeighth , bottom);
            tc.height= parseSize(imgHeighth ,height);
            tc.y = imgHeighth  - tc.height -  n;
        }



        return tc;
    }

        public static boolean addWaterMarkRepeat(String sourceFile, String destFile, JSONObject config) throws Exception
    {

        String extName = FF.splitFileName(destFile)[2];

        if (extName.equalsIgnoreCase("png")) extName = "jpg";


        String WaterMarkContent = config.getString("text", "");
        if (WaterMarkContent.isEmpty()) return false;

        int minSize = config.getInt("minSize", 64);

        ImageInfo ii = UploadFile.getImageInfo(sourceFile);

        BufferedImage image = ImageIO.read(new File(sourceFile));

        int width = ii.width;
        int height = ii.height;

        if (width < minSize) return false;
        if (height < minSize) return false;

        float alpha = (float) config.getDouble("alpha", 0.1);

        int gutter = config.getInt("gutter", 20);
        String color = config.getString("color", "#000000");
        Color c = Tools.Hex2Color(color);


        alpha = Math.min(1, Math.max(0, alpha));
        int md = config.getInt("density", 4);

        md = Math.max(1, Math.min(20, md));

        String fontName = config.getString("fontName", "宋体");

        float waterMarkWidth;


        if (width < height)
        {
            waterMarkWidth = (float) (width / md);
        }
        else
        {
            waterMarkWidth = (float) (height / md);
        }


        BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();

        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(width, height, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------

        // 绘制原始图片
        graphics.drawImage(image, 0, 0, width, height, null);

        int delta = 1;
        int fontSize = 9;

        int rotate = config.getInt("rotate",0);

        // 旋转角度，以弧度表示
        double theta = Math.toRadians(rotate);


        while (true)
        {
            int strWidth = Tools.getStringBounds(graphics, WaterMarkContent, fontName, fontSize, false, false, false).width;


            strWidth = (int) (strWidth * Math.cos( theta ) + gutter);


            if (strWidth > waterMarkWidth) break;
            fontSize += delta;
            if (fontSize > 100) break;
        }
        fontSize -= delta; //因为是超过了，所以减一号字

        if (fontSize < 9) fontSize = 9;


        int rn = (int) Math.ceil(height / waterMarkWidth);
        int cn = (int) Math.ceil(width / waterMarkWidth);

        if (rn < 1) rn = 1;
        if (cn < 1) cn = 1;

        graphics.setFont(new Font(fontName, 1, fontSize));


        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha);
        graphics.setComposite(ac);

        //消除文字锯齿
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        //消除画图锯齿

        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);

        graphics.setColor(c);

        // 保存原始转换矩阵
        AffineTransform originalTransform = graphics.getTransform();
        for (int row = 0; row < rn; row++)
        {
            for (int col = 0; col < cn; col++)
            {

                int x = (int) (col * waterMarkWidth + fontSize);  ///+ fontSize 是微调一下， 不然第一个字会显示不全， 大概数字，不需要很精确
                int y = (int) ((row + 1) * waterMarkWidth + fontSize);

                // 旋转图形上下文
                graphics.rotate(theta, x, y);

                graphics.drawString(WaterMarkContent, x, y);
// 恢复原始转换矩阵
                graphics.setTransform(originalTransform);

            }
        }


        try
                (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(destFile))))
        {

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();

        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return FF.fileExists(destFile);

    }


    public static String createImage(String info, String tempPath, String fontName, int fontSize, float alpha, int size, int rotate)
    {

        int w = size;
        int h = size;


        BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();

        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------


        graphics.setColor(Color.darkGray);

        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha);
        graphics.setComposite(ac);

        //消除文字锯齿
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        //消除画图锯齿

        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);


        graphics.setFont(new Font(fontName, 1, fontSize));
        //graphics.translate(this.getWidth() / 2, this.getHeight() / 2);
        graphics.rotate(-(rotate * 1.0 / 180) * Math.PI);//旋转


        graphics.drawString(info, -w / 2, h);

        String fileName = FF.pathJoin(tempPath, DataStoreFactory.newGUID() + ".png");


        try
                (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(fileName))))
        {

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();

        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return fileName;
    }


}
