package dfs;

import app.User;
import config.CacheConfig;
import gdi.ALIGNMENT;
import gdi.ImageRotate;
import gdi.Tools;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import util.BuildParamFromRequest;
import util.FF;
import util.IMG_addstamp;
import util.PDF_addstamp;
import webApp.App;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLEncoder;
import java.util.Date;

@WebServlet(name = "watermarkService", urlPatterns = "/watermarkService")
public class WatermarkService extends HttpServlet
{


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");


        BufferedOutputStream bos = null;

        User user = User.getUserFromRequest(req);

        String action = "view";

        try
        {

            res.setContentType("text/html;charset = UTF-8");//很重要
            res.setCharacterEncoding("UTF-8");

            bos = new BufferedOutputStream(res.getOutputStream());


            String extName = ".png";

            String mimeType = req.getSession().getServletContext().getMimeType(extName);
            if (mimeType == null) mimeType = "";

            String task= FF.getStringFromRequest(req,"task","");

            JSONObject cfg= null;
            if( !task.isEmpty())
            {
                Object v= FF.runScript(task,new JSONObject(), req, res);
                if( v!=null)
                {
                    String t= v.toString();
                    cfg= new JSONObject(t);
                }
            }

            if( cfg==null)  cfg= new JSONObject();
            res.setContentType(mimeType);

            bos = new BufferedOutputStream(res.getOutputStream());

            String info = cfg.getString("watermark",  user.getName() + "[" + user.getShowName() + "]\n" + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date()));

            int w = cfg.getInt( "width", 300);
            int h =cfg.getInt("height",  300);
            float alpha= (float) cfg.getDouble("alpha",0.1f);
            int fontSize= cfg.getInt("fontSize",20);
            int rotate= cfg.getInt("rotate",45);

            BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
            Graphics2D graphics = (Graphics2D) img.getGraphics();

            // ----------  增加下面的代码使得背景透明  -----------------
            img = graphics.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
            graphics.dispose();
            graphics = img.createGraphics();
            // ----------  背景透明代码结束  -----------------


            graphics.setColor(Color.black);

            AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha);
            graphics.setComposite(ac);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

            Tools.DrawString(graphics, new Rectangle (0, 0, w, h) , info, 0, Color.black , Color.black,  "simsun",
                             fontSize, false, false, false, ALIGNMENT.Center, ALIGNMENT.Center , true);
            String fileName = "";

            BufferedImage result = new ImageRotate().rotateImage(img, rotate, new Color(255, 255, 255) );


            ImageIO.write(result, "png", bos);
            bos.flush();
            bos.close();


            bos = null;


        } catch (Exception e)
        {

            FF.log("下载异常：" + e.getMessage());


        } finally
        {

        }

    }


}
