package dfs;

import app.DBInit;
import app.User;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import jun.db.util.Base32Coder;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.imgscalr.Scalr;
import org.json.JSONArray;
import org.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import util.AppCache;
import util.DBF;
import util.DelayRun;
import util.FF;
import webApp.App;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.List;
import java.util.*;

/**
 * 临时上传 文件放到自动删除的目录中
 */
@WebServlet(name = "UploadTempFile", urlPatterns = "/UploadTempFile")
public class UploadTempFile extends HttpServlet
{


    private static int maxSize = 100;//100M



    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        request.setCharacterEncoding("UTF-8"); //很重要

        /* 允许跨域的主机地址 */
        response.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Cache-Control", "no-cache");
        /* 重新预检验跨域的缓存时间 (s) */
        response.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, X-Requested-By, If-Modified-Since, X-File-Name, X-File-Type, Cache-Control, Origin");

        /* 是否携带cookie */
        response.setHeader("Access-Control-Allow-Credentials", "true");

        response.setHeader("XDomainRequestAllowed", "1");

        response.setContentType("text/html; charset=UTF-8");

        if (request.getMethod().equals("OPTIONS"))
        {
            response.setStatus(HttpServletResponse.SC_OK);
            return;
        }

        String ret = "";
        String responseType = "";

        FF.log("准备上传");


        String subPath = "autoDeleteAfterOneHour/";


        String fileName = ""; //上传后保存到的文件名

        User user = User.getUserFromRequest(request);

        try
        {

            if (user.getId() < 0) throw new Exception("未登录用户禁止使用此功能");
//
            FF.log("开始上传");
            FF.MkDirs(App.FileRoot + "/FileServer/");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload(factory);
            factory.setSizeThreshold(4096); // 设置缓冲区大小，这里是4kb
            factory.setRepository(new File(App.FileRoot + "/FileServer/"));// 设置缓冲区目录
            upload.setSizeMax(1024 * 1024 * maxSize); // 设置最大文件尺寸，这里是100MB


            List<FileItem> items = upload.parseRequest(request);
            Iterator<FileItem> i = items.iterator();


            JSONObject data = new JSONObject();

            JSONObject col2value = new JSONObject();
            FF.log("分析内容");
            while (i.hasNext())
            {


                FileItem fi = (FileItem) i.next();
                if (!fi.isFormField()) continue;
                fileName = fi.getName();
                FF.log(fi.getFieldName());

                col2value.put(fi.getFieldName(), fi.getString());//原始数据
                if (!fi.getFieldName().equals("uploadData"))
                {

                    continue;
                }

                String v = fi.getString();
                FF.log("数据包：");
                FF.log(v);
                if (v.startsWith("%7"))  //可能是直接的JSON串做了encodeURI 也可能是base32编码后的内容
                {
                    v = URLDecoder.decode(v, "UTF-8");
                }
                else
                {
                    v = new String(Base32Coder.decode(v), "UTF-8");
                }

                FF.log(v);

            }


            FF.log("处理文件");
            //第二遍，处理文件
            i = items.iterator();
            JSONObject saveLogResult;
            JSONObject jsonRet = null;


            String corporationid = FF.getCurrentCorporationIdForCurrenUser(request);

            String path = App.FileRoot + "/FileServer/" + subPath;

            //
            FF.log("文件上传到临时目录：" + path);
            FF.MkDirs(path);


            while (i.hasNext())
            {
                String extName = "";
                String savedFile = "";

                FileItem fi = (FileItem) i.next();
                if (fi.isFormField())  //如果不是文件
                {
                    String col = fi.getFieldName();
                    if (col.equals("base64ImageData"))  //如果是编码的图片数据，那么视为图片
                    {
                        extName = col2value.getString("base64ImageFileType", "");
                        fileName = DataStoreFactory.newGUID() + "." + extName;
                        String txtFile = path + fileName + ".txt";
                        FF.SaveToFile(txtFile, fi.getString());
                        savedFile = path + fileName;

                        //解码出来保存

                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(savedFile)));

                        byte[] b =Base64.decodeBase64(fi.getString());
                        bos.write( b ,0, b.length);
                        bos.flush();
                        bos.close();

                    }
                    else
                    {
                        continue;
                    }
                }
                else
                {  //是一个文件对象

                    fileName = fi.getName();
                    String t[] = StringUtils.split(fileName, ".");
                    extName = t.length >= 2 ? t[t.length - 1] : "";
                    savedFile = path + DataStoreFactory.newGUID() + "." + extName;
                    fi.write(new File(savedFile));//临时文件
                }

                jsonRet = new JSONObject();
                jsonRet.put("success", true);
                jsonRet.put("url", "deleteAfterDownloaded?sourcename="+FF.encryptString(savedFile,DowneloadAndDelete.pwd)+"&filename="+ FF.encryptString (fileName,DowneloadAndDelete.pwd));
                ret = jsonRet.toString();

                break; //只上传一个

            }

        } catch (Exception e)
        {
            ret = new JSONObject().put("success", false).put("message", FF.exceptionMessage(e)).toString();

        } finally
        {

            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.getOutputStream().write(ret.getBytes("UTF-8"));


        }
    }


}
