package dfs;

import app.DBInit;
import app.User;
import com.mysql.cj.util.Base64Decoder;
import config.CacheConfig;
import gdi.ImageWaterMark;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import jun.db.util.Base32Coder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.imgscalr.Scalr;
import org.json.JSONArray;
import org.json.JSONObject;

import util.*;
import webApp.App;
import webApp.PushLog;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.*;
import java.util.List;

@WebServlet(name = "UploadFile", urlPatterns = "/UploadFile")
public class UploadFile extends HttpServlet
{

    private static String CS_PREFIX_FILE_UNIQUECHECK = "文件上传防重检测:";
    private static String CS_UPLOADING = "上传中";
    private static String CS_UPLOADED = "上传完成";
    private static int expireSeconds = 300;


    class UploadedException extends Exception
    {
        public UploadedException(String info)
        {
            super(info);
        }
    }


    public static IFileServer getInstance(int serverIndex)
    {
        String server_type = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/server_type", "inner");

        if (serverIndex == 0) server_type = "inner"; //为了安全， 强制设置

        if (server_type.equals("inner")) return new InnerFileServer(serverIndex);
        if (server_type.equals("aliyunoss")) return new AliyunOSSServer(serverIndex);
        if (server_type.equals("minio")) return new MinioFileServer(serverIndex);
        if (server_type.equals("path")) return new PathFileServer(serverIndex);
        if (server_type.equals("proxy")) return new ProxyFileServer(serverIndex);


        return null;
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        request.setCharacterEncoding("UTF-8"); //很重要

        /* 允许跨域的主机地址 */
        response.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Cache-Control", "no-cache");
        /* 重新预检验跨域的缓存时间 (s) */
        response.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, X-Requested-By, If-Modified-Since, X-File-Name, X-File-Type, Cache-Control, Origin");

        /* 是否携带cookie */
        response.setHeader("Access-Control-Allow-Credentials", "true");

        response.setHeader("XDomainRequestAllowed", "1");

        response.setContentType("text/html; charset=UTF-8");

        if (request.getMethod().equals("OPTIONS"))
        {
            response.setStatus(HttpServletResponse.SC_OK);
            return;
        }

        String ret = "";
        String responseType = "";

        FF.log("准备上传");
        int serverIndex = FF.getIntFromRequest(request, "serverIndex", 1);//使用哪个文件服务器
        int maxSize = FF.getIntFromRequest(request, "maxSize", 1000);
        int imageMaxWidthOrHeight = FF.getIntFromRequest(request, "imageMaxWidthOrHeight", 4096);


        //String bucketName = FF.getStringFromRequest(request, "bucketName", "default");//文件存放分区
        //String thumbnailBucketName = "";// 如果是图片，缩略图分区
        String logTable = FF.getStringFromRequest(request, "logTable", "app_fileupload"); // 上传日志保存到哪 个表中

        String fileType = FF.getStringFromRequest(request, "fileType", "*"); //
        String dbpool = FF.getStringFromRequest(request, "dbpool", "default");  // 连接池名称
        String tableName = FF.getStringFromRequest(request, "tableName", "");  // 相关的表单主表
        String gguid = FF.getStringFromRequest(request, "gguid", "");
        ; //相关数据的GGUID
        responseType = FF.getStringFromRequest(request, "responseType", "");

        boolean imageNeedCompress = true;

        boolean autoRename = true;
        String groupName = FF.getStringFromRequest(request, "groupName", "");
        int fileIndex = FF.getIntFromRequest(request, "fileIndex", 0);


        //上传到分区下的子目录 ，可以是多级
        String subPath = FF.getStringFromRequest(request, "path", tableName + "/" + FF.date2String(new Date(), "yyyy/MM/dd") + "/");
        String objectName = "";

        String uniqueKey = "";

        int maxThumbnailSize = 256; //缩略图最大尺寸 FF.getIntFromRequest(request, "maxthumbnailsize", 256);

        String fileName = ""; //上传后保存到的文件名

        User user = User.getUserFromRequest(request);

        try
        {

//
            FF.log("开始上传");
            FF.MkDirs(App.FileRoot + "/FileServer/");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload(factory);
            factory.setSizeThreshold(4096); // 设置缓冲区大小，这里是4kb
            factory.setRepository(new File(App.FileRoot + "/FileServer/"));// 设置缓冲区目录
            upload.setSizeMax(1024 * 1024 * maxSize); // 设置最大文件尺寸，这里是400MB


            List<FileItem> items = upload.parseRequest(request);
            Iterator<FileItem> i = items.iterator();


            JSONObject data = new JSONObject();

            JSONObject col2value = new JSONObject();
            FF.log("分析内容");
            JSONObject js = new JSONObject();
            while (i.hasNext())
            {


                FileItem fi = (FileItem) i.next();
                if (!fi.isFormField()) continue;
                fileName = fi.getName();
                FF.log(fi.getFieldName());

                col2value.put(fi.getFieldName(), fi.getString());//原始数据
                if (!fi.getFieldName().equals("uploadData"))
                {

                    continue;
                }

                String v = fi.getString();
                FF.log("数据包：" + v);

                if (v.startsWith("%7"))  //可能是直接的JSON串做了encodeURI 也可能是base32编码后的内容
                {
                    v = URLDecoder.decode(v, "UTF-8");
                }
                else
                {
                    v = new String(Base32Coder.decode(v), "UTF-8");
                }

                FF.log(v);

                js = new JSONObject(v);


                fileType = js.getString("fileType", fileType);
                serverIndex = js.getInt("serverIndex", 1);

                //2024.07.14 当 99时，取网盘对应的服务器
                if (serverIndex == 99) //网盘
                {
                    serverIndex = CacheConfig.get("/系统配置/网盘/fileserverindex", 1);
                }

                IFileServer fileServer = getInstance(serverIndex);

                //bucketName = js.getString("bucketName", fileServer.getBucketName(""));//
                //thumbnailBucketName = js.getString("thumbnailBucketName", bucketName);
                //因为拼写错误，所以只能兼容 logTable 和 logtable两个参数
                logTable = js.getString("logTable", js.getString("logtable", "app_fileupload"));

                groupName = js.getString("groupName", "");
                fileIndex = js.getInt("fileIndex", 0);

                autoRename = js.getBoolean("autoRename", true);

                imageMaxWidthOrHeight = js.getInt("imageMaxWidthOrHeight", fileServer.getImageMaxWidthOrHeight()); //图片最大尺寸

                imageNeedCompress = js.getBoolean("imageNeedCompress", true);

                dbpool = js.getString("dbpool", "default");
                tableName = js.getString("tableName", "");
                gguid = js.getString("gguid", "none");
                responseType = js.getString("responseType", "");

                subPath = js.getString("path", tableName + "/" + FF.date2String(new Date(), "yyyy/MM/dd") + "/");

                objectName = js.getString("objectName", objectName);

                if (!subPath.endsWith("/")) subPath += "/";
                if (subPath.startsWith("/")) subPath = subPath.substring(1);

                maxThumbnailSize = js.getInt("maxThumbnailSize", 256);

                data = js.getJSONObject("data", data);

                //2021.08.20 如果上传方带了一个唯一的键值用来做唯一性校验，那么就校验一下， 避免重复上传

                uniqueKey = js.getString("uniqueKey", "");

                ////当需要检测重复上传时，通常只支持单个文件的上传，所以这里简化处理了，假设只有一个文件
                if (!uniqueKey.isEmpty())
                {
                    FF.log("上传的文件需要校验唯一性，避免重复上传，key=" + uniqueKey);

                    String uploadState = AppCache.getCache(CS_PREFIX_FILE_UNIQUECHECK + uniqueKey, "");
                    if (uploadState.equals(CS_UPLOADING))
                    {
                        String errorInfo = "文件已经在上传中，或者请在" + expireSeconds + "秒后重新测试";
                        FF.log(errorInfo);
                        throw new Exception(errorInfo);
                    }

                    if (!uploadState.isEmpty())
                    {
                        FF.log("此文件刚刚不久才上传过，本次不再重复上传，直接返回上次上传的结果");
                        JSONObject lastRet = new JSONObject(uploadState);
                        //这个表示此前该文件已经上传，且上传成功了，那么直接以异常方式实现直接返回
                        if (lastRet.getBoolean("success", false) == true) throw new UploadedException(uploadState);
                        //到这里，肯定是上次上传发生异常了，所以重新来一次，最大的可能是保存上传日志时，数据库连接不够用

                    }
                    //到这里，那么标记一下此文件正在上传中
                    AppCache.setCache(CS_PREFIX_FILE_UNIQUECHECK + uniqueKey, CS_UPLOADING, true, expireSeconds);

                }
            }


            String[] fileTypes = fileType.split(",");
            ArrayList<String> fileTypeList = new ArrayList<String>();
            for (int ti = 0; ti < fileTypes.length; ti++)
            {
                fileTypeList.add(fileTypes[ti].trim().toLowerCase());
            }

            //if (thumbnailBucketName.isEmpty()) thumbnailBucketName = bucketName;

            FF.log("处理文件");
            //第二遍，处理文件
            i = items.iterator();
            JSONObject saveLogResult;
            JSONObject jsonRet = null;


            String corporationid = FF.getCurrentCorporationIdForCurrenUser(request);

            String path = App.FileRoot + "/FileServer/temp/" + DataStoreFactory.newLongID2String() + "/";

            //
            FF.log("文件上传到临时目录：" + path);
            FF.MkDirs(path);


            while (i.hasNext())
            {
                String extName = "";
                String savedFile = "";

                FileItem fi = (FileItem) i.next();
                if (fi.isFormField())  //如果不是文件
                {
                    String col = fi.getFieldName();
                    if (col.equals("base64ImageData"))  //如果是编码的图片数据，那么视为图片
                    {
                        extName = col2value.getString("base64ImageFileType", "png");
                        fileName = DataStoreFactory.newLongID2String() + "." + extName;
                        String txtFile = path + fileName + ".txt";
                        String t = fi.getString();
                        t = t.substring(t.indexOf(",") + 1);
                        FF.SaveToFile(txtFile, t);
                        savedFile = path + fileName;

                        //解码出来保存

                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(savedFile)));

                        byte[] b = Base64.decodeBase64(t);
                        bos.write(b, 0, b.length);
                        bos.flush();
                        bos.close();

                    }
                    else
                    {
                        continue;
                    }
                }
                else
                {  //是一个文件对象

                    fileName = fi.getName();

                    //2025.05.06 有时候，文件名中会带上一级目录名称 ， 比如  abc/def.pdf  ，需要去掉文件名中的目录
                    if( fileName.indexOf("/")>=0)
                    {
                        fileName=  fileName.substring( fileName.lastIndexOf("/")+1);
                    }

                    String t[] = StringUtils.split(fileName, ".");
                    extName = t.length >= 2 ? t[t.length - 1] : "";

                    if (fileTypeList.size() == 0 || fileTypeList.contains("*") || fileTypeList.contains("*.*") || fileTypeList.contains(extName.toLowerCase().trim()))
                    {

                    }
                    else
                    {

                        //  throw new Exception("不允许上传" + extName + "类型文件");
                    }

                    savedFile = path + DataStoreFactory.newLongID2String() + "." + extName;
                    FF.log("保存为临时文件 " + savedFile);
                    fi.write(new File(savedFile));//临时文件
                }


                IFileServer fileServer = getInstance(serverIndex);

                //2023.11.28 增加，如果指定了objectName 那么就使用指定的名称
                if (objectName.equalsIgnoreCase(""))
                {
                    if (autoRename)
                    {
                        objectName = DataStoreFactory.newLongID2String(); //重命名
                    }
                    else
                    {
                        objectName = fileName;
                    }
                }

                //可能指定的objectName中已经包含了 扩展名，那么就不需要再拼上扩展名了
                if (!extName.isEmpty() && !objectName.toLowerCase().endsWith(extName.toLowerCase()))
                {
                    objectName += "." + extName;

                }

                String tempFileName2 = path + "bak_" + objectName;
                FF.log("文件克隆一份：" + tempFileName2);
                FF.fileCopy(savedFile, tempFileName2, true);//复制一份
                FF.log("文件尺寸检测 ");
                //文件大小控制
                if (imageNeedCompress && isImageCanResize(extName))
                {
                    if (imgResize(new File(savedFile), imageMaxWidthOrHeight))
                    {
                        //如果调整文件后反而文件更大了，那么放弃调整，恢复成备份的文件
                        if (FF.fileSize(tempFileName2) < FF.fileSize(savedFile))
                        {
                            FF.log("调整后，文件反而更大了，放弃调整，恢复原文件");
                            FF.fileCopy(tempFileName2, savedFile, true); //覆盖
                        }

                        FF.log("已自动调整图片的宽度或高度不超过" + imageMaxWidthOrHeight + "px");

                    }
                    else
                    {
                        FF.log("无需调整大小");
                    }

                }

                FF.log("文件水印检测 ");
                //水印的支持
                if (isImageCanResize(extName))
                {

                    if (js.has("watermark"))
                    {
                        JSONArray watermarkArray = null;
                        Object v = js.get("watermark", null);
                        if (v != null)
                        {
                            if (v instanceof JSONObject)
                            {
                                watermarkArray = new JSONArray();
                                watermarkArray.put(v);

                            }
                            if (v instanceof JSONArray)
                                watermarkArray = (JSONArray) v;
                        }

                        if (watermarkArray != null)
                        {

                            String tempFileName3 = path + "watermark_" + objectName;
                            FF.log("打水印：" + tempFileName3);
                            ImageWaterMark.addWaterMark(savedFile, tempFileName3, watermarkArray);
                            if (FF.fileExists(tempFileName3)) savedFile = tempFileName3;
                        }
                    }
                }


                FF.log("文件保存 ");

                saveLogResult = upload(subPath, //要上传到服务器的哪个目录
                                       objectName,
                                       logTable, dbpool, data,
                                       new File(savedFile), //要上传的文件对象
                                       user.getId(), user.getShowName(),
                                       corporationid,
                                       groupName,
                                       fileIndex,
                                       fileName, //不带路径的文件原名称
                                       "",//bucketName,
                                       "", //thumbnailBucketName,
                                       tableName, gguid, maxThumbnailSize,
                                       serverIndex, uniqueKey);


                //删除临时文件
                FF.delTree(path);

                FF.log("临时文件已删除");

                if (!uniqueKey.isEmpty())
                {
                    //已经上传成功后， 传记保存久一点，避免重复上传
                    AppCache.setCache(CS_PREFIX_FILE_UNIQUECHECK + uniqueKey, saveLogResult.toString(), true, expireSeconds * 5);
                }

                if (responseType.equalsIgnoreCase("JSON"))
                {
                    if (jsonRet == null) // jsonRet 为了兼容以前的单文件上传结果，所以它就是第一个上传的文件结果，同时增加一个items，存放所有的文件上传结果
                    {
                        jsonRet = new JSONObject(saveLogResult.toString()); //克隆一份，不能直接等于，因为下面的items 中又加入了 safeLogResult,如果直接赋值，会出现循环

                        jsonRet.put("items", new JSONArray());
                        jsonRet.getJSONArray("items").put(saveLogResult);

                    }
                    else
                    {
                        jsonRet.getJSONArray("items").put(saveLogResult);
                    }

                    ret = jsonRet.toString();
                }
                else
                {

                    ret = " parent.workBookUploadFileCallback( " + saveLogResult + " ) ;";
                }

                //2020.06.10 改成可以上传多个
                // break; //只上传一个

            }


        } catch (UploadedException ue)
        {
            FF.log("上传情况: " + ue.getMessage());
            //到这里，实际上是返回成功，因为 ue.getMessage 得到的就成功上传的返回信息
            //为什么会出现这种情况 ：
            // 客户端上传文件，服务器保存文件到文件服务器中，并记录日志， 就修过程可能有会因大量文件上传，而导致某些文件耗时过多，
            //此时客户端会因超时而返回异常，那么客户端可能会再次尝试上传，但是服务端可能随后就上传成功了，此时通过 uniqueKey 获取了上传成功的信息，于是就把此信息直接返回给客户端，
            // 而不是重复上传
            ret = ue.getMessage();


        } catch (Exception e)
        {
            FF.log("上传异常：" + FF.exceptionMessage(e));

            ret = " toastr.error('" + e.getMessage() + "');";

        } finally
        {

            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");

            //2020.04.06 增加对 直接返回 JSON数据的支持
            if (responseType.equalsIgnoreCase("JSON"))
            {

                response.getOutputStream().write(ret.getBytes("UTF-8"));
                return;
            }

            PrintWriter out = response.getWriter();
            output(out, ret);
            out.flush();
            out.close();

        }
    }

    //仅支持png , jpeg 的文件resize ，其它不支持
    private boolean isImageCanResize(String extName)
    {
        if (extName.equalsIgnoreCase("jpg")) return true;
        if (extName.equalsIgnoreCase("jpeg")) return true;
        if (extName.equalsIgnoreCase("png")) return true;
        if (extName.equalsIgnoreCase("gif")) return true;
        if (extName.equalsIgnoreCase("bmp")) return true;

        return false;

    }

    /**
     * 检测图片大小 ，如果超过maxK (单位k),则自动缩小
     *
     * @param fileName
     * @param maxK
     */
    private boolean imgResize(File file, int targetSize)
    {
        //img相关
        FF.log(file + "检测size");
        ImageInfo ii = getImageInfo(file);
        FF.log("检测size：" + ii.height + "x" + ii.width);

        if (!ii.type.isEmpty())
        {
            if (ii.height < targetSize && ii.width < targetSize)
            {
                targetSize = Math.max(ii.height, ii.width);
            }

            //把图片 resize后，放到缩略图目录中
            BufferedImage src = null;
            try
            {
                src = ImageIO.read(file);

                src = Scalr.resize(src, targetSize);


                ImageIO.write(src, ii.type, file);
                FF.log(file + "压缩成功");
            } catch (Exception e)
            {

                String err = file + "压缩失败 " + e.getMessage();
                FF.log(err);
                return false;
            }
            return true;
        }
        return false;
    }


    public void output(PrintWriter out, String s)
    {
        out.write("<html><head>");
        out.write("<meta http-equiv=\"Content-Language\" content=\"UTF-8\">");
        out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.write("</head>");
        out.write("<script language=\"javascript\">\n");
        out.write(" window.onload = function()\n");
        out.write("{\n");
        out.write(s + "  \n");
        out.write("}\n");
        out.write("</script>");
        out.write("</html> ");
    }


    public static JSONObject upload(String subPath, //要上传到服务器的哪个目录
                                    String objectName,
                                    String logTable, //上传日志 保存到哪个表
                                    String dbpool,  //上传日志 在哪个数据库连接中
                                    JSONObject data,//额外需要保存的数据
                                    File file, //要上传的本地文件对象
                                    int userid, String userShowName, //上传人信息
                                    String corporationid,
                                    String groupName, //上传的文件的groupName 分组信息
                                    int fileIndex, //本文件是分组下的第几个文件，（从1开始计数)
                                    String fileName, //不带路径的文件原名称，便于下载的的文件取名
                                    String bucketName, // 存储桶
                                    String thumbnailBucketName,//缩略图的存储桶
                                    String tableName, //本文件关联的单据表名称
                                    String gguid, //本文件关联的单据的id
                                    int maxThumbnailSize, //缩略图最大尺寸
                                    int serverIndex //哪个文件服务器
            , String uniqueKey
    ) throws Exception
    {


        IFileServer fileServer = getInstance(serverIndex);

        String path = App.FileRoot + "/FileServer/temp/";

        //
        FF.log("临时目录：" + path);
        FF.MkDirs(path);

        String t[] = StringUtils.split(fileName, ".");
        String extName = t.length >= 2 ? t[t.length - 1] : "";

        String thumbnailObjectName = "";
        //可能指定了objectName ,也可能没有指定 ，没有指定时，自动生成一个文件名，
        if (objectName.equalsIgnoreCase(""))
        {
            objectName = DataStoreFactory.newLongID2String(); //重命名
            thumbnailObjectName = objectName + "_thumbnail"; //缩略图重命名
        }
        else
        {
            int p = objectName.lastIndexOf(".");
            if (p > 0)
            {
                thumbnailObjectName = objectName.substring(0, p) + "_thumbnail"; //缩略图重命名
            }
            else
            {
                thumbnailObjectName = objectName + "_thumbnail"; //缩略图重命名
            }
        }
        if (!extName.isEmpty())
        {
            if (!objectName.toLowerCase().endsWith(extName.toLowerCase())) objectName += "." + extName;
            if (!thumbnailObjectName.toLowerCase().endsWith(extName.toLowerCase()))
                thumbnailObjectName += "." + extName;
        }


        //完整的对象名
        objectName = subPath + objectName;
        thumbnailObjectName = subPath + thumbnailObjectName;

        String tempFileName = file.getPath();
        JSONObject uploadResult = null;
        if (FileServer.isFileNeedEncrypt(serverIndex))
        {
            String key = FileServer.getFileEncryptKey(serverIndex);
            String[] s = FF.splitFileName(tempFileName);
            String tempFileNameEncrypted = s[0] + "/" + s[1] + DataStoreFactory.newLongID2String() + "." + s[2];

            try (
                    FileInputStream fis = new FileInputStream(tempFileName);
                    FileOutputStream fos = new FileOutputStream(tempFileNameEncrypted)
            )
            {
                FileCryptoUtil.encryptFile(fis, fos, key);
                fis.close();
                fos.close();
                uploadResult = fileServer.upload(objectName, fileName, tempFileNameEncrypted);
            } catch (Exception e)
            {
                throw e;
            }


        }
        else
        {
            uploadResult = fileServer.upload(objectName, fileName, tempFileName);

        }

        String url_img = uploadResult.getString("url", "");
        objectName = uploadResult.getString("objectname", objectName); //可能在上传时更改了名称

        FF.log("上传结果：" + url_img);
        JSONObject saveLogResult = saveLog(path, logTable, dbpool, corporationid, data,
                                           file, userid, userShowName,
                                           url_img,
                                           groupName,
                                           fileIndex,
                                           fileName,
                                           bucketName,
                                           objectName, //拼成完整的objectName
                                           thumbnailBucketName,
                                           thumbnailObjectName,  //拼成完整的objectName
                                           tableName, gguid, file.length(),
                                           maxThumbnailSize,
                                           fileServer,
                                           serverIndex, uniqueKey);

        // FF.delay(10000); //模拟大文件上传，10秒
        return saveLogResult;


    }

    /**
     * @param rootPath
     * @param logTable            上传记录在哪个表中
     * @param dbpool              logTable在哪个连接池中
     * @param data                更多数据
     * @param file                文件
     * @param userid
     * @param userShowName
     * @param groupName           文件分组
     * @param fileIndex           在分组中的序号
     * @param fileName            文件名
     * @param bucketName          扩展名
     * @param objectName          保存到文件服务器中的名称
     * @param thumbnailBucketName 缩略图所在的文件桶
     * @param thumbnailObjectName 缩略图对象名
     * @param tableName           本文件相关联的业务数据表名称
     * @param gguid               相关联的gguid
     * @param fileSize            文件大小
     * @param maxThumbnailSize    缩回图尺寸
     * @param fileServer          文件服务器对象
     * @param serverIndex         文件服务器序号
     * @return
     */
    public static JSONObject saveLog(String rootPath, String logTable, String dbpool, String corporationid,
                                     JSONObject data, File file,
                                     int userid, String userShowName,
                                     String url_img,
                                     String groupName,
                                     int fileIndex,
                                     String fileName, String bucketName, String objectName,
                                     String thumbnailBucketName, String thumbnailObjectName,
                                     String tableName, String gguid, long fileSize, int maxThumbnailSize,
                                     IFileServer fileServer, int serverIndex, String uniqueKey)
    {

        long d1 = System.currentTimeMillis();
        try
        {


            String con = DBF.getMapedName(dbpool, corporationid);
            FF.log("日志保存到连接池：" + con + " 中的" + logTable + " 表中,关联gguid=" + gguid);
            String mapedDSN = DBF.getMapedName(dbpool, corporationid); //用于异步更新单据表中的attachmentcount 字段

            //2020.04.06 增加自动建表
            if (!FF.tableExists(con, logTable))
            {
                FF.log(logTable + "不存在，自动创建...");
                String path = App.AppRoot + "/template";
                DBInit.InitTable(con, path, logTable, "app_fileupload.sql", null, null, false);
            }

            //2024.11.21增加了ocr结果字段
            //FF.SafeExecute(con, " alter table " + logTable + "  add ocr  varchar(2000) null ");
            //FF.SafeExecute(con, " alter table " + logTable + "  add uniquekey  varchar(400) null ");


            DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + logTable);


            //https://blog.csdn.net/sun11462/article/details/81747717 读取图片的EXIF信息

            if (ds.getColumnCount() == 0)
            {
                throw new Exception(logTable + "没有创建成功");
            }

            ds.setUpdateProperty(logTable, "id", "*", "id");
            int row = ds.insertRow(0);
            ds.setValue(row, "id", DataStoreFactory.newLongID2String());
            ds.setValue(row, "userid", userid);
            ds.setValue(row, "usershowname", userShowName);
            ds.setValue(row, "uploadtime", new Date());
            ds.setValue(row, "filename", fileName);
            //本系统并不限制必须唯一，这个字段留给开发者自行处理
            ds.setValue(row, "uniquekey", uniqueKey);

            ds.setValue(row, "serverindex", serverIndex);
            ds.setValue(row, "corporationid", corporationid);

            ds.setValue(row, "groupname", groupName);
            ds.setValue(row, "fileindex", fileIndex);
            ds.setValue(row, "url_img", url_img);
            ds.setValue(row, "url", url_img);


            String t[] = StringUtils.split(fileName, ".");

            String extName = t.length >= 2 ? t[t.length - 1] : "";


            ds.setValue(row, "fileextname", extName);

            ds.setValue(row, "objectname", objectName);
            ds.setValue(row, "bucketname", bucketName);
            ds.setValue(row, "filesize", fileSize);
            ds.setValue(row, "filesizetip", FF.fileSizeTip(fileSize));
            ds.setValue(row, "tablename", tableName);
            ds.setValue(row, "gguid", gguid);

            ds.setValue(row, "uploaddate", new Date());

            //img相关
            ImageInfo ii = getImageInfo(file);

            if (!ii.type.isEmpty())  //图片
            {


                ds.setValue(row, "imagewidth", ii.width);
                ds.setValue(row, "imageheight", ii.height);

                int thumbnailwidth = maxThumbnailSize;
                int thumbnailheigh = maxThumbnailSize;

                if (ii.width > ii.height)
                {
                    thumbnailheigh = (int) (ii.height * maxThumbnailSize * 1.0 / ii.width);
                }
                else
                {
                    thumbnailwidth = (int) (ii.width * maxThumbnailSize * 1.0 / ii.height);
                }

                ds.setValue(row, "thumbnailwidth", thumbnailwidth);
                ds.setValue(row, "thumbnailheight", thumbnailheigh);

                ds.setValue(row, "thumbnailbucketname", thumbnailBucketName);
                ds.setValue(row, "thumbnailobjectname", thumbnailObjectName);

                //把图片 resize后，放到缩略图目录中
                BufferedImage src = null;

                try
                {
                    src = ImageIO.read(file);

                    src = Scalr.resize(src, Scalr.Method.AUTOMATIC, Scalr.Mode.FIT_TO_WIDTH, thumbnailwidth, thumbnailheigh);

                    //thumbnailObjectName中已经包含了目录，所以在生成临时文件时，需要把目录去掉，只留下文件名
                    String tempThumbnailObjectName = thumbnailObjectName;
                    int p = tempThumbnailObjectName.lastIndexOf("/");
                    if (p > 0) tempThumbnailObjectName = tempThumbnailObjectName.substring(p + 1);
                    File tempThumbnailFile = new File(rootPath, tempThumbnailObjectName);
                    ImageIO.write(src, ii.type, tempThumbnailFile);  //缩略图复制

                    //上传缩略图
                    JSONObject uploadResult = null;
                    if (FileServer.isFileNeedEncrypt(serverIndex))
                    {
                        String key = FileServer.getFileEncryptKey(serverIndex);
                        String[] s = FF.splitFileName(tempThumbnailFile.getPath());
                        String tempFileNameEncrypted = s[0] + "/" + s[1] + DataStoreFactory.newLongID2String() + "." + s[2];

                        try (
                                FileInputStream fis = new FileInputStream(tempThumbnailFile);
                                FileOutputStream fos = new FileOutputStream(tempFileNameEncrypted)
                        )
                        {
                            FileCryptoUtil.encryptFile(fis, fos, key);
                            fis.close();
                            fos.close();

                            uploadResult = fileServer.upload(/*thumbnailBucketName,*/ thumbnailObjectName, fileName, tempFileNameEncrypted);
                        } catch (Exception e)
                        {
                            throw e;
                        }
                    }
                    else
                    {

                        //上传缩略图
                        uploadResult = fileServer.upload(/*thumbnailBucketName,*/ thumbnailObjectName, fileName, tempThumbnailFile.getPath());
                    }
                    ds.setValue(0, "url_thumbnail", uploadResult.getString("url", ""));
                    //可能会在上传时更新objectName，所以需要再取一次
                    thumbnailObjectName = uploadResult.getString("objectname", thumbnailObjectName);
                    ds.setValue(row, "thumbnailobjectname", thumbnailObjectName);

                    //删除缩略图
                    tempThumbnailFile.delete();
                } catch (Exception e)
                {
                    String err = file + " 在创建缩略图时失败：" + e.getMessage();
                    FF.log(err);
                    return new JSONObject().put("success", false).put("message", err);
                }


            }

            //附加数据填入
            Iterator<String> it = data.getMap().keySet().iterator();
            while (it.hasNext())
            {
                String col = it.next();
                String value = data.getString(col, "");
                if (ds.col2Index(col) >= 0) ds.setValue(0, col, value);
            }

            if (!ds.update(true)) FF.log(ds.getErrorMessage());

            //2021.08.22 上面的 ds.update已成功，即文件上传成功且日志记录成功，但是偶发出现 下面的Exception ，
            //  那就只能怀疑是下面的一段引发 异常。
            //  当异常发生后， 返回  success:false  , 前端认为没有上传成功，当再次尝试重传时，前面的从缓存信息中获取状态，得到 success:false ,于是允许重新上传，此时， 就发生了上传重复
            // 所能把下面的言辞处理改成同步处理后，异常消息，但是，出于性能考虑，还是要异步，所以再套一层异常处理
            try
            {
                DelayRun.delayRun(tableName + "." + gguid, new TimerTask()
                {
                    @Override
                    public void run()
                    {

                        // 同步更新  UploadFileForLocal
                        int n = FF.getIntFromSQL(mapedDSN, " select count(*) from  " + logTable + "  where tablename='" + tableName + "'  and  gguid='" + gguid + "'  ");
                        //  单据表一定与附件日志 表是同一个数据库 ,
                        FF.SafeExecute(mapedDSN, " update " + tableName + " set   attachmentcount = " + n + " where  id='" + gguid + "' ");

                    }
                }, 1000); //延迟5秒再更新
            } catch (Exception e)
            {

            }

            return new JSONObject(ds.getJSONRow(0, true)).put("success", true);
        } catch (Exception e)
        {

            String err = "上传文件保存日志发生异常：" + e.getClass().getName() + "   " + FF.exceptionMessage(e);
            FF.log(err);

            return new JSONObject().put("success", false).put("message", err);
        } finally
        {

            long d2 = System.currentTimeMillis();
            FF.log(fileName + "上传文件日志保存耗时：" + (d2 - d1) + " ms");
        }


    }


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }


    public static ImageInfo getImageInfo(String fileName)
    {
        return getImageInfo(new File(fileName));
    }

    public static ImageInfo getImageInfo(File o)
    {

        ImageInfo ret = new ImageInfo();
        try
        {
            FF.log("获取文件：" + o.getPath());


            // Create an image input stream on the image
            ImageInputStream iis = ImageIO.createImageInputStream(o);

            // Find all image readers that recognize the image format
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext())
            {
                // No readers found
                return ret;
            }

            // Use the first reader
            ImageReader reader = (ImageReader) iter.next();
            reader.setInput(iis);

            // Return the format name
            ret.type = reader.getFormatName();

            //下面得不到，原因不明，算了，换个办法
            ret.height = reader.getHeight(0);
            ret.width = reader.getWidth(0);

            // Close stream
            iis.close();




        } catch (IOException e)
        {
            FF.log("读取图片信息异常：" + FF.exceptionMessage(e));
        }

        return ret;
    }
}
