package dfs;

import config.CacheConfig;
import io.minio.MinioClient;
import org.json.JSONArray;
import org.json.JSONObject;
import util.CnToSpell;
import util.DirCopyUtil;
import util.FF;
import util.URLUtil;
import webApp.App;

import java.io.File;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;

public class ProxyFileServer implements IFileServer
{

    int serverIndex;

    public ProxyFileServer(int serverIndex)
    {
        this.serverIndex = serverIndex;
    }

    @Override
    public String getBucketName()
    {
        //2023.06.08 为了安全，避免误设置，导致自动删除文件
        if (serverIndex == 0) return "autoDeleteAfterOneHour";
        String t = "";
        return t;

    }

    @Override
    public int getImageMaxWidthOrHeight()
    {
       return  0;
    }

    public String getAPPFileRoot()
    {
        return "";

    }

    @Override
    public JSONArray getFileList(String path)
    {

        JSONArray ret = new JSONArray();


        return ret;

    }

    public static String fileSize(File f)
    {
        return "";

    }

    public static String fileSize(long  fl)
    {

        return "";

    }


    @Override
    public String mkdir(String path, String subPath)
    {

        return "";

    }


    @Override
    /**
     * 如果源文件与目标文件就是同一个，那么不需要复制
     */
    public JSONObject upload(String objectName, String showName, String file) throws Exception
    {
        String bucketName = getBucketName();
        JSONObject ret = new JSONObject().put("success", true);
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String root = getAPPFileRoot();
        String toFile = FF.pathJoin(FF.pathJoin(root, bucketName), objectName);
        String toPath = toFile.substring(0, toFile.lastIndexOf("/"));
        FF.MkDirs(toPath);
        File f = new File(file);
        if (!file.equalsIgnoreCase(toFile))  //有可能源文件与目标文件是同一个文件，那么就不用复制了
        {
            //2023.11.29 增加防止覆盖的检验， 不管上传什么文件， 不管是否是指定的objectName还是随机生成的 objectName都检测一下 ，避免覆盖
            if ( objectExists( objectName) )  //如果文件已存在，那么自动改名
            {
                String name0 = objectName;
                String extName = "";
                if (name0.indexOf(".") > 0)
                {
                    int p = name0.lastIndexOf(".");
                    name0 = name0.substring(0, p);
                    extName = objectName.substring(p);
                }
                int i = 0;
                while (true)
                {
                    i++;
                    objectName = name0 + "-" + i + extName;
                    if (!objectExists(objectName))
                    {
                        toFile = FF.pathJoin(FF.pathJoin(root, bucketName), objectName);
                        break;
                    }
                    else
                    {
                        FF.log(toPath + "/" + objectName + "已存在， 系统自动重新生成一个文件名，避免覆盖");
                    }
                }

            }
            // 保证不要覆盖文件
            DirCopyUtil.copy(f, new File(toFile), true);
        }
        String shortName = f.getName();
        if (showName != null && !showName.isEmpty()) shortName = showName;
        shortName = URLEncoder.encode(shortName, "UTF-8");

        String url = "fileServer?bucketName=" + bucketName + "&objectName=" + objectName + "&fileName=" + shortName + "&serverIndex=" + serverIndex + "&action=view";
        //url= URLUtil.URLEncoder(url); 不要整体转义，只要把shortName转义就好了
        ret.put("url", url);

        //下面的参数是为了着返回值兼容文件上传的返回结果
        ret.put("url_img", url);
        ret.put("serverindex", this.serverIndex);
        ret.put("bucketname", this.getBucketName());
        ret.put("objectname", objectName);
        ret.put("filename", showName);

        return ret;
    }


    /**
     * 根据  bucketName ,  objectName 定位文件名
     *
     * @param bucketName
     * @param objectName
     * @return
     * @throws Exception
     */
    public String download(String objectName) throws Exception
    {

        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String proxy_address = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/proxy_address", "");
        String proxy_serverIndex = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/proxy_serverIndex", "");

        String toFile = getDownloadToLocalFileName(objectName);
        String[] t= FF.splitFileName(toFile);
        String shortName= t[1];
        if(!t[2].isEmpty() ) shortName+="."+t[2];
        FF.makeSurePathOfFileExists(toFile); //确保文件目录一定存在
        //如果有缓存的文件，那么不需要再下载了 ，之所以可以这么处理， 是因为，这个上传的文件，不存在更改的，只会是删除，重新上传
        //所以如果本地有对应的下载好的缓存文件，那么不存在与OSS上不一至的情况。
        if (FF.fileExists(toFile)) return toFile;

        try
        {
            String url = proxy_address;
            if( !url.endsWith("/")) url=url+"/";
            url = url + "fileServer?&objectName=" + objectName + "&serverIndex=" + proxy_serverIndex + "&fileName="+ shortName+ "&action=download";
            url = URLUtil.URLEncoder(url);
            FF.downloadFile(url, t[0],shortName);

            FileServer.checkDownloadFileValid(toFile);

            return toFile;
        } catch (Exception e)
        {
            FF.log(e);
            throw e;

        }
    }

    @Override
    public String getDownloadToLocalFileName(String objectName)
    {

        String t = objectName;
        int p = t.lastIndexOf("/");
        if (p > 0) t = t.substring(p + 1);
        String toFile = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/" + t; // 去掉子目录 ，放到autoDeleteAfterOneHour 便于删除维护
        return toFile;
    }

    @Override
    public boolean delete(String objectName)
    {

        return true;
    }


    @Override
    public String rename(String objectName, String newName)
    {


        return "";
    }

    public boolean objectExists(String objectName)
    {
     return  false;
    }

    public String getDomain()
    {

        return "";
    }
}
