package dfs;

import config.CacheConfig;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import util.CnToSpell;
import util.DirCopyUtil;
import util.FF;
import util.URLUtil;
import webApp.App;

import java.io.File;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;

public class InnerFileServer implements IFileServer
{

    int serverIndex;

    public InnerFileServer(int serverIndex)
    {
        this.serverIndex = serverIndex;
    }

    @Override
    public String getBucketName()
    {
        //2023.06.08 为了安全，避免误设置，导致自动删除文件
        if (serverIndex == 0) return "autoDeleteAfterOneHour";

        String t = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/inner_bucket", (serverIndex == 0 ? "autoDeleteAfterOneHour" : "default"));
        return t;

    }

    @Override
    public int getImageMaxWidthOrHeight()
    {
        String t = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/imageMaxWidthOrHeight", "4096");
        int ret = FF.String2Int(t);
        if (ret == 0) ret = 4096;
        return ret;
    }

    public String getAPPFileRoot()
    {
        return FF.pathJoin(App.FileRoot, "FileServer/");

    }

    @Override
    public JSONArray getFileList(String path)
    {
        String bucketName = getBucketName();
        JSONArray ret = new JSONArray();
        if (path.startsWith("/")) path = path.substring(1);

        if (!path.endsWith("/")) path = path + "/";

        String root = FF.pathJoin(getAPPFileRoot(), bucketName);
        String fullPath = FF.pathJoin(root, path);

        FF.log(fullPath);

        File[] files = new File(fullPath).listFiles();

        List<File> list;

        if (files == null)
        {

            list = new ArrayList<>();

        }
        else
        {

            list = Arrays.asList(files);

        }

        FF.log("有" + list.size() + "个文件或目录 ，现在排序");

        Collections.sort(list, new Comparator<File>()
        {

            @Override
            public int compare(File o1, File o2)
            {

                if (o1.isDirectory() && o2.isFile())

                    return -1;


                if (o1.isFile() && o2.isDirectory())

                    return 1;

                String name1 = o1.getName().toUpperCase();

                char c1 = name1.toCharArray()[0];

                String name11 = name11 = CnToSpell.getFullSpell(name1);

                if (c1 >= 0x4E00 && c1 <= 0x9FA5)
                {

                    name1 = "." + name11;

                }
                else if (c1 < 48)
                {

                    name1 = "{" + name11;

                }
                else if (c1 > 57 && c1 < 65)
                {

                    name1 = "{" + name11;

                }

                String name2 = o2.getName().toUpperCase();

                char c2 = name2.toCharArray()[0];

                String name22 = CnToSpell.getFullSpell(name2);

                if (c2 >= 0x4E00 && c2 <= 0x9FA5)
                {

                    name2 = "." + name22;

                }
                else if (c2 < 48)
                {

                    name2 = "{" + name22;

                }
                else if (c2 > 57 && c2 < 65)
                {

                    name2 = "{" + name22;

                }

                return name1.compareTo(name2);

            }

        });

        FF.log("排序完成");

        for (int i = 0; i < list.size(); i++)
        {
            File f = list.get(i);

            String extName = f.getName();
            FF.log(extName);
            if (extName.indexOf(".") > 0)
            {
                extName = extName.substring(extName.lastIndexOf(".") + 1);
            }
            else
            {
                extName = "";
            }

            if (f.isDirectory()) extName = "目录";

            FF.log(extName);


            JSONObject one = new JSONObject();
            one.put("parentPath", fullPath);
            one.put("name", f.getName());
            one.put("type", extName);
            one.put("fullName", path + f.getName());
            one.put("isDir", f.isDirectory());
            one.put("lastModified", FF.get_yyyyMMdd_HHmm_FormatedDate(new Date(f.lastModified())));
            one.put("lastModifiedDate",   f.lastModified() );

            one.put("fileSize", fileSize(f));

            FF.log(one.toString());
            ret.put(one);


        }

        return ret;

    }

    public static String fileSize(File f)
    {
        double fl = f.length();
        //碰到一个包含巨多小文件的目录，在计算所有文件大小时， 搞太久，以至于以为程序异常了
        if (f.isDirectory()) return ""; // fl=  FileUtils.sizeOfDirectory( f); 如果文件很多，那么就死了

        DecimalFormat df = new DecimalFormat("###,###,###.0");
        DecimalFormat df2 = new DecimalFormat("###,###,###");

        String size;
        if (fl < 1024)
        {
            size = fl + "字节";

        }
        else if (fl < 1024 * 1024)
        {

            size = df.format(fl / 1024.0) + "KB";
        }
        else
        {
            size = df.format(fl / (1024.0 * 1024.0)) + "MB";
        }

        return size;

    }

    public static String fileSize(long  fl)
    {

        //碰到一个包含巨多小文件的目录，在计算所有文件大小时， 搞太久，以至于以为程序异常了


        DecimalFormat df = new DecimalFormat("###,###,###.0");
        DecimalFormat df2 = new DecimalFormat("###,###,###");

        String size;
        if (fl < 1024)
        {
            size = fl + "字节";

        }
        else if (fl < 1024 * 1024)
        {

            size = df.format(fl / 1024.0) + "KB";
        }
        else
        {
            size = df.format(fl / (1024.0 * 1024.0)) + "MB";
        }

        return size;

    }


    @Override
    public String mkdir(String path, String subPath)
    {
        String bucketName = getBucketName();
        JSONArray ret = new JSONArray();
        if (path.startsWith("/")) path = path.substring(1);

        if (!path.endsWith("/")) path = path + "/";

        String root = getAPPFileRoot();
        String fullPath = FF.pathJoin(FF.pathJoin(root, bucketName), FF.pathJoin(path, subPath));

        FF.MkDirs(fullPath);
        return "";

    }


    @Override
    /**
     * 如果源文件与目标文件就是同一个，那么不需要复制
     */
    public JSONObject upload(String objectName, String showName, String file) throws Exception
    {
        String bucketName = getBucketName();
        JSONObject ret = new JSONObject().put("success", true);
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String root = getAPPFileRoot();
        String toFile = FF.pathJoin(FF.pathJoin(root, bucketName), objectName);
        String toPath = toFile.substring(0, toFile.lastIndexOf("/"));
        FF.MkDirs(toPath);
        File f = new File(file);
        if (!file.equalsIgnoreCase(toFile))  //有可能源文件与目标文件是同一个文件，那么就不用复制了
        {
            //2023.11.29 增加防止覆盖的检验， 不管上传什么文件， 不管是否是指定的objectName还是随机生成的 objectName都检测一下 ，避免覆盖
            if ( objectExists( objectName) )  //如果文件已存在，那么自动改名
            {
                String name0 = objectName;
                String extName = "";
                if (name0.indexOf(".") > 0)
                {
                    int p = name0.lastIndexOf(".");
                    name0 = name0.substring(0, p);
                    extName = objectName.substring(p);
                }
                int i = 0;
                while (true)
                {
                    i++;
                    objectName = name0 + "-" + i + extName;
                    if (!objectExists(objectName))
                    {
                        toFile = FF.pathJoin(FF.pathJoin(root, bucketName), objectName);
                        break;
                    }
                    else
                    {
                        FF.log(toPath + "/" + objectName + "已存在， 系统自动重新生成一个文件名，避免覆盖");
                    }
                }

            }
            // 保证不要覆盖文件
            DirCopyUtil.copy(f, new File(toFile), true);
        }
        String shortName = f.getName();
        if (showName != null && !showName.isEmpty()) shortName = showName;
        shortName = URLEncoder.encode(shortName, "UTF-8");

        String url = "fileServer?bucketName=" + bucketName + "&objectName=" + objectName + "&fileName=" + shortName + "&serverIndex=" + serverIndex + "&action=view";
        //url= URLUtil.URLEncoder(url); 不要整体转义，只要把shortName转义就好了
        ret.put("url", url);

        //下面的参数是为了着返回值兼容文件上传的返回结果
        ret.put("url_img", url);
        ret.put("serverindex", this.serverIndex);
        ret.put("bucketname", this.getBucketName());
        ret.put("objectname", objectName);
        ret.put("filename", showName);

        return ret;
    }


    /**
     * 根据  bucketName ,  objectName 定位文件名
     *
     * @param bucketName
     * @param objectName
     * @return
     * @throws Exception
     */
    public String download(String objectName) throws Exception
    {
        String bucketName = getBucketName();
        String toFile = getDownloadToLocalFileName(objectName);
        if (!FF.fileExists(toFile)) throw new Exception("文件不存在");
        return toFile;
    }

    @Override
    public String getDownloadToLocalFileName(String objectName)
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String toFile = FF.pathJoin(FF.pathJoin(getAPPFileRoot(), bucketName), objectName);
        return toFile;
    }

    @Override
    public boolean delete(String objectName)
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String root = getAPPFileRoot();
        String path = FF.pathJoin(root, bucketName);

        String sourceFile = FF.pathJoin(path, objectName);

        if (!FF.fileExists(sourceFile)) return true;
        FF.deleteFile(sourceFile);
        return true;
    }


    @Override
    public String rename(String objectName, String newName)
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String root = getAPPFileRoot();
        String path = FF.pathJoin(root, bucketName);

        String sourceFile = FF.pathJoin(path, objectName);
        String destFile = sourceFile.substring(0, sourceFile.lastIndexOf("/") + 1);
        destFile = destFile + newName;

        if (!FF.fileExists(sourceFile)) return "文件不存在";

        File f = new File(sourceFile);
        if (f.renameTo(new File(destFile))) return "";

        return "重命名失败";
    }

    public boolean objectExists(String objectName)
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String root = getAPPFileRoot();
        String path = FF.pathJoin(root, bucketName);

        String sourceFile = FF.pathJoin(path, objectName);

        return FF.fileExists(sourceFile);
    }

    public String getDomain()
    {

        return "";
    }
}
