package dfs;

import org.apache.commons.fileupload.FileItem;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;

public interface IFileServer
{

    /**
     *
     * @param bucketName
     * @param objectName
     * @param file  要上传的文件
     * @return
     */
    public JSONObject upload( String objectName , String showName, String file ) throws  Exception;


    /**
     *
     * @param bucketName
     * @param objectName
     * @return
     * @throws Exception
     */
    public String  download(  String objectName  ) throws Exception;

    public JSONArray getFileList(String path) ;

    //创建子目录
    public String mkdir(String path , String subPath);

    public String  getDownloadToLocalFileName( String objectName);

    /**
     *
      * @param bucketName
     * @return
     */
    public String  getBucketName();


    public  boolean  delete( String objectName);

    /**
     * 重命名
     * @param objectName
     * @param newName
     * @return
     */
    public String rename(String objectName ,String newName);

    /**
     * 得到图片最大的尺寸，超过此尺寸，则自动缩小
     * @return
     */
    public int  getImageMaxWidthOrHeight();

    public boolean objectExists(String objectName);

    public String  getDomain();

}
