package dfs;

import app.User;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import pdf.PdfUtil;
import rbac.URLFilter;
import util.*;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.LinkedHashMap;

@WebServlet(name = "share", urlPatterns = "/share")
public class FileShared extends HttpServlet
{


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");


        try (
                BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
        )
        {

            res.setContentType("text/html;charset = UTF-8");//很重要
            res.setCharacterEncoding("UTF-8");


            String id = req.getQueryString();
            if (id == null) id = "err";

            DataStore ds = DataStoreFactory.newDataStore("", "select *  from app_urlshare where id=" + id);
            ds.setUpdateProperty("app_urlshare", "id", "*", "id");
            ds.retrieve();
            if (ds.getRowCount() == 0) throw new Exception("非法的共享地址");
            Date d1 = new Date();
            Date d2 = ds.getDate(0, "expirydate");
            int lc = ds.getInt(0, "limitcount");
            if (d2.getTime() < d1.getTime())
            {

                ds.deleteRow(0);
                ds.update(true);
                throw new Exception("共享地址已过期");
            }
            if (lc != -1)
            {
                int vc = ds.getInt(0, "visitedcount") + 1;
                if (vc > lc)
                {

                    ds.deleteRow(0);
                    ds.update(true);
                    throw new Exception("共享地址已达访问次数上限，禁止再访问");

                }
                else
                {
                    ds.setValue(0, "visitedcount", vc);
                    ds.update(true);
                }
            }
            String jumpTo = ds.getString(0, "url");

            String params = URLUtil.getParameterStringOfURL(jumpTo);
            LinkedHashMap<String, String> p1 = URLUtil.splitParameter(params);
            String fileName = URLDecoder.decode(FF.getStringFromMap(p1, "fileName", DataStoreFactory.newLongID2String()), "utf-8");

            String tempPath = App.FileRoot + "/FileServer/temp";
            FF.MkDirs(tempPath);
            // 在  https://archive.wiccloud.cn中测试 ， 会无法下载文件，原因不明，可能与 https 有关，太难折腾了，算了换一种办法，直接内部下载，而不是走url下载
            // FF.downloadFile(jumpTo, tempPath, fileName);
            // String fullName = tempPath + "/" + fileName;
            // if (!FF.fileExists(fullName)) throw new Exception("文件不存在");

            int serverIndex = FF.getIntFromMap(p1, "serverIndex", 1);
            String objectName = FF.getStringFromMap(p1, "objectName", "");

            IFileServer fs = FileServer.getInstance(serverIndex);
            if (fs == null) throw new Exception("serverIndex不合法");

            String fullName = fs.download(objectName);

            if (!FF.fileExists(fullName)) throw new Exception("文件不存在");

            String extName = "";
            int p = fileName.lastIndexOf(".");
            if (p > 0) extName = fileName.substring(p);
            String mimeType = req.getSession().getServletContext().getMimeType(extName);
            if (mimeType == null) mimeType = "";
            if (mimeType.isEmpty()) mimeType = "APPLICATION/OCTET-STREAM";


            res.setContentType(mimeType);

            //如果大于20，可能会问题

            //   if (fileName.length() > 20) fileName = fileName.substring(fileName.length() - 20, fileName.length());
            //	  这个很重要，不然文件名称会乱码  *2
            fileName = URLEncoder.encode(fileName, "UTF-8");
            //如果是预览，那么不要设置文件名称，不然就成了下载，而不是直接在浏览器中打开
            res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");


            try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(fullName)));)
            {
                int once = 32768;
                byte buffer[] = new byte[once];
                int actually = 0;

                while (true)
                {
                    actually = bis.read(buffer);
                    if (actually <= 0) break;
                    bos.write(buffer, 0, actually);

                }

                bis.close();
                bos.flush();
                bos.close();

                FF.log("下载文件完成");
            } catch (Exception e)
            {
                FF.log(FF.exceptionMessage(e));
            }
            //不需要删除 fullName ,因为如果是本地文件服务器，那么真不能删除 。如果是网络文件服务器，那么临时文件会自动删除


        } catch (Exception e)
        {

            //res.sendRedirect("../SystemTip.jsp?info="+  URLEncoder.encode("文件下载发生错误","UTF-8")  );
            //在之前，已经做了res.setHeader，bos.write等操作，此时出现异常可能是连接断开之类的异常，
            //那么在这个 exception 的处理中再 res.sendRedirect 就会出现
            // illegeStateException (因为你已经commit了res),这里的异常直接忽略就可以了.

            FF.log("下载异常：" + e.getMessage());


        }

    }

}
