package dfs;

import app.User;
import config.CacheConfig;

import gdi.ImageWaterMark;
import jun.db.impl.DataStoreFactory;
import jun.db.util.Base32Coder;
import org.json.JSONArray;
import org.json.JSONObject;
import pdf.PdfUtil;
import util.*;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.font.ImageGraphicAttribute;
import java.io.*;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

@WebServlet(name = "fileServer", urlPatterns = "/fileServer")
public class FileServer extends HttpServlet
{

    public static String ERR_MUST_LOGIN="必须先登录才能访问";

    static IFileServer ifs = null;

    public static IFileServer getInstance(int serverIndex)
    {
        return UploadFile.getInstance(serverIndex);
    }

    private static ThreadLocal<JSONObject> localVar = new ThreadLocal<JSONObject>();

    private static String getRrightFunction(int serverIndex)
    {
        String rightFunction = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/scriptcodeonserver", "");
        if (CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/enabledonserver", false) && !rightFunction.isEmpty())
            return rightFunction;
        return "";

    }

    public static boolean pdfNeedAutoAddWatermark(int serverIndex)
    {
        boolean b = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/pdfautoaddwatermark", true);
        return b;
    }

    public static boolean imgNeedAutoAddWatermark(int serverIndex)
    {
        boolean b = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/imgautoaddwatermark", true);
        return b;
    }

    public static String  getFileEncryptKey( int serverIndex)
    {
       return CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/fileEncryptPwd", "");
    }

    public static boolean  isFileNeedEncrypt( int serverIndex)
    {
        boolean b = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/needEncrypt", false);
        return b;
    }
    private static boolean neednotLogin(int serverIndex)
    {

        if (CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/neednotlogin", false))
            return true;
        return false;

    }

    public static String  getIPWhiteList(int serverIndex)
    {
        return CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/ipwhitelist", "");
    }

    protected long getLastModified(HttpServletRequest req)
    {

        int serverIndex = FF.getIntFromRequest(req, "serverIndex", 1);

        if (!neednotLogin(serverIndex)) //
        {
            return -1; //如果必须登录，那么不使用缓存
            /*
            User user= User.getUserFromRequest(req);
            if( user.getId()<0)  //已经登录，则不需要设置 localVar ，所以后面当不能从localVar中获取数据时，其实就是已经登录
            {
                FF.log( "queryString= "+ req.getQueryString()+"    必须先登录才能访问");

                JSONObject permit = new JSONObject().put("success",false).put("message","必须先登录才能访问");
                localVar.set(permit);
                return -1;
            }
            */

        }



        String objectName = FF.getStringFromRequest(req, "objectName", "");
        objectName= FF.replaceAll(objectName , "..", ""); // 防止路径攻击，通过　../的方式访问上层目录这样可以访问文件根目录外的文件

        String fileName = FF.getStringFromRequest(req, "fileName", objectName);
        String extName = ".pdf";
        int p = fileName.lastIndexOf(".");
        if (p > 0) extName = fileName.substring(p);

        //网盘的权限控制
        if (objectName.startsWith("网盘根目录"))
        {

            User user = User.getUserFromRequest(req);
            String[] t = objectName.split("/");
            String userName = t[1];
            if (!userName.equals(user.getName()))
            {
                 return -1;
            }
        }

        //如果是pdf，并且是需要加水印的，那么不缓存
        if (extName.equalsIgnoreCase(".pdf") && pdfNeedAutoAddWatermark(serverIndex)   //2022.09.05 增加
        )
        {
            return -1;
        }


        String rightFunction = getRrightFunction(serverIndex);
        if (!rightFunction.isEmpty())
        {
            //先将url参数放入
            try
            {
                JSONObject queryParam = BuildParamFromRequest.buildParam(req, null);
                Object obj = FF.runScript(rightFunction, queryParam, req, null);
                if (obj != null)
                {
                    String t = obj.toString();
                    JSONObject permit = new JSONObject(t);
                    localVar.set(permit);
                    if (!permit.getBoolean("success"))
                    {
                        return -1;
                    }

                }

            } catch (Exception e)
            {

            }
        }


        if (FF.getStringFromRequest(req, "imageForceWatermark", "").equalsIgnoreCase("true")) return -1;

        //  String bucketName = FF.getStringFromRequest(req, "bucketName", "");


        IFileServer fileServer = FileServer.getInstance(serverIndex);

        String file = fileServer.getDownloadToLocalFileName(objectName);
        File f = new File(file);
        if (f.exists()) return f.lastModified();
        return -1;


    }


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");


        String bucketName = FF.getStringFromRequest(req, "bucketName", "");
        String objectName = FF.getStringFromRequest(req, "objectName", "");

        User user = User.getUserFromRequest(req);

        String fileName = FF.getStringFromRequest(req, "fileName", objectName);
        int serverIndex = FF.getIntFromRequest(req, "serverIndex", 1);

        String viewAs = FF.getStringFromRequest(req, "viewas", "svg");



        String key = FF.MD5(bucketName + "-" + objectName + "-" + serverIndex);

        String sign = FF.getStringFromRequest(req, "sign", "");

        String sign0 = FF.encryptString(serverIndex + "." + objectName, FF.KEY_FileServer);//
        FF.log("objectName=" + objectName + "  sign=" + sign + "  sign0=" + sign0);
        String action = FF.getStringFromRequest(req, "action", "");

        String skipWatermarkTokenName = FF.getStringFromRequest(req, "skipWatermarkTokenName", "");

        String skipWatermarkToken = FF.getStringFromRequest(req, "skipWatermarkToken", "");

        boolean skipWatermark = false;
        if( !skipWatermarkTokenName.isEmpty() && !skipWatermarkToken.isEmpty()  )
        {
            skipWatermark= AppCache.getCache("token:"+skipWatermarkTokenName,"").equals(skipWatermarkToken);
        }


        if( skipWatermark) FF.log("水印强制忽略");
        try (BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());)
        {

            res.setContentType("text/html;charset = UTF-8");//很重要
            res.setCharacterEncoding("UTF-8");


            //网盘的权限控制
            if (objectName.startsWith("网盘根目录"))
            {
                String[] t = objectName.split("/");
                String userName = t[1];
                if (!userName.equals(user.getName()))
                {
                    if (!user.isSysUser())
                    {
                        String err = "禁止访问他人网盘中的文件（管理员除外)";
                        FF.log(err);
                        bos.write(err.getBytes("UTF-8"));
                        return;

                    }
                }
            }

            //2021.11.04 增加登录检测

            //2021.12.02 增加免登录免校验签名 ，如果有此签名，那么不需要校验权限
            //用于一些特殊的场景，比如脚本中心直接从文件服务器下载文件，不需要校验
            if (!sign.equals(sign0))
            {
                FF.log("下载文件前的权限校验");
                if (!neednotLogin(serverIndex)) //
                {

                    if (user.getId() < 0)
                    {

                        //没有登录，看看是不是在白名单中
                        String thisIP = FF.getClientIpAddr(req);
                        String appwhiteip = getIPWhiteList(serverIndex);

                        if (!FF.ipInWhitelist(thisIP, appwhiteip))
                        {


                            FF.log("queryString= " + req.getQueryString() + "  来自:"+thisIP + " 的访问(未登录，且不在白名单上)。必须先登录才能访问");

                            String err = ERR_MUST_LOGIN;
                            bos.write(err.getBytes("UTF-8"));
                            return;
                        }else
                        {
                             FF.log("来自:"+thisIP +" 的访问(未登录，但在白名单上) ");

                        }
                    }
                }


                String rightFunction = getRrightFunction(serverIndex);
                if (!rightFunction.isEmpty())
                {

                    JSONObject permit = localVar.get();
                    if (permit == null)
                    {
                        //先将url参数放入
                        JSONObject queryParam = BuildParamFromRequest.buildParam(req, null);
                        Object obj = FF.runScript(rightFunction, queryParam, req, res);
                        if (obj != null)
                        {
                            String t = obj.toString();
                            permit = new JSONObject(t);
                        }
                    }

                    if (!permit.getBoolean("success"))
                    {
                        String err = permit.getString("message", "禁止访问");
                        FF.log(err);

                        bos.write(err.getBytes("UTF-8"));
                        return;
                    }


                }
            }else {
                FF.log("服务端脚本直接下载，忽略水印");
                skipWatermark=true; //2024.12.20 调整通过sign 来下载的，通常是脚本中心下载 ， 不要带水印
            }

            //到这里， 相应的权限控制已经通过了

            IFileServer fileServer = FileServer.getInstance(serverIndex);


            //注意，如果是本地文件系统做文件服务，那么直接返回源文件路径到file中
            //如果是其它服务器，那么下载 到 autoDeleteAfterOneHour 目录中， 另外有线程专门来删除这个目录中的过期文件
            String file ="";
            try
            {
                file= fileServer.download(objectName);
            }catch(Exception e)
            {

                    String err = e.getMessage();
                    bos.write(err.getBytes("UTF-8"));
                    return;

            }

            if( FileServer.isFileNeedEncrypt(serverIndex))
            {
                String fkey = FileServer.getFileEncryptKey(serverIndex);
                String[] s = FF.splitFileName(file);
                String tempFileNameEncrypted = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/"  + DataStoreFactory.newLongID2String() + "." + s[2];

                try (
                        FileInputStream fis = new FileInputStream(file);
                        FileOutputStream fos = new FileOutputStream(tempFileNameEncrypted)
                )
                {
                    FileCryptoUtil.decryptedFile(fis, fos, fkey);
                    fis.close();
                    fos.close();
                    file = tempFileNameEncrypted;

                } catch (Exception e)
                {//文件解密失败后，直接就原文件输出

                }
            }


            String extName = ".pdf";
            int p = fileName.lastIndexOf(".");
            if (p > 0) extName = fileName.substring(p);
            String mimeType = req.getSession().getServletContext().getMimeType(extName);
            if (mimeType == null) mimeType = "";
            if (mimeType.isEmpty()) mimeType = "APPLICATION/OCTET-STREAM";


            // 2024.07.15 对 word , excel , pdf , dwg ,svg
            //如果不指定 viewer ，那么就使用系统定制的查看器来查看 ，如果指定了 viewer=raw ，那么就直接使用浏览器来查看


            if (action.equals("view") && (extName.equalsIgnoreCase(".xlsx")
                    || extName.equalsIgnoreCase(".xls")
                    || extName.equalsIgnoreCase(".docx")
                    || extName.equalsIgnoreCase(".doc")
                    || extName.equalsIgnoreCase(".pdf")
                    || extName.equalsIgnoreCase(".dwg")
                    || extName.equalsIgnoreCase(".svg")

            )
            )
            {
                String viewer = FF.getStringFromRequest(req, "viewer", "");

                if (viewer.isEmpty())
                {
                    String viewerPage = "";
                    if (extName.equalsIgnoreCase(".dwg")
                            || extName.equalsIgnoreCase(".svg"))
                    {
                        viewerPage = "viewSVG";
                    }
                    else
                    {
                        boolean viewByPDFjs= CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/viewByPDFjs",false);
                        if( viewByPDFjs)             viewerPage = "pdf.js/web/viewPDF";
                    }

                    if( !viewerPage.isEmpty())
                    {
                        String homneURL = FF.getHomeURL(req);
                        String url = req.getRequestURL().toString();
                        String qs = req.getQueryString();
                        qs = FF.replaceAll(qs, "&viewer=", "&viewer=raw");
                        if (qs.indexOf("&viewer=") < 0) qs = qs + "&viewer=raw";
                        String newURL = homneURL + "/" + viewerPage + "?url=" + Base32Coder.encode(url + "?" + qs);
                        res.sendRedirect(newURL);
                        return;
                    }


                }
            }

            //到了这里，那么就是要么是用浏览器直接查看，要么就是下载

            //如果在xlsx 在线查看，那么把类型改成pdf
            if (action.equals("view") && (extName.equalsIgnoreCase(".xlsx") || extName.equalsIgnoreCase(".xls")))
            {
                mimeType = req.getSession().getServletContext().getMimeType(".pdf");
            }

            if (action.equals("view") && (extName.equalsIgnoreCase(".docx") || extName.equalsIgnoreCase(".doc")))
            {
                mimeType = req.getSession().getServletContext().getMimeType(".pdf");
            }


            if (action.equals("view") && extName.equalsIgnoreCase(".dwg"))
            {
                if (viewAs.equalsIgnoreCase("pdf"))
                {
                    mimeType = req.getSession().getServletContext().getMimeType(".pdf");
                }
                else
                {
                    mimeType = req.getSession().getServletContext().getMimeType(".svg");
                }
            }


            res.setContentType(mimeType);

            //如果大于20，可能会问题

            //   if (fileName.length() > 20) fileName = fileName.substring(fileName.length() - 20, fileName.length());
            //	  这个很重要，不然文件名称会乱码  *2
            // 下面的方法 ，可以解决空格变+号的问题
            fileName =  new String(fileName.getBytes("UTF-8"),"ISO8859-1");


            //如果是预览，那么不要设置文件名称，不然就成了下载，而不是直接在浏览器中打开
            if (action.equals("download"))
            {

                res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            }
            else
            {
                if (action.equals("view") && (extName.equalsIgnoreCase(".xlsx")
                        || extName.equalsIgnoreCase(".xls")
                        || extName.equalsIgnoreCase(".docx")
                        || extName.equalsIgnoreCase(".doc")

                ))
                {
                    res.setHeader("Content-Disposition", "inline; filename=\"" + fileName + ".pdf\"");
                }
                else
                {

                    res.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
                }


                if (action.equals("view") && (extName.equalsIgnoreCase(".dwg")

                ))
                {
                    res.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "." + viewAs + "\"");
                }
                else
                {

                    res.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
                }

            }


            //到了这里，文件可能是已经解密过的，也可能是没有解密地的
            // 比如文件服务器开始设置成需要加密 ，后来又改成不需要加密了，或者把一个加密的文件上传后不需要加密的文件服务器上后，再下载 的话，还是需要解密的
            if( FileCryptoUtil.fileIsEncrypted( file))
            {

                String fkey = FileServer.getFileEncryptKey(serverIndex);
                String[] s = FF.splitFileName(file);
                String tempFileNameEncrypted = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/"  + DataStoreFactory.newLongID2String() + "." + s[2];

                try (
                        FileInputStream fis = new FileInputStream(file);
                        FileOutputStream fos = new FileOutputStream(tempFileNameEncrypted)
                )
                {
                    FileCryptoUtil.decryptedFile(fis, fos, fkey);
                    fis.close();
                    fos.close();
                    file = tempFileNameEncrypted;

                } catch (Exception e)
                {//文件解密失败后，直接就原文件输出

                }

            }

            FF.log("开始下载文件" + file);

            if( isImage( extName))
            {
                if (!skipWatermark  //2024.12.20 有些情况下不能加水印，比如文件备份
                        && imgNeedAutoAddWatermark(serverIndex)   //2022.06.08 增加
                )
                {
                   // FF.log("图片加水印");
                    //加水印
                    String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour";
                    FF.MkDirs(tempPath);
                    String tempFile = tempPath + "/" + DataStoreFactory.newGUID() + extName;

                    String info = "";
                    String script = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/imgscriptcodeonserver", "");
                    JSONObject queryParam = BuildParamFromRequest.buildParam(req, null);
                    Object sv = FF.runScript(script, queryParam, req, res);

                    if (sv != null)
                    {
                        if (!sv.toString().equalsIgnoreCase("null")) info = sv.toString();
                    }


                    Object v= new JSONObject( info);
                    JSONArray watermarkArray= null;
                    if( v!=null)
                    {
                        if (v instanceof JSONObject)
                        {
                           if( ((JSONObject)v).length()>0)
                           {
                               watermarkArray = new JSONArray();
                               watermarkArray.put(v);
                           }
                        }
                    }


                    if( watermarkArray!=null)
                    {

                        String tempFileName3 = tempPath + "/" + DataStoreFactory.newGUID()+ extName;
                        FF.log("打水印：" + tempFileName3);
                        ImageWaterMark.addWaterMark( file, tempFileName3, watermarkArray);
                        if (FF.fileExists(tempFileName3)) file = tempFileName3;
                    }else {
                        FF.log("水印配置返回结果：无需加水印");
                    }


                }
                else
                {
                    //FF.log("无需加水印");
                }

            }

            if (extName.equalsIgnoreCase(".pdf"))
            {

                if (!skipWatermark  //2024.12.20 有些情况下不能加水印，比如文件备份
                        && pdfNeedAutoAddWatermark(serverIndex)   //2022.06.08 增加
                )
                {
                    FF.log("加水印");
                    //加水印
                    String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour";
                    FF.MkDirs(tempPath);
                    String tempFile = tempPath + "/" + DataStoreFactory.newGUID() + ".pdf";
                    FF.log("加水印后的文件:"+ tempFile);
                    String info = user.getShowName() + " " + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date());
                    String script = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/pdfscriptcodeonserver", "");
                    JSONObject queryParam = BuildParamFromRequest.buildParam(req, null);
                    Object v = FF.runScript(script, queryParam , req, res);

                    if (v != null)
                    {
                        if (!v.toString().equalsIgnoreCase("null")) info = v.toString();
                    }


                    PdfWaterMark.addWaterMark(file, tempFile, 0, info);
                    FF.log("加水印完成，"+ tempFile);
                    file = tempFile; // 指向新的文件

                }
                else
                {
                    FF.log("无需加水印");
                }
            }

            //2021.11.03 图片加水印
            if (FF.getStringFromRequest(req, "imageForceWatermark", "").equalsIgnoreCase("true"))
            {
                if (extName.equalsIgnoreCase(".jpg")
                        || extName.equalsIgnoreCase(".jpeg")
                        || extName.equalsIgnoreCase(".png"))
                {

                    String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour";
                    FF.MkDirs(tempPath);
                    String tempFile = tempPath + "/" + DataStoreFactory.newGUID() + extName;

                    String info = User.getUserFromRequest(req).getShowName() + " " + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date());
                    IMG_addstamp.addStamp(file, info, tempPath, tempFile);
                    file = tempFile; // 指向新的文件

                }
            }


            //2023.05.07 增加 xlsx 当在线查看时，直接把它转成pdf再输出浏览器
            if (action.equals("view") && (extName.equalsIgnoreCase(".xlsx") || extName.equalsIgnoreCase(".xls")))
            {

                String tempPath = App.FileRoot + "/FileServer/excel_cache";
                FF.MkDirs(tempPath);
                String tempFile = tempPath + "/" + key + ".pdf";
                PdfUtil.excel2pdf(file, tempFile);
                file = tempFile;
            }

            //2023.05.07 增加 xlsx 当在线查看时，直接把它转成pdf再输出浏览器
            if (action.equals("view") && (extName.equalsIgnoreCase(".docx") || extName.equalsIgnoreCase(".doc")))
            {

                String tempPath = App.FileRoot + "/FileServer/word_cache";
                FF.MkDirs(tempPath);
                String tempFile = tempPath + "/" + key + ".pdf";
                PdfUtil.word2pdf(file, tempFile);
                file = tempFile;
            }

            //2023.05.07 增加 xlsx 当在线查看时，直接把它转成pdf再输出浏览器
            if (action.equals("view") && (extName.equalsIgnoreCase(".dwg")))
            {

                String tempPath = App.FileRoot + "/FileServer/cad_cache";
                FF.MkDirs(tempPath);
                String tempFile = tempPath + "/" + key + "." + viewAs;
                if (!FF.fileExists(tempFile))
                {
                    PdfUtil.cad2other(file, tempFile, viewAs);
                }
                file = tempFile;
            }






            try (
                    BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(file)));

            )
            {
                int once = 32768;
                byte buffer[] = new byte[once];
                int actually = 0;

                while (true)
                {
                    actually = bis.read(buffer);
                    if (actually <= 0) break;
                    bos.write(buffer, 0, actually);

                }

                bis.close();
                bos.flush();
                bos.close();

                FF.log("下载文件完成");

                //FF.deleteFile(pdffile.getPath()); 不能删除了，如果使用内置文件服务器那么不能删除
                //20222.05.18 如果名称中包含有 deleteafterdownloaded 串，那么在下载后，把它删除
                if (objectName.indexOf("deleteafterdownloaded") > 0)
                {
                    FF.log(objectName + "属于一次性下载文件，现在删除");
                    fileServer.delete(objectName);
                }
            } catch (Exception e)
            {
                FF.log(FF.exceptionMessage(e));
            }

        } catch (Exception e)
        {

            //res.sendRedirect("../SystemTip.jsp?info="+  URLEncoder.encode("文件下载发生错误","UTF-8")  );
            //在之前，已经做了res.setHeader，bos.write等操作，此时出现异常可能是连接断开之类的异常，
            //那么在这个 exception 的处理中再 res.sendRedirect 就会出现
            // illegeStateException (因为你已经commit了res),这里的异常直接忽略就可以了.

            FF.log("下载异常：" + e.getMessage());


        }


    }


    public static void  checkDownloadFileValid(String file) throws Exception
    {
        File f= new File( file);
        if( f.exists() && f.length()<100 )
        {
            String ct= FF.readFile(file);
            if( ct.equals(ERR_MUST_LOGIN))
            {
                FF.deleteFile(file); //如果没有权限 ，那么删除这个文件
                throw new Exception (ct);
            }
        }
    }

    public static boolean isImage(String extName)
    {
        if (extName.equalsIgnoreCase(".jpg")
                || extName.equalsIgnoreCase(".jpeg")
                || extName.equalsIgnoreCase(".png")
                || extName.equalsIgnoreCase(".gif")
                || extName.equalsIgnoreCase(".bmp")
                || extName.equalsIgnoreCase(".tiff")
        )
        {
            return true;
        }
        return false;
    }
}
