package dfs;

import app.User;
import jun.db.impl.DataStoreFactory;
import util.FF;
import util.PDF_addstamp;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

/**
 * 用于导出pdf后的下载 ，下载后就删除，并且 不需要打水印
 */
@WebServlet(name = "downeloadAndDeleteForExportPDF", urlPatterns = "/downeloadAndDeleteForExportPDF")
public class DowneloadAndDeleteForExportPDF extends HttpServlet
{

    public static String pwd = "download";

    protected long getLastModified(HttpServletRequest req)
    {
        return -1;

    }


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");


        String fileName = FF.getStringFromRequest(req, "filename", "");
        String sourceFileName = FF.decryptString(FF.getStringFromRequest(req, "sourcename", ""), pwd);
        String action = FF.getStringFromRequest(req, "action", "view");


        if (fileName.isEmpty()) fileName = "download.pdf";
        String extName = ".pdf";
        int p = fileName.lastIndexOf(".");
        if (p > 0) extName = fileName.substring(p);
        String mimeType = req.getSession().getServletContext().getMimeType(extName);
        if (mimeType == null) mimeType = "";
        if (mimeType.isEmpty()) mimeType = "APPLICATION/OCTET-STREAM";

        res.setContentType(mimeType);

        //如果大于20，可能会问题

        //   if (fileName.length() > 20) fileName = fileName.substring(fileName.length() - 20, fileName.length());
        //	  这个很重要，不然文件名称会乱码  *2
        fileName = URLEncoder.encode(fileName, "UTF-8");
        //如果是预览，那么不要设置文件名称，不然就成了下载，而不是直接在浏览器中打开

        if (action.equals("download"))
        {
            res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        else
        {
            res.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");

        }


        FF.log("开始下载文件" + sourceFileName);


        try (
                BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(sourceFileName)));
                BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
        )
        {
            int once = 32768;
            byte buffer[] = new byte[once];
            int actually = 0;

            while (true)
            {
                actually = bis.read(buffer);
                if (actually <= 0) break;
                bos.write(buffer, 0, actually);

            }

            bis.close();
            bos.flush();
            bos.close();

            FF.log("下载文件完成");

            //不要立即删除，留给自动删除任务去删除
//            FF.deleteFile(sourceFileName);

        } catch (Exception e)
        {


            FF.log("下载异常：" + e.getMessage());


        }

    }

}
