package dfs;

import app.User;

import jun.db.impl.DataStoreFactory;
import util.FF;
import util.PDF_addstamp;

import util.PdfWaterMark;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

@WebServlet(name = "deleteAfterDownloaded", urlPatterns = "/deleteAfterDownloaded")
public class DowneloadAndDelete extends HttpServlet
{

    public static String pwd = "download";

    protected long getLastModified(HttpServletRequest req)
    {
        return -1;

    }


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");



        String fileName = FF.decryptString(FF.getStringFromRequest(req, "filename", ""), pwd);
        String sourceFileName = FF.decryptString(FF.getStringFromRequest(req, "sourcename", ""), pwd);



            String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/";
            String extName = ".pdf";
            int p = fileName.lastIndexOf(".");
            if (p > 0) extName = fileName.substring(p);
            String mimeType = req.getSession().getServletContext().getMimeType(extName);
            if (mimeType == null) mimeType = "";
            if (mimeType.isEmpty()) mimeType = "APPLICATION/OCTET-STREAM";

            res.setContentType(mimeType);


            //	  这个很重要，不然文件名称会乱码  *2
            fileName = URLEncoder.encode(fileName, "UTF-8");
            //如果是预览，那么不要设置文件名称，不然就成了下载，而不是直接在浏览器中打开

            res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");



            FF.log("开始下载文件" + sourceFileName);

            /*  2024.11.22  修改， 临时文件就不要加水印了， 通常它都是处理过程中的临时文件，不需要加水印

            if (extName.equalsIgnoreCase(".pdf")) // && needRightCheck.equals("true") )
            {    //加水印

                FF.MkDirs(tempPath);
                String tempFile = tempPath + "/" + DataStoreFactory.newGUID() + ".pdf";

                String info = User.getUserFromRequest(req).getShowName() + " " + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date());
                //PDF_addstamp.addStamp(sourceFileName, info, tempPath, tempFile, true);
                PdfWaterMark.addWaterMark(sourceFileName, tempFile,  0, info);
                sourceFileName = tempFile; // 指向新的文件

            }

             */

            try(

            BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(sourceFileName)));
            BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
            )
            {
                int once = 32768;
                byte buffer[] = new byte[once];
                int actually = 0;

                if (!sourceFileName.startsWith(tempPath))
                    throw new Exception("非法访问除 autoDeleteAfterOneHour 目录之外的文件");

                while (true)
                {
                    actually = bis.read(buffer);
                    if (actually <= 0) break;
                    bos.write(buffer, 0, actually);

                }

                bis.close();
                bos.flush();
                bos.close();

                FF.log("下载文件完成");

                FF.deleteFile(sourceFileName);
            }catch(Exception e)
            {


                FF.log("下载异常：" + e.getMessage());
            }


    }

}
