package dfs;


import config.CacheConfig;
import util.DateTool;
import util.FF;
import webApp.App;

import java.io.File;
import java.util.Date;
import java.util.TimerTask;

public class AutoDeleteFileOneHour extends TimerTask
{
    public String path;
    public int timeoutMinute;

    public AutoDeleteFileOneHour(String path , int timeoutMinute)
    {
        this.timeoutMinute=timeoutMinute;
        this.path= path;
    }

    @Override
    public void run()
    {
        //String path = App.FileRoot + "/FileServer/autoDeleteAfterOneHour";
        //int timeout= CacheConfig.get("/文件服务/文件缓存",60);

        autoDelete(path , timeoutMinute);


    }

    public void autoDelete( String path , int timeoutMinute)
    {

        FF.log("开始检验并删除过期的文件" + path +" 在距离现在 "+timeoutMinute+"分钟前的文件将被删除 ");

        DateTool dt = new DateTool();


        Date d7 = dt.nextDate(new Date(), - timeoutMinute, "minute"); //


        String files[] = null;

        File dir = new File(path);
        if (dir.exists() && dir.isDirectory())
        {
            files = dir.list();
        }


        if (files != null)
        {
            for (int i = 0; i < files.length; i++)
            {

                String f = files[i];

                File ff = new File(path + File.separator + f);
                Date d = new Date(ff.lastModified());

                //如果是1小时前的的，那么删除它
                if (d.before(d7))
                {
                    FF.log(path + File.separator + f + "被系统自动删除。");
                    FF.delTree(path + File.separator + f);
                }
            }

        }
    }

}




