package dfs;

import com.aliyun.oss.*;
import com.aliyun.oss.model.*;
import config.CacheConfig;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import util.DirCopyUtil;
import util.FF;
import util.URLUtil;
import webApp.App;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;


/**
 * 阿里云oss支持
 */
public class AliyunOSSServer implements IFileServer
{

    int serverIndex;

    public AliyunOSSServer(int serverIndex)
    {
        this.serverIndex = serverIndex;
    }

    @Override
    public String getBucketName()
    {

        String bucketName = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_bucket", "default");
        return bucketName;
    }

    @Override
    public int getImageMaxWidthOrHeight()
    {
        String t = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/imageMaxWidthOrHeight", "4096");
        int ret = FF.String2Int(t);
        if (ret == 0) ret = 4096;
        return ret;
    }

    @Override
    public JSONArray getFileList(String path)
    {
        return null;
    }

    @Override
    public String mkdir(String path, String subPath)
    {
        return null;
    }

    //TODO
    @Override
    public String rename(String objectName, String newName)
    {
        return "";
    }

    //TODO
    @Override
    public boolean objectExists(String objectName)
    {

        String endpoint = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_address", "");
        String accessKeyId = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_key", "");
        String accessKeySecret = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_secret", "");

        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        String bucketName = getBucketName();
        boolean found = ossClient.doesObjectExist(bucketName, objectName);

        return found;

    }

    @Override
    /**
     *
     */
    public JSONObject upload(String objectName, String showName, String file) throws Exception
    {

        if( showName==null) showName="";
        showName = URLEncoder.encode(showName, "UTF-8");

        String bucketName = getBucketName();
        JSONObject ret = new JSONObject().put("success", true);
        if (objectName.startsWith("/")) objectName = objectName.substring(1);


        String endpoint = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_address", "");
        String accessKeyId = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_key", "");
        String accessKeySecret = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_secret", "");

        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        try
        {

            if ( objectExists( objectName) )  //如果文件已存在，那么自动改名
            {
                String name0 = objectName;
                String extName = "";
                if (name0.indexOf(".") > 0)
                {
                    int p = name0.lastIndexOf(".");
                    name0 = name0.substring(0, p);
                    extName = objectName.substring(p);
                }
                int i = 0;
                while (true)
                {
                    i++;
                    objectName = name0 + "-" + i + extName;
                    if (!objectExists(objectName))
                    {

                        break;
                    }
                    else
                    {
                        FF.log(    objectName + "已存在， 系统自动重新生成一个文件名，避免覆盖");
                    }
                }

            }


            UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, objectName);
            // The local file to upload---it must exist.
            uploadFileRequest.setUploadFile(file);
            // Sets the concurrent upload task number to 5.
            uploadFileRequest.setTaskNum(5);
            // Sets the part size to 1MB.
            uploadFileRequest.setPartSize(1024 * 1024 * 1);
            // Enables the checkpoint file. By default it's off.
            uploadFileRequest.setEnableCheckpoint(true);

            ObjectMetadata om = new ObjectMetadata();
            // 可以不用设置 ， 不设置，它会自已判断 ， getcontentType 函数支持的类型不全，反而出问题，还是改成让它自动设置好了
          //  om.setContentType(getcontentType(objectName.substring(objectName.lastIndexOf("."))));
            uploadFileRequest.setObjectMetadata(om);


            UploadFileResult uploadResult = ossClient.uploadFile(uploadFileRequest);

            CompleteMultipartUploadResult multipartUploadResult =
                    uploadResult.getMultipartUploadResult();
            FF.log(multipartUploadResult.getETag());

            String dn= getDomain();
            String url="";
            if(dn.isEmpty())
            {
                //endpoint 拼上bucketName 就是对外访问地址
                url = endpoint.replace("://", "://" + bucketName + ".");

            }else {
                url= dn;

            }
            if (!url.endsWith("/")) url = url + "/";
            url += objectName;
            url = URLUtil.URLEncoder(url);
            ret.put("url", url);

            //下面的参数是为了着返回值兼容文件上传的返回结果
            ret.put("url_img", url);
            ret.put("serverindex", this.serverIndex);
            ret.put("bucketname", this.getBucketName());
            ret.put("objectname", objectName);
            ret.put("filename", showName);


        } catch (Exception oe)
        {
            ret.put("success", false);
            ret.put("message", oe.getMessage());


        } catch (Throwable e)
        {

        } finally
        {
            ossClient.shutdown();
        }

        return ret;
    }


    public static String getcontentType(String FilenameExtension)
    {
        if (FilenameExtension.equalsIgnoreCase(".bmp"))
        {
            return "image/bmp";
        }
        if (FilenameExtension.equalsIgnoreCase(".gif"))
        {
            return "image/gif";
        }
        if (FilenameExtension.equalsIgnoreCase(".jpeg") ||
                FilenameExtension.equalsIgnoreCase(".jpg") ||
                FilenameExtension.equalsIgnoreCase(".png"))
        {
            return "image/jpg";
        }
        if (FilenameExtension.equalsIgnoreCase(".html") || FilenameExtension.equalsIgnoreCase(".htm"))
        {
            return "text/html";
        }
        if (FilenameExtension.equalsIgnoreCase(".txt"))
        {
            return "text/plain";
        }
        if (FilenameExtension.equalsIgnoreCase(".vsd"))
        {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equalsIgnoreCase(".pptx") ||
                FilenameExtension.equalsIgnoreCase(".ppt"))
        {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equalsIgnoreCase(".docx") ||
                FilenameExtension.equalsIgnoreCase(".doc"))
        {
            return "application/msword";
        }
        if (FilenameExtension.equalsIgnoreCase(".xml"))
        {
            return "text/xml";
        }
        return "image/jpg";
    }

    @Override
    /**
     * 把oss中的文件下载到本地文件系统中， 1小时后删除
     */
    public String getDownloadToLocalFileName(String objectName)
    {
        String t = objectName;
        int p = t.lastIndexOf("/");
        if (p > 0) t = t.substring(p + 1);

        String toFile = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/" + t; // 去掉子目录 ，放到autoDeleteAfterOneHour 便于删除维护
        return toFile;
    }

    /**
     * 根据  bucketName ,  objectName 定位文件名
     *
     * @param bucketName
     * @param objectName
     * @return
     * @throws Exception
     */
    public String download(String objectName) throws Exception
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String endpoint = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_address", "");
        String accessKeyId = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_key", "");
        String accessKeySecret = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_secret", "");

        String toFile = getDownloadToLocalFileName(objectName);

        FF.makeSurePathOfFileExists(toFile); //确保文件目录一定存在
        //如果有缓存的文件，那么不需要再下载了 ，之所以可以这么处理， 是因为，这个上传的文件，不存在更改的，只会是删除，重新上传
        //所以如果本地有对应的下载好的缓存文件，那么不存在与OSS上不一至的情况。
        if (FF.fileExists(toFile)) return toFile;

        // 创建OSSClient实例。
        OSS ossClient = null;
        try
        {
            ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

            // 下载OSS文件到本地文件。如果指定的本地文件存在会覆盖，不存在则新建。
            ossClient.getObject(new GetObjectRequest(bucketName, objectName), new File(toFile));
            return toFile;
        } catch (Exception e)
        {
            FF.log(e);
            throw e;
        } finally
        {

// 关闭OSSClient。
            if (ossClient != null) ossClient.shutdown();
        }
    }

    @Override
    public boolean delete(String objectName)
    {
        String bucketName = getBucketName();
        if (objectName.startsWith("/")) objectName = objectName.substring(1);

        String endpoint = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_address", "");
        String accessKeyId = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_key", "");
        String accessKeySecret = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_access_secret", "");


        OSS ossClient = null;
        try
        {
            ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

            ossClient.deleteObject(bucketName, objectName);
        } finally
        {

            // 关闭OSSClient。
            if (ossClient != null) ossClient.shutdown();
        }
        return true;
    }

    public String getDomain()
    {
        String d = CacheConfig.get("/文件服务/文件服务器." + serverIndex + "/aliyunoss_dn", "");
        return d.trim();
    }

}
