package deprecated.mq;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PushConsumer
{

     DefaultMQPushConsumer consumer;

     HashMap<String , MessageFilter> filterMap= new HashMap<String , MessageFilter>();


     public PushConsumer()
     {

     }

     public  PushConsumer addFilter( String tag , MessageFilter  filter)
     {
        filterMap.put(tag , filter);
        return this;
     }

    public  void  connect ( String  consumerGroup , String namesrvAddr , String topic , ConsumeFromWhere  startAtWhere ,
                            MessageModel  msgModel , String consomeTimestamp)

    {

        try
        {
            if (consumerGroup.isEmpty()) consumerGroup = "defaultGroup";

            consumer = new DefaultMQPushConsumer(consumerGroup);
            consumer.setInstanceName("" + (new Date()).getTime());
            consumer.setNamesrvAddr(namesrvAddr);

            consumer.subscribe(topic, "*");

            consumer.setConsumeFromWhere(startAtWhere);
            consumer.setMessageModel(msgModel);
            if (!consomeTimestamp.isEmpty()) consumer.setConsumeTimestamp(consomeTimestamp);

            consumer.registerMessageListener(new MessageListenerConcurrently()
            {

                @Override
                public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context)
                {

                    for (int i = 0; i < msgs.size(); i++)
                    {
                        MessageExt msg = msgs.get(i);
                        String tag = msg.getTags();
                        MessageFilter filter = filterMap.get(tag);
                        if (filter == null) continue;
                        filter.onMessage(msg);
                    }

                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
            });
            consumer.start();
        }catch(Exception e)
        {

        }

    }

    public void shutDown()
    {
        consumer.shutdown();
    }
}
