package deprecated.mq;

import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import util.FF;
import webApp.App;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessageProducer
{


      int MaxCacheSize = 1000; //最多堆积消息条数
      ConcurrentLinkedQueue<Message> messageCache = new ConcurrentLinkedQueue<Message>();


      volatile boolean exitSend = false;
    static SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd HH:mmß:ss SSS");

      ObjectPool<DefaultMQProducer> pool = null;


    public  static  String topic_log = "appLog";

    public  static  String tag_log = "appLog";

    public   String nameSrvAddr = "";
    public   Thread quickSendMessageThread;


    public  MessageProducer(String producerGroupName, String nameSrvAddr_, int maxTotal, int maxIdle, int minIdle, int maxWaitMillis)
    {

        nameSrvAddr = nameSrvAddr_;
        MessageProducerFactory factory = new MessageProducerFactory(producerGroupName, nameSrvAddr);

        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis(maxWaitMillis);

        pool = new GenericObjectPool(factory, config);

        quickSendMessageThread = new Thread()
        {


            @Override
            public void run()
            {
                while (true)
                {

                    /*为什么不用LinkedBlockingQueue
                        由于LinkedBlockingQueue   ，take方法在队列空的时候会阻塞，直到有队列成员被放进来。
                        所以当没有消息时，它一直阻塞，就无法中断它，当然解决办法也是有的，发送一个对家内容的消息
                        让它退出阻塞，并判断消息是不是某特定消息，是，就终止线程。
                        */
                    while (messageCache.isEmpty())
                    {
                        if (exitSend) return;
                        try
                        {
                            Thread.sleep(100);
                        } catch (Exception e)
                        {
                        }
                    }


                    //poll并不阻塞队列，当队列为空时，它直接返回null ,所以msg是可能为null的，所以前面要处理一下，避免没有消息时进入下面的处理
                    Message msg = messageCache.poll();
                    //如果没有消息了，并且需要结束，那么退出吧
                    if (msg == null && exitSend) return;

                    if (msg == null) continue;

                    DefaultMQProducer producer = null;

                    //为什么要循环3次，因为下面的发布者池中获取的对象，它可能还没有正常连接到RocketMQ，导致发送失败
                    //所以在发送失败后，等10秒，再试，试3次，（30秒）还不能发送成功，就放弃
                    for (int i = 0; i < 3; i++)
                    {
                        try
                        {

                            while (producer == null)
                            {
                                producer = pool.borrowObject();
                                if (producer == null) Thread.sleep(10000);

                                if (exitSend) return;
                            }

                            //如果消息发送者超过3个，那么显示一下提示信息
                            //
                              //发送消息
                            producer.sendOneway(msg);

                             pool.returnObject(producer);
                            break;

                        } catch (Exception ex)
                        {
                            //ex.printStackTrace();
                            //@off
                            try { pool.invalidateObject(producer); Thread.sleep(10000);} catch (Exception ex2)   {   }
                            //@on


                        }
                    }

                }
            }

        };

        quickSendMessageThread.start();
    }


    public   void destroy()
    {
        try
        {
            exitSend = true;//通知快速发送线程可以结束了
            pool.clear();
            pool.close();
            messageCache.clear();
        } catch (Exception e)
        {

        }
    }


    //发送日志信息
    public   boolean sendLog(String keys, String msgbody)
    {
        return quickSend(topic_log, tag_log, keys, msgbody);
    }


    /**
     * 同步发送消息
     *
     * @param topic
     * @param tags
     * @param keys
     * @param msgbody
     * @return
     */
    public   SendResult syncSend(String topic, String tags, String keys, String msgbody)
    {

        if (pool == null) return null;

        DefaultMQProducer producer = null;
        try
        {
            producer = pool.borrowObject();
            if (producer == null) return null;

            Message msg = new Message(topic,
                                      tags,
                                      keys,
                                      msgbody.getBytes(RemotingHelper.DEFAULT_CHARSET));


            msg.getProperties().put("vipname" ,App.getInstance().getVirtualHostName());
            SendResult sendResult = producer.send(msg);
            return sendResult;

        } catch (Exception ex)
        {

            try
            {
                pool.invalidateObject(producer);
            } catch (Exception er)
            {
            }

            return null;

        } finally
        {
            if (producer != null)
            {
                try
                {
                    pool.returnObject(producer);
                } catch (Exception ex)
                {

                }
            }
        }

    }

    /**
     * 异步发送消息
     *
     * @param topic
     * @param tags
     * @param keys
     * @param msgbody
     * @param callback
     */

    public   void asyncSend(String topic, String tags, String keys, String msgbody, SendCallback callback)
    {

        if (msgbody == null) return;
        if (msgbody.isEmpty()) return;

        if (pool == null) return;

        DefaultMQProducer producer = null;
        try
        {
            producer = pool.borrowObject();
            if (producer == null) return;
            Message msg = new Message(topic,
                                      tags,
                                      keys,
                                      msgbody.getBytes(RemotingHelper.DEFAULT_CHARSET));

            msg.getProperties().put("vipname" ,App.getInstance().getVirtualHostName());
            producer.send(msg, callback);

        } catch (Exception ex)
        {
            try
            {
                pool.invalidateObject(producer);
            } catch (Exception er)
            {
            }


        } finally
        {
            if (producer != null)
            {
                try
                {
                    pool.returnObject(producer);
                } catch (Exception ex)
                {

                }
            }
        }

    }

    /**
     * 快速发送消息
     *
     * @param topic
     * @param tags
     * @param keys
     * @param msgbody
     */
    public   boolean quickSend(String topic, String tags, String keys, String msgbody)
    {

        if (msgbody == null) return false;
        if (msgbody.isEmpty()) return false;

        if( pool==null) return false;

        try
        {

            //当太多快速消息积累无法发送时，丢掉开始的那些
            while (messageCache.size() > MaxCacheSize)
            {

                System.out.println("oneWay 方式的消息堆积过多无法发送，丢弃所有未发送的消息");
                messageCache.clear();
            }

            Message msg = new Message(topic,
                                      tags,
                                      keys,
                                      msgbody.getBytes(RemotingHelper.DEFAULT_CHARSET));

            msg.getProperties().put("vipname" ,App.getInstance().getVirtualHostName());

            msg.getProperties().put("time" , SDF.format(new Date()));

            messageCache.add(msg);
            return true;

        } catch (Exception ex)
        {

            return false;
        }
    }

}
