package config;


import util.FF;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(name = "resource", urlPatterns = "/resource")
public class Resource extends HttpServlet
{

    /*
    * HTTP 304状态码的详细讲解
　
　   首先，对于304状态码不应该认为是一种错误，而是对客户端有缓存情况下服务端的一种响应。
　　客户端在请求一个文件的时候，发现自己缓存的文件有 Last Modified ，那么在请求中会包含 If Modified Since ，
这个时间就是缓存文件的 Last Modified 。因此，如果请求中包含 If Modified Since，就说明已经有缓存在客户端。
服务端只要判断这个时间和当前请求的文件的修改时间就可以确定是返回 304 还是 200 。
    对于静态文件，例如：CSS、图片，服务器会自动完成 Last Modified 和 If Modified Since 的比较，
    完成缓存或者更新。但是对于动态页面，就是动态产生的页面，往往没有包含 Last Modified 信息，
    这样浏览器、网关等都不会做缓存，也就是在每次请求的时候都完成一个 200 的请求。
　　因此，对于动态页面做缓存加速，首先要在 Response 的 HTTP Header 中增加 Last Modified 定义，
其次根据 Request 中的 If Modified Since 和被请求内容的更新时间来返回 200 或者 304 。
虽然在返回 304 的时候已经做了一次数据库查询，但是可以避免接下来更多的数据库查询，并且没有返回
页面内容而只是一个 HTTP Header，从而大大的降低带宽的消耗，对于用户的感觉也是提高。

    * */

    //控制客户端缓存刷新
    protected long getLastModified(HttpServletRequest req)
    {
        return CacheResource.lastModifiedDate;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {

        //https://www.cnblogs.com/vajoy/p/5341664.html  浅谈浏览器http的缓存机制
        // 先看上面的文章，就明白缓存是怎么回事

        resp.setHeader("Pragma","No-cache");
        resp.setHeader("Cache-Control","no-cache");
        resp.setHeader("Expires","0");

        String code = FF.getStringFromRequest(req, "code", "");
        String type = CacheResource.get(code + ".type", "");
        if( type.equals("html"))
        {
            //2022.04.13增加了登录处理
            if (CacheResource.get(code + ".logincheck", "").equalsIgnoreCase("true"))
            {
                if (!sso.SSOLoginCheck.loginCheck(req, resp, false)) return;
            }
        }

        String ret = CacheResource.get(code, "");
        req.setCharacterEncoding("UTF-8");
        String contentType = "text/html";
        if (type.equals("script")) contentType = "application/javascript";
        if (type.equals("css")) contentType = "text/css";

        resp.setContentType(contentType + ";charset = UTF-8");//很重要
        resp.setCharacterEncoding("UTF-8");
        resp.getOutputStream().write(ret.getBytes("UTF-8"));
    }


}
