package config;


import dfs.FileServer;
import dfs.IFileServer;
import dfs.UploadFile;
import util.FF;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * 头像
 */

@WebServlet(name = "portrait", urlPatterns = "/portrait")
public class Portrait extends HttpServlet
{

    private String getPortraitFile(HttpServletRequest req)
    {
        int size = FF.getIntFromRequest(req, "size", 64);
        if (size < 32) size = 32;
        if (size > 32 && size <= 64) size = 64;
        if (size > 64 && size <= 128) size = 128;
        if (size > 128) size = 128;

        int userid = FF.getIntFromRequest(req, "userid", 0);

        String file = getImg(size, userid);
        if (file.isEmpty()) file = getImg(size, 0);
        if (file.isEmpty()) file = App.AppRoot + "/img/avatar2.png";
        return file;
    }

    public static String getImg(int size, int userid)
    {
        int serverIndex = 1;
        IFileServer fileServer = UploadFile.getInstance(serverIndex);
        String bucketName = fileServer.getBucketName();
        String objectName = "UserPortrait/" + size + "/" + userid + ".png";

        String file = fileServer.getDownloadToLocalFileName(objectName);
        if (FF.fileExists(file)) return file;

        try
        {
            fileServer.download(objectName);
        } catch (Exception e)
        {
            //是有可能不存在的
        }
        if (FF.fileExists(file)) return file;
        return "";
    }

    //控制客户端缓存刷新
    protected long getLastModified(HttpServletRequest req)
    {

        if (FF.getStringFromRequest(req, "cache", "true").equals("false")) return -1;

        String file = getPortraitFile(req);
        return new File(file).lastModified();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {
        String file = getPortraitFile(req);



        try ( BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(file)));
              BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
        )
        {
            int userid = FF.getIntFromRequest(req, "userid", 0);


            String mimeType = "image/png";

            res.setContentType(mimeType);

            res.setHeader("Content-Disposition", "inline; filename=\"user" + userid + ".png\"");



            int once = 32768;
            byte buffer[] = new byte[once];
            int actually = 0;

            while (true)
            {
                actually = bis.read(buffer);
                if (actually <= 0) break;
                bos.write(buffer, 0, actually);

            }

            bis.close();
            bos.flush();
            bos.close();


        } catch (Exception e)
        {
            FF.log("下载异常：" + e.getMessage());


        }
    }


}
