package config;

import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import util.DBF;
import util.FF;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by zengjun on 2017/8/27.
 */
public class Config
{


    private String con = null;
    private String table;
    private String currentId = "0";
    private String currentPid = "0";
    private String appid="";
    public DataStore ds;

    private boolean modified = false;//单指 set(key , value)时，是不是对 key的值 发生了变化，因为 可能value与key 的旧值是一样的


    public Config(   String table,String appid)
    {
        this( "",table, appid);
    }


    public Config( String con, String table,String appid)
    {
        this.con = con;
        this.table = table;

        this.currentPid = "0";
        this.currentId = "0";
        this.appid= appid;
        ds = DataStoreFactory.newDataStore(con, "select * from " + table + " order by innerorder asc");
        ds.setUpdateProperty(table, "id", "*", "id");
    }


    private void getIDs(DataStore tds, String pid, ArrayList<String> sqls)
    {
        int n = tds.retrieve("pid='" + pid + "'");
        //如果pid 没有子项了，那么不用继续了
        if (n == 0) return;

        sqls.add("delete from " + this.table + " where pid='" + pid + "'");

        String[] ids = new String[n];

        for (int i = 0; i < n; i++)
        {
            ids[i] = tds.getString(i, "id");
        }

        for (int i = 0; i < n; i++)
        {

            getIDs(tds, ids[i], sqls);
        }

    }


    public void deleteTree(String root)
    {

        DataStore tds = DataStoreFactory.newDataStore(con, "select id , pid from " + this.table);
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("delete from " + this.table + " where id='" + root + "'");
        getIDs(tds, root, sqls);
        FF.SafeExecute(con, sqls, true);

    }

    public String getCurrentId()
    {
        return currentId;
    }

    public String getCurrentPId()
    {
        return currentPid;
    }

    public Config enter(String subPath)
    {
        return enter(subPath, "node", "true"); //节点通常不需要值，只需要名称即可，但有一些节点有“使能” 属性，所以默认设置值为 true
    }

    public Config enter(String subPath, String nodeType, String value)
    {
        return  enter( subPath, nodeType, value,true);
     }

     //进入，但是不覆盖值
    public Config enter(String subPath, String nodeType  )
    {
        return  enter( subPath, nodeType, "" ,false );
    }


    public Config enter(String subPath, String nodeType, String value, boolean overWriteValue)
    {

        subPath = subPath.trim();
        nodeType = nodeType.trim();
        if (value == null) value = "";
        value = value.trim();


        if (subPath.startsWith("/")) currentId = "0";
        String[] paths = subPath.split("/");
        for (int i = 0; i < paths.length; i++)
        {
            String path = paths[i].trim();
            if (path.isEmpty()) continue;
            boolean ok = false;
            while (!ok)
            {
                int n = ds.retrieve("pid='" + currentId + "'  and name='" + path + "' ");
                if (n == 0)
                {
                    //FF.log("pid='" + currentId + "' and name='" + path + "' 不存在，创建它");
                    //可能会创建失败，因为如果多个线程同时在做这个操作，pid +name必须是唯一的，这导致
                    //createNode可能会失败 ，失败后继续循环，但进入的就是下面的 已存在的逻辑中
                    ok = createNode(   currentId, path, nodeType, value);
                }
                else
                {
                    //FF.log("pid='" + currentId + "' and name='" + path + "' 存在，更新它, nodetype=" + nodeType + "  value:" + value);
                    ds.setValue(0, "nodetype", nodeType);
                    //2024.09.20 可能path 与数据库中的 name 有大小写上的差异 ，但是检索时， 是不区分大小写的，
                    // 所以需要用path再覆盖一下
                    ds.setValue(0, "name", path);

                    if( overWriteValue)   ds.setValue(0, "value", value);

                    ok = ds.update(true);
                    if (!ok) FF.log("更新:" + path + "失败，原因：" + ds.getError().getMessage());


                }
                break;
            }

            currentId = ds.getString(0, "id");
            currentPid = ds.getString(0, "pid");
            appid= ds.getString(0,"appid");
            //FF.log(" currentId=" + currentId + "    currentPid= " + currentPid);

        }


        return this;
    }


    public ArrayList<String> getSub(String nodeType )
    {
        return getSub( nodeType, false);
    }

    public ArrayList<String> getSub(String nodeType, boolean toLowerCase)
    {
        ArrayList<String> ret = new ArrayList<String>();


        int n = ds.retrieve("pid='" + currentId + "' and nodetype='" + nodeType + "'");
        for (int i = 0; i < n; i++)
        {
            String t=ds.getString(i, "name");
            if( toLowerCase) t=t.toLowerCase();
            ret.add(t);
        }
        return ret;

    }

    public String  clone (String id , String toPid ) throws Exception
    {
        return clone(  id, toPid, null);
    }

    //克隆id节点到toPid ,可以指定新节点的id，也可以不指定
    public String  clone (String id , String toPid , String newid ) throws Exception
    {
        if( newid==null)   newid= DataStoreFactory.newGUID();

        DataStore ds1= DataStoreFactory.newDataStore(con,"select * from "+this.table+" where id='"+id+"' ");
        DataStore ds2= DataStoreFactory.newDataStore(con,"select * from "+this.table );

        ds1.retrieve();
        if( ds1.getRowCount()!=1)  throw new Exception( id+"节点不存在");

        String fromPid= ds1.getString(0,"pid");
        String name= ds1.getString(0,"name");
        String code= ds1.getString(0,"code");


        ds2.setUpdateProperty(table,"id","*","id");
        ds2.insertRow(0);
        // app_rolek 有 appid ， corporationid
        // app_bill中有  appid 都是需要复制的
        String[] cols=new String[]{  "innerorder","nodetype","metadata","mimetype","value","createdate" ,"appid" , "corporationid" };


        ds2.setValue(0,"id", newid );
        ds2.setValue(0,"pid", toPid);
        for( int i=0;i< cols.length;i++)
        {
            ds2.setValue(0,cols[i],  ds1.getValue(0,cols[i]));
        }
        //对name做处理
        //如果在同一父级下，名称要做处理

        if(fromPid.equals(toPid))  name=name+"clone"+FF.get_yyyyMMddHHmmss_noDotFormatedString(new Date());
        ds2.setValue(0,"name",name);

        if( !code.isEmpty())
        {
            code= code+FF.get_yyyyMMddHHmmss_noDotFormatedString(new Date());
            ds2.setValue(0,"code",code);
        }

        ds2.setValue(0,"pid", toPid);

        if( ! ds2.update(true)) throw new Exception( ds2.getError().getMessage());
        //单个节点克隆完成 ，下面克隆子项

        DataStore dsSub=   DataStoreFactory.newDataStore(con, "select id from "+ table+" where  pid='"+id+"'");
        int n= dsSub.retrieve();

        ArrayList<String> subIDList= new ArrayList<>();
        for( int i=0;i<n;i++)
        {
            subIDList.add( dsSub.getString(i,"id"));
        }

        //不是很必要，但是下面将进入递归，所以先标记成无用的，避免在递归结束后，对象才变成无引用的
        ds1=null;
        ds2=null;
        dsSub=null;

        //克隆子项
        for( int i=0;i<subIDList.size();i++)
        {
            clone( subIDList.get(i) , newid);
        }


        return newid;

    }

    public boolean subExists(String name)
    {

        name = name.trim();

        int n = ds.retrieve("pid='" + currentId + "' and name='" + name + "' ");
        return n > 0;


    }



    public void setPosition(String id, String pid)
    {
        this.currentPid = pid;
        this.currentId = id;
        this.appid= FF.getStringFromSQL("","select appid from "+ this.table+" where id='"+ id+"' ");
        ds.retrieve(" id='"+ id+"'");
    }

    public void setPosition(String id)
    {
        String pid= FF.getStringFromSQL(this.con , "select pid from "+this.table+" where id='"+id+"'");
        if( pid.isEmpty()) pid="0";
        setPosition(id,pid);
    }

    private boolean createNode(    String pid, String name, String nodeType, String value   )
    {

        return    createNode(     pid,   name,   nodeType,   value,  null );
    }
    private boolean createNode(   String pid, String name, String nodeType, String value,String code )
    {
        int row = ds.insertRow(0);
        String newID = DataStoreFactory.newGUID();
        ds.setConnection(con);
        ds.setValue(row, "id", newID);
        ds.setValue(row, "pid", pid);
        //appid 字段可能不存在，不存在也没有关系，有就设置成上级一样的appid
        ds.setValue(row, "appid",  appid);

        ds.setValue(row, "name", name.trim());
        if( code!=null)  ds.setValue(row, "code", code);  // 有的控制了，如果 不为null则不允许重复，所以要判断 一下

        ds.setValue(row, "innerorder", System.currentTimeMillis());
        ds.setValue(row, "nodetype", nodeType.trim());
        ds.setValue(row, "value", value.trim());
        ds.setValue(row, "createdate", new Date());
        ds.setValue(row, "modifydate", new Date());
        boolean ok = ds.update(true);
        if (!ok)
        {
            FF.log("<font color=red>增加:" + name + "失败，原因：" + ds.getError().getMessage()+"</font>");
            FF.log(FF.stackTrace());
        }
        return ok;
    }

    public Config back()
    {

        if (currentPid.equals("0")) //就在第一层，再回退就退到根了，而根可能是虚的，不存在
        {
            currentId = "0";
            currentPid = "0";
            return this;
        }


        ds.retrieve("id='" + currentPid + "'");
        currentId = ds.getString(0, "id");
        currentPid = ds.getString(0, "pid");
        appid= ds.getString(0,"appid");

        return this;


    }

    public Config set(String key, String value)
    {
        return set(key, value, "leaf");
    }

    public Config set(String key, String value ,String nodeType)
    {
        return set(key, value, nodeType , null);
    }

    //设置属性，并不改变当前目录
    public Config set(String key, String value, String nodeType ,String code)
    {

        key = key.trim();
        value = value.trim();
        nodeType = nodeType.trim();


        int n = ds.retrieve("pid='" + currentId + "' and name='" + key + "' ");
        if (n == 0)
        {
            //FF.log("pid='" + currentId + "' and name='" + key + "'  不存在，创建它");
            createNode(   currentId, key, nodeType, value ,code);
            modified = true; //表示对key是真的做了修改
        }
        else
        {
            //它是一个目录，也有属性值
            if (ds.getString(0, "nodetype").equals("node")) ds.setValue(0, "nodetype", "withleafnode");
            if (!nodeType.isEmpty()) ds.setValue(0, "nodetype", nodeType);
            ds.setValue(0, "modifydate", new Date());
            ds.setValue(0, "value", value);
            if( code!=null)  ds.setValue(0,"code", code);
            modified = ds.isDataModified(0, "value"); ////表示对key是真的做了修改 , 可能其它程序需要知道这个设置是不是真正修改了数据
            if (!ds.update(true)) FF.log("更新:" + key + "失败，原因：" + ds.getError().getMessage());

            //FF.log("pid=" + currentId + " and name='" + key + "'   已存在，更新它  ， value=" + value);
        }


        return this;
    }


    /**
     * 这个函数仅用在 app_customproperty中
     * @param key
     * @param value
     * @return
     */
    public Config setMetaData(String key, String value)
    {
        return setMetaData(key, value, "leaf");
    }
    //设置属性，并不改变当前目录
    public Config setMetaData(String key, String value, String nodeType)
    {

        key = key.trim();
        value = value.trim();
        nodeType = nodeType.trim();

        String where = "pid='" + currentId + "' and name='" + key + "' ";
        int n = ds.retrieve(where);
        if (n == 0)
        {
            //FF.log("pid='" + currentId + "' and name='" + key + "'  不存在，创建它");
            createNode(con, currentId, key, nodeType, "");
            modified = true; //表示对key是真的做了修改
            ds.retrieve(where);
        }

        //它是一个目录，也有属性值

        if (!nodeType.isEmpty()) ds.setValue(0, "nodetype", nodeType);
        ds.setValue(0, "modifydate", new Date());
        ds.setValue(0, "metadata", value);
        modified = ds.isDataModified(0, "metadata"); ////表示对key是真的做了修改 , 可能其它程序需要知道这个设置是不是真正修改了数据
        if (!ds.update(true)) FF.log("更新:" + key + "的 metadata 失败，原因：" + ds.getError().getMessage());


        return this;
    }


    //上一次的set(key,value)是不是真正修改了数据
    public boolean lastSetReallyModified()
    {
        return modified;
    }

    public String get(String key, String defaultValue)
    {

        key = key.trim();
        defaultValue = defaultValue.trim();

        if( key.isEmpty())
        {
            ds.retrieve( " id='"+ currentId+"' ");
            return ds.getString(0,"value");
        }

        int n = ds.retrieve("pid='" + currentId + "' and name='" + key + "' ");
        if (n == 0)
        {
            //FF.log("pid='" + currentId + "' and name='" + key + "'  不存在， 返回缺省值：" + defaultValue);
            return defaultValue;
        }
        //FF.log("pid='" + currentId + "' and name='" + key + "'  存在，  值：" + ds.getString(0, "value"));
        return ds.getString(0, "value");

    }


    public Config set(String key, int value)
    {
        return set(key, "" + value);
    }

    public Config set(String key, int value, String nodeType)
    {
        return set(key, "" + value, nodeType);
    }

    public Config set(String key, boolean value)
    {
        return set(key, value ? "true" : "false");
    }

    public Config set(String key, boolean value, String nodeType)
    {
        return set(key, value ? "true" : "false", nodeType);
    }

    public int get(String key, int defaultValue)
    {
        String v = get(key, "");
        if (v.isEmpty()) return defaultValue;
        return FF.String2Int(v);
    }

    public boolean get(String key, boolean defaultValue)
    {
        String v = get(key, "");
        if (v.isEmpty()) return defaultValue;
        return v.equals("true");

    }

    public ArrayList<String> subKeys()
    {
        ArrayList<String> list = new ArrayList<String>();

        //只检索name字段，避免子项目太多，检索太多的value影响速度
        DataStore tds = DataStoreFactory.newDataStore(con, "select name  from " + table + " order by innerorder asc");
        int n = tds.retrieve("pid='" + currentId + "'");

        for (int i = 0; i < n; i++)
        {
            list.add(tds.getString(i, "name"));
        }

        return list;


    }

    /**
     * 不要一层层推进，直接一步到位查询
     *
     * @param fullname
     * @param defaultValue
     * @return
     */
    public String getByFullName(String fullname, String defaultValue)
    {

        fullname = fullname.trim();
        defaultValue = defaultValue.trim();

        int n = ds.retrieve("fullname='" + fullname + "' ");
        if (n == 0) return defaultValue;
        return ds.getString(0, "value");

    }


}
