package config;

import org.json.JSONObject;
import util.FF;
import util.ServiceUtil;
import webApp.App;
import websocketRPC.WSRPC;

import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class CacheResource
{

    //不要有数据库的操作，
    public static ConcurrentHashMap<String ,String> config = new ConcurrentHashMap<>();

    public static  long  lastModifiedDate=0;

    public static void  reloadConfig()
    {
        //现在仅app需要 ， 不排除以以后会变化
       // if(! App.appName.equals("app"))
      //  {
       //     FF.log(App.appName+"不需要缓存资源，忽略");

       // }

        FF.log(App.appName+"缓存资源...");
        while (true)
        {
            if (ServiceUtil.serviceIsReady("config")) break;
            FF.log("CacheResource.loadConfig 需等待config服务可用，config不可用，等待一会儿再尝试");
            FF.sleep(5000);
        }

        JSONObject ret= WSRPC.dispatch("config","service.AppConfig","getAppResource" ,
                new JSONObject(), null, null, false);


        JSONObject data= ret.getJSONObject("data",new JSONObject());
        Iterator<String> it= data.keys();
        while( it.hasNext())
        {
            String key= it.next();
            String value= data.getString(key,"");

            config.put(key , value);
        }

        lastModifiedDate= System.currentTimeMillis();
    }


    
    public static   String  get(String fullname , String defaultValue)
    {
        if( config.containsKey(fullname)) return config.get(fullname);
        return defaultValue;
    }


}
